/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.logging.Log;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.string.StringModifierUtils;
import agorum.commons.system.SystemProperties;
import agorum.commons.utils.LockMaster;
import agorum.commons.utils.TempFile;
import agorum.documentservice.client.common.DefaultDocumentServiceStatisticHolder;
import agorum.documentservice.client.common.DocumentServiceStatistic;
import agorum.documentservice.client.common.DocumentServiceStatisticHolder;
import agorum.roi.common.utils.TemplateUtil;
import agorum.roi.ejb.client.beans.DocumentTextObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.DocumentTextPlainTextParserInterface;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import agorum.roi.pdf.PdfLoader;
import agorum.roi.preview.PreviewHelperGateway;
import agorum.roi.preview.PreviewInterface;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.util.PDFTextStripper;

public class DocumentTextHelper {
    private static final String STICKY_ERROR_OCR_NOT_RUNNING = "STICKY_ERROR_OCR_NOT_RUNNING";
    private static SessionController sc = null;
    public static Object connectLock = new Object();
    private static LockMaster<String> lockPool = new LockMaster();
    private final DocumentServiceStatisticHolder statistic;
    private static final DocumentServiceStatistic dsstatistic = DocumentServiceStatistic.getInstance();
    public static TextExtractor extractor;

    @Deprecated
    public DocumentTextHelper() {
        this.statistic = new DefaultDocumentServiceStatisticHolder();
    }

    public DocumentTextHelper(DocumentServiceStatisticHolder statistic) {
        this.statistic = statistic;
    }

    public DocumentTextObjectClientBean createDocumentText(GlobalObjectClientBean globalObject, boolean updateIfNeeded, boolean createIfNeeded, boolean forceCreate) throws Exception {
        return this.createDocumentTextThreaded(globalObject, "TXT", null, updateIfNeeded, createIfNeeded, forceCreate, false);
    }

    private File unzipContentTxt(File inFile) throws Exception {
        File tf = null;
        try {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                int size;
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("content.txt")) continue;
                byte[] buffer = new byte[2048];
                tf = TempFile.createTempFile((long)6000000L);
                FileOutputStream fos = new FileOutputStream(tf);
                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, size);
                }
                fos.flush();
                fos.close();
                break;
            }
            zis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tf;
    }

    public static boolean isFresh(GlobalObjectClientBean globalObject, DocumentTextObjectClientBean documentText) throws Exception {
        if (documentText != null) {
            return DocumentTextHelper.getReferenceDate(globalObject).equals(documentText.getLastContentModifyDate());
        }
        return false;
    }

    public static Date getReferenceDate(GlobalObjectClientBean globalObject) throws Exception {
        if (globalObject instanceof ContentInterface) {
            return ((ContentInterface)((Object)globalObject)).getLastContentModifyDate();
        }
        return globalObject.getLastModifyDate();
    }

    public boolean documentTextNeedsUpdate(GlobalObjectClientBean globalObject, DocumentTextObjectClientBean docTO) throws Exception {
        return !DocumentTextHelper.isFresh(globalObject, docTO);
    }

    public DocumentTextObjectClientBean updateDocumentText(GlobalObjectClientBean globalObject, boolean fast) throws Exception {
        return this.createDocumentTextThreaded(globalObject, "TXT", null, true, true, false, fast);
    }

    public DocumentTextObjectClientBean createDocumentTextThreaded(GlobalObjectClientBean globalObject, String textFormat, boolean updateIfNeeded, boolean createIfNeeded, boolean forceCreate) throws Exception {
        return this.createDocumentTextThreaded(globalObject, textFormat, null, updateIfNeeded, createIfNeeded, forceCreate, false);
    }

    /*
     * Exception decompiling
     */
    private DocumentTextObjectClientBean createDocumentTextThreaded(GlobalObjectClientBean globalObject, String textFormat, String[] parameters, boolean updateIfNeeded, boolean createIfNeeded, boolean forceCreate, boolean fast) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 120[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void savePreview(File orgFile, GlobalObjectClientBean globalObject, Date timestamp) throws Exception {
        PreviewHelperGateway phg = new PreviewHelperGateway();
        if (phg.isPreviewInstalled()) {
            PreviewInterface pi = phg.getPreviewInterface();
            if (!pi.shouldUsePreviewFromOcr()) {
                return;
            }
            try {
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(orgFile)));
                ZipEntry entry = null;
                int pageAmount = 0;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory() || !entry.getName().toLowerCase().startsWith("image_")) continue;
                    File tf = TempFile.createTempFile((long)6000000L);
                    BufferedImage image = ImageIO.read(zis);
                    ImageIO.write((RenderedImage)image, "jpg", tf);
                    String n = entry.getName();
                    n = n.substring(n.indexOf("_") + 1);
                    n = n.substring(0, n.indexOf("."));
                    int page = Integer.parseInt(n);
                    ++pageAmount;
                    pi.createMasterImage(page, globalObject, tf, timestamp);
                    tf.delete();
                }
                zis.close();
                DocumentTextHelper.log("OCR (" + pageAmount + ")", globalObject, this.statistic.create);
                try {
                    MessageUtils mu = new MessageUtils();
                    mu.sendCloudEvent("" + globalObject.getId(), globalObject.getSessionController().getLoginUserId(), "EVENT_PAGE_OCR", "OCR", pageAmount, "OCR: " + globalObject.getId());
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasValidOutputPdf(File zip) throws IOException {
        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
        var3_3 = null;
        try {
            block12: while (true) {
                if ((entry = zis.getNextEntry()) == null) return false;
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("output.pdf")) continue;
                document = PdfLoader.load(zis);
                stripper = new PDFTextStripper();
                page = 1;
                while (true) {
                    if (page <= document.getNumberOfPages()) ** break;
                    continue block12;
                    stripper.setStartPage(page);
                    stripper.setEndPage(page);
                    sw = new StringWriter();
                    stripper.writeText(document, (Writer)sw);
                    if (sw.getBuffer().length() > 0) {
                        var9_11 = true;
                        return var9_11;
                    }
                    ++page;
                }
                break;
            }
        }
        catch (Throwable var4_6) {
            var3_3 = var4_6;
            throw var4_6;
        }
        finally {
            if (zis != null) {
                if (var3_3 != null) {
                    try {
                        zis.close();
                    }
                    catch (Throwable var10_12) {
                        var3_3.addSuppressed(var10_12);
                    }
                } else {
                    zis.close();
                }
            }
        }
    }

    private SaveType savePDF(GlobalObjectClientBean globalObject) throws Exception {
        MetaDb metaDb = globalObject.getSessionController().getMetaDbInstance();
        String baseKey = "MAIN_MODULE_MANAGEMENT/documentservice/control/services/settings/ocr/";
        boolean overWrite = false;
        try {
            overWrite = Boolean.parseBoolean(metaDb.getSimplePropertyValue(baseKey + "OCRPdfOverwriteExistingFile")[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (overWrite) {
            boolean allowConversion = false;
            try {
                allowConversion = Boolean.parseBoolean(metaDb.getSimplePropertyValue(baseKey + "OCRPdfAllowConversion")[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(allowConversion || globalObject instanceof ContentInterface && "application/pdf".equals(((ContentInterface)((Object)globalObject)).getFormat().getMimeType()))) {
                return SaveType.NONE;
            }
        }
        String[] classNames = null;
        try {
            classNames = metaDb.getSimplePropertyValue(baseKey + "OCRPdfClassNames");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = globalObject.getClassName();
        if (classNames != null) {
            for (String cn : classNames) {
                if (!cn.equalsIgnoreCase(className)) continue;
                return overWrite ? SaveType.OVERWRITE : SaveType.NEW;
            }
        }
        return SaveType.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GlobalObjectClientBean savePDF(File orgFile, GlobalObjectClientBean globalObject) {
        try {
            SaveType saveType = this.savePDF(globalObject);
            if (saveType == SaveType.NONE) return null;
            if (!this.hasValidOutputPdf(orgFile)) {
                return null;
            }
            MetaDb metaDb = globalObject.getSessionController().getMetaDbInstance();
            String baseKey = "MAIN_MODULE_MANAGEMENT/documentservice/control/services/settings/ocr/";
            boolean overWrite = saveType == SaveType.OVERWRITE;
            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(orgFile)));){
                ZipEntry entry;
                do {
                    if ((entry = zis.getNextEntry()) == null) return null;
                } while (entry.isDirectory() || !entry.getName().equalsIgnoreCase("output.pdf"));
                RoiFileSystem rfs = new RoiFileSystem(globalObject.getSessionController());
                String pdfName = metaDb.getSimplePropertyValue(baseKey + "OCRPdfSaveAs")[0];
                pdfName = TemplateUtil.fillTemplate(globalObject, pdfName);
                if ((pdfName = StringModifierUtils.filterFileNameChars((String)pdfName)).lastIndexOf(".") > -1) {
                    pdfName = pdfName.substring(0, pdfName.lastIndexOf("."));
                }
                pdfName = pdfName + ".pdf";
                String uniqueName = rfs.getUniqueName(globalObject.getMainObject().getParents(), overWrite ? globalObject : null, pdfName);
                FileObjectSessionFacade fosf = new FileObjectSessionFacade(globalObject.getSessionController());
                fosf.setWithTransaction(true);
                fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, uniqueName);
                fosf.setContentStream(zis);
                if (overWrite) {
                    fosf.setGlobalObject(globalObject);
                    fosf.setSystemOption("forceMakeHistory", "true");
                    fosf.setFormat(globalObject.getSessionController().getFormatByFileName(uniqueName));
                    fosf.update();
                    GlobalObjectClientBean globalObjectClientBean = null;
                    return globalObjectClientBean;
                }
                fosf.setDestinationFolder(globalObject.getMainObject().getFirstParent());
                GlobalObjectClientBean newObject = fosf.create();
                newObject.setAttachments(new GlobalObjectClientBean[]{globalObject});
                GlobalObjectClientBean globalObjectClientBean = newObject;
                return globalObjectClientBean;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DocumentTextObjectClientBean createDocumentTextInSeparateTransaction(GlobalObjectClientBean globalObject, String textFormat, boolean updateIfNeeded, boolean createIfNeeded, boolean forceCreate) throws Exception {
        return this.createDocumentTextInSeparateTransaction(globalObject, textFormat, null, updateIfNeeded, createIfNeeded, forceCreate);
    }

    public DocumentTextObjectClientBean createDocumentTextInSeparateTransaction(final GlobalObjectClientBean globalObject, final String textFormat, final String[] parameters, final boolean updateIfNeeded, final boolean createIfNeeded, final boolean forceCreate) throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        DocumentTextObjectClientBean result = service.submit(new Callable<DocumentTextObjectClientBean>(){

            @Override
            public DocumentTextObjectClientBean call() throws Exception {
                return new DocumentTextHelper(DocumentTextHelper.this.statistic).createDocumentTextThreaded(globalObject, textFormat, parameters, updateIfNeeded, createIfNeeded, forceCreate, false);
            }
        }).get();
        service.shutdown();
        return result;
    }

    public String getDocumentText(GlobalObjectClientBean globalObject, boolean updateIfNeeded, boolean createIfNeeded, int maxBytes) throws Exception {
        return this.getDocumentText(globalObject, updateIfNeeded, createIfNeeded, maxBytes, false);
    }

    public String getDocumentText(GlobalObjectClientBean globalObject, boolean updateIfNeeded, boolean createIfNeeded, int maxBytes, boolean forceCreate) throws Exception {
        String s = null;
        if (!(globalObject instanceof DocumentTextObjectClientBean)) {
            DocumentTextObjectClientBean dto = this.createDocumentText(globalObject, updateIfNeeded, createIfNeeded, forceCreate);
            s = this.getDocumentText(dto, globalObject, maxBytes);
        }
        return s;
    }

    public String getDocumentText(DocumentTextObjectClientBean dto, GlobalObjectClientBean globalObject) throws Exception {
        int maxAmount = 0x500000;
        try {
            MetaDb metaDb = globalObject.getSessionController().getMetaDbInstance();
            maxAmount = Integer.parseInt(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/MaxDocumentSize")[0]);
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
        }
        return this.getDocumentText(dto, globalObject, maxAmount);
    }

    public String getDocumentText(DocumentTextObjectClientBean dto, GlobalObjectClientBean globalObject, int maxBytes) throws Exception {
        String s = null;
        if (dto != null) {
            DocumentTextPlainTextParserInterface dtptpIface = DocumentTextHelper.getPlainTextParser(dto);
            s = dtptpIface != null ? dtptpIface.getPlainText(dto, globalObject, maxBytes) : this.getTextFromInputStream(dto.getContentStream(), maxBytes);
        }
        return s;
    }

    public static DocumentTextPlainTextParserInterface getPlainTextParser(DocumentTextObjectClientBean dto) throws Exception {
        DocumentTextPlainTextParserInterface dtptpIface = null;
        String className = null;
        try {
            String dtoName = dto.getName();
            String dtoExtension = dtoName.substring(dtoName.indexOf(".") + 1);
            MetaDb metaDb = dto.getSessionController().getMetaDbInstance();
            className = metaDb.getString("MAIN_MODULE_MANAGEMENT/documentservice/control/common/documenttexthandler/" + dtoExtension + "/PlainTextParserClass");
        }
        catch (Exception e) {
            Log.warning((Throwable)e);
        }
        if (className != null) {
            Class<?> clazz = Class.forName(className);
            dtptpIface = (DocumentTextPlainTextParserInterface)clazz.newInstance();
        }
        return dtptpIface;
    }

    public String getDocumentRawText(GlobalObjectClientBean globalObject, boolean updateIfNeeded, boolean createIfNeeded, int maxBytes, boolean forceCreate) throws Exception {
        DocumentTextObjectClientBean dto;
        String s = null;
        if (!(globalObject instanceof DocumentTextObjectClientBean) && (dto = this.createDocumentText(globalObject, updateIfNeeded, createIfNeeded, forceCreate)) != null) {
            s = this.getTextFromInputStream(dto.getContentStream(), maxBytes);
        }
        return s;
    }

    private String getTextFromInputStream(InputStream is, int maxBytes) throws IOException {
        StringBuffer text = new StringBuffer();
        if (is != null) {
            try (InputStreamReader isr = new InputStreamReader(is, SystemProperties.getCharset());){
                int read;
                char[] cbuf = new char[1024];
                int amount = 0;
                while ((read = isr.read(cbuf, 0, 1024)) >= 0) {
                    text.append(cbuf, 0, read);
                    if (maxBytes == -1 || (amount += read) <= maxBytes) continue;
                    text.append("....");
                    break;
                }
            }
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect() throws Exception {
        Object object = connectLock;
        synchronized (object) {
            if (sc == null) {
                try {
                    RoiProperties rp = new RoiProperties();
                    CredentialObject credential = new CredentialObject();
                    credential.setUserName(rp.getRoiSystemUser());
                    credential.setAuthInterface(new ServiceAuthInterface());
                    credential.setModulInfo("DocumentTextHelper");
                    sc = SessionController.connect(credential);
                }
                catch (Exception e) {
                    sc = null;
                }
            } else {
                sc.reconnectIfNeeded();
            }
        }
    }

    private static void log(String tag, GlobalObjectClientBean object, SystemStatistic stat) throws Exception {
        if (stat.logInfo()) {
            stat.info().object((SystemObjectReference)object).send("DocumentText - " + tag + ": " + object.getName());
        }
    }

    public static void setTimestamp(GlobalObjectClientBean obj, Date timestamp) throws Exception {
        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)obj.getNewDefinition(obj.getSessionController());
        def.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(timestamp));
        def.setAttribute(FileObjectClientBean.LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(timestamp));
        obj.update(def);
    }

    private static /* synthetic */ void lambda$createDocumentTextThreaded$1(DocumentTextPlainTextParserInterface parser, DocumentTextObjectClientBean myDto, GlobalObjectClientBean myObj) throws Exception {
        block14: {
            try (Transaction myT = new Transaction();){
                parser.postProcess(myDto, myObj);
                myT.commit();
            }
            catch (RoiException e) {
                if (e.getErrorCode() == 101) break block14;
                throw e;
            }
        }
    }

    private static /* synthetic */ Object lambda$createDocumentTextThreaded$0(GlobalObjectClientBean finalGlobalObject) throws Exception {
        finalGlobalObject.lock(4, null, true);
        return null;
    }

    static {
        try {
            Class.forName("agorum.docform.common.DocForm").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static enum SaveType {
        NONE,
        OVERWRITE,
        NEW;

    }

    public static interface TextExtractor {
        public DocumentTextObjectClientBean extract(GlobalObjectClientBean var1) throws Exception;
    }
}

