/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.pdf.PdfLoader;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class ContentTaskPDFExtractor
implements ContentTaskInterface {
    private static final String key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PDF";

    @Override
    public void runTask(SessionController sessionController, ContentInterface contentInterface, boolean doDelete) throws Exception {
        if (contentInterface instanceof GlobalObjectClientBean) {
            try {
                InputStream is;
                PDDocument doc;
                PDDocumentInformation info;
                MetaDb metaDb = sessionController.getMetaDbInstance();
                String[] properties = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PDF/DocumentProperties");
                String[] mapping = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PDF/ExtendedAttributeMapping");
                boolean override = Boolean.parseBoolean(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PDF/OverrideOldMetaData")[0]);
                if (properties.length != mapping.length) {
                    throw new Exception("Error: Properties list has to be same length then mapping list");
                }
                System.out.println("ContentTask PDFExtract: Start Extraction");
                GlobalObjectClientBean content = (GlobalObjectClientBean)((Object)contentInterface);
                if (override) {
                    GlobalObjectSessionFacade gosf = new GlobalObjectSessionFacade(sessionController);
                    gosf.setGlobalObject(content);
                    for (int j = 0; j < mapping.length; ++j) {
                        gosf.removeExtendedAttribute(mapping[j]);
                    }
                    gosf.update();
                }
                if ((info = (doc = PdfLoader.load(is = contentInterface.getContentStream())).getDocumentInformation()) == null) {
                    throw new Exception("PDFExtractor Error: document information of " + content.getName() + " not readable.");
                }
                for (int i = 0; i < properties.length; ++i) {
                    AttributeValue av;
                    String metaValue = info.getCustomMetadataValue(properties[i]);
                    if (!override && (av = content.getExtendedAttribute(mapping[i])) != null) {
                        metaValue = null;
                    }
                    if (metaValue == null || metaValue.isEmpty()) continue;
                    content.setExtendedAttribute(mapping[i], AttributeValue.newAttributeValueObject(metaValue), true);
                }
                content.saveExtendedAttributes();
                is.close();
                System.out.println("ContentTask PDFExtract: Finished Extraction");
            }
            catch (IOException e) {
                System.out.println("Beschreibung der Datei konnte nicht gelesen werden: " + contentInterface.getName());
            }
        }
    }
}

