/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.string.StringConverterUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.EngineContext;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ContentTaskJsConverter
implements ContentTaskInterface {
    @Override
    public void runTask(SessionController sessionController, ContentInterface contentInterface, boolean doDelete) throws Exception {
        if (!(contentInterface instanceof GlobalObjectClientBean)) {
            return;
        }
        GlobalObjectClientBean globalObject = (GlobalObjectClientBean)((Object)contentInterface);
        FolderObjectClientBean folder = null;
        try {
            folder = globalObject.getParents()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (folder == null) {
            return;
        }
        String name = contentInterface.getName();
        String parseErrorName = "." + name + ".parseError.txt";
        EngineContext context = new EngineContext(false, sessionController);
        try {
            context.put("sessionController", sessionController);
            context.put("sc", sessionController);
            context.put("sessionControllerAdmin", sessionController);
            context.put("sca", sessionController);
            context.put("folder", folder);
            context.exec(contentInterface);
            this.deleteFile(sessionController, parseErrorName, folder);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.createFile(sessionController, parseErrorName, folder, sw.toString());
        }
        if (doDelete) {
            globalObject.deleteDeferred();
        }
    }

    private FileObjectClientBean createFile(SessionController sessionController, String name, FolderObjectClientBean folder, String content) throws Exception {
        GlobalObjectClientBean existing = folder.getItem(name);
        FileObjectSessionFacade fileSessionFacade = new FileObjectSessionFacade(sessionController);
        if (existing != null) {
            fileSessionFacade.setGlobalObject(existing);
        }
        fileSessionFacade.setWithTransaction(true);
        fileSessionFacade.setDestinationFolder(folder);
        fileSessionFacade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
        fileSessionFacade.setContentStream(StringConverterUtils.toStream((String)content, (String)"UTF-8"));
        if (existing == null) {
            return (FileObjectClientBean)fileSessionFacade.create();
        }
        return (FileObjectClientBean)fileSessionFacade.update();
    }

    private void deleteFile(SessionController sessionController, String name, FolderObjectClientBean folder) throws Exception {
        GlobalObjectClientBean existing = folder.getItem(name);
        if (existing != null) {
            SuperObjectClientBeanDefinition def = existing.getDefinition(sessionController);
            def.setSystemOption("parentFolderOfDeleteObject", folder);
            existing.delete(def);
        }
    }
}

