/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.SessionController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ContentCacheHolder {
    public static long swapInstanceNumber = 0L;
    private SessionController sessionController = null;
    private Long id = null;
    private long blockNumber = 0L;
    private String tableName = null;
    private boolean hadWrites = false;
    private byte[] buffer = null;
    private int lastBytePos = -1;
    private int firstBytePos = 0;
    private int blockSize = 0;
    private boolean isSwapped = false;
    private String swapName = null;
    private long blockLength = 0L;
    private int bufferLength = 0;
    public Object syncer = new Object();

    public ContentCacheHolder(SessionController sessionController, Long id, long blockNumber, String tableName, int blockSize) {
        this.sessionController = sessionController;
        this.id = id;
        this.blockNumber = blockNumber;
        this.tableName = tableName;
        this.blockSize = blockSize;
        this.firstBytePos = blockSize + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransferBean(ContentTransferBean ctb) {
        Object object = this.syncer;
        synchronized (object) {
            this.reactivateSwap();
            if (this.buffer == null) {
                this.buffer = new byte[this.blockSize];
            }
            if (!this.hadWrites) {
                this.hadWrites = ctb.getHasBeenModified();
            }
            if ((int)ctb.getFirstBytePos() < this.firstBytePos) {
                this.firstBytePos = (int)ctb.getFirstBytePos();
            }
            if ((long)ctb.getModifiedLength() + ctb.getFirstBytePos() > (long)this.lastBytePos) {
                this.lastBytePos = (int)((long)ctb.getModifiedLength() + ctb.getFirstBytePos());
            }
            this.bufferLength = ctb.getBufferLength();
            if (ctb.getBuffer() != null) {
                int bufSize = ctb.getBuffer().length;
                System.arraycopy(ctb.getBuffer(), 0, this.buffer, 0, bufSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTransferBean buildTransferBean(boolean forStore) {
        ContentTransferBean ctb = null;
        Object object = this.syncer;
        synchronized (object) {
            this.reactivateSwap();
            if (forStore) {
                System.err.println("buildTransferBean : blockNumber=" + this.blockNumber);
                byte[] tmpBuffer = this.buffer;
                ctb = new ContentTransferBean(this.buffer, this.bufferLength);
                ctb.setFirstBytePos(this.firstBytePos);
                ctb.setHasBeenModified(this.hadWrites);
                ctb.setIsEmptyBlock(false);
                ctb.setIsFilled(true);
                ctb.setModifiedLength(this.lastBytePos - this.firstBytePos);
                if (this.firstBytePos != 0) {
                    System.err.println("buildTransferBean : arraycopy");
                    int bufLen = this.buffer.length;
                    tmpBuffer = new byte[bufLen];
                    System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.bufferLength);
                    ctb.setBuffer(tmpBuffer);
                }
            } else {
                ctb = new ContentTransferBean(this.buffer, this.bufferLength);
                ctb.setIsEmptyBlock(false);
                ctb.setIsFilled(true);
            }
        }
        return ctb;
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    public void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean getHadWrites() {
        return this.hadWrites;
    }

    public void setHadWrites(boolean hadWrites) {
        this.hadWrites = hadWrites;
    }

    public byte[] getBuffer() {
        this.reactivateSwap();
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.invalidate();
        this.buffer = buffer;
    }

    public int getLastBytePos() {
        return this.lastBytePos;
    }

    public void setLastBytePos(int lastBytePos) {
        this.lastBytePos = lastBytePos;
    }

    public int getFirstBytePos() {
        return this.firstBytePos;
    }

    public void setFirstBytePos(int firstBytePos) {
        this.firstBytePos = firstBytePos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap() {
        Object object = this.syncer;
        synchronized (object) {
            if (!this.isSwapped) {
                this.isSwapped = true;
                this.swapName = "ContentSwap_" + ContentCacheHolder.getSwapInstanceNumber();
                try {
                    FileOutputStream fos = new FileOutputStream(this.swapName);
                    fos.write(this.buffer, 0, this.blockSize);
                    fos.flush();
                    fos.close();
                    fos = null;
                    this.buffer = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.syncer;
        synchronized (object) {
            if (this.isSwapped && this.swapName != null) {
                try {
                    File file = new File(this.swapName);
                    file.delete();
                    file = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.swapName = null;
            this.isSwapped = false;
        }
    }

    private void reactivateSwap() {
        if (this.isSwapped && this.swapName != null) {
            try {
                this.buffer = new byte[this.blockSize];
                FileInputStream fis = new FileInputStream(this.swapName);
                int read = fis.read(this.buffer, 0, this.blockSize);
                fis.close();
                fis = null;
                File file = new File(this.swapName);
                file.delete();
                Object var3_4 = null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        this.swapName = null;
        this.isSwapped = false;
    }

    public static synchronized long getSwapInstanceNumber() {
        return ++swapInstanceNumber;
    }
}

