/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.ConnectionUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;

public class ConnectionWrapper
implements Connection {
    private Connection c;
    private ConnectionInfo info = threadConnection.get();
    private static ThreadLocal<ConnectionInfo> threadConnection = new ThreadLocal();

    ConnectionWrapper(DataSource dataSource) throws SQLException {
        if (this.info == null) {
            this.info = new ConnectionInfo(ConnectionUtils.getConnection(dataSource));
            threadConnection.set(this.info);
        } else {
            ++this.info.holdCount;
        }
        this.c = this.info.connection;
    }

    @Override
    public void close() throws SQLException {
        if (--this.info.holdCount <= 0) {
            this.c.close();
            threadConnection.remove();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.c.isClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.c.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.c.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.c.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.c.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.c.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.c.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.c.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.c.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.c.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.c.rollback();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.c.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.c.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.c.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.c.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.c.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.c.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.c.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.c.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.c.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.c.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.c.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.c.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.c.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.c.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.c.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.c.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.c.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.c.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.c.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.c.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.c.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.c.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.c.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.c.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.c.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.c.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.c.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.c.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.c.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.c.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.c.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.c.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.c.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.c.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.c.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.c.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.c.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.c.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.c.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.c.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.c.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.c.getNetworkTimeout();
    }

    private static class ConnectionInfo {
        Connection connection;
        int holdCount = 1;

        ConnectionInfo(Connection connection) {
            this.connection = connection;
        }
    }
}

