/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.encrypt.ntlm.DesEncryption;
import agorum.commons.encrypt.ntlm.EncoderHandler;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.string.StringUtils;
import agorum.commons.utils.ChallengeGenerator;
import agorum.commons.xml.XMLUtils;
import agorum.roi.auth.AuthenticatorFactory;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.PrimaryUserProfileObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ClassBasedAuthInterface;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialCallerBean;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialInfoBean;
import agorum.roi.ejb.common.CredentialManager;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CredentialPasswordBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiCredentialManager;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseCredentialManager
implements CredentialManager {
    protected boolean encodePassword = true;
    protected String credentialManagerName = null;
    private static final AuthenticatorFactory factory = AuthenticatorFactory.get("HTTP");
    public static Hashtable configCache = null;

    public void setCredentialManagerName(String name) {
        this.credentialManagerName = name;
    }

    @Override
    public boolean checkCredential(CredentialObject credential) {
        if (this.checkAuthInterface(credential.getAuthInterface())) {
            System.err.println("CheckCredential (ClassBasedAuth)");
            if (credential.getAuthInterface().isClassBasedAuthActive()) {
                return true;
            }
        }
        String user = credential.getUserName();
        String password = credential.getPassWord();
        if (user == null || password == null && credential.getCheckCredentialInterface() == null) {
            return false;
        }
        boolean b = false;
        try (Connection conn = new ConnectionUtils().getConnection(true);){
            String oldPassword = null;
            if (this.encodePassword && password != null) {
                password = this.getEncodedPassword(credential, password);
                oldPassword = this.getEncodedOldPassword(credential, password);
            }
            try (PreparedStatement pstmt = conn.prepareStatement("select DISTINGUISHEDNAME from ROICREDENTIALALIASES where ALIAS=?");){
                pstmt.setString(1, user.toUpperCase());
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        user = rs.getString(1);
                    }
                }
            }
            credential.setUserName(user);
            credential.setPassWord(password);
            credential.setOldPassword(oldPassword);
            if (credential.getCheckCredentialInterface() != null) {
                CredentialPasswordBean bean = this.getPasswordHashes(conn, credential);
                b = credential.getCheckCredentialInterface().checkCredential(credential, bean.getLmHash(), bean.getNtlmHash(), bean.getNgosPassword());
            } else {
                b = this.checkCredentialInternal(conn, credential);
            }
            if (!b && credential.getClearTextPassword() != null) {
                var9_13 = null;
                try (AuthenticatorFactory.Authenticator a = factory.getAuthenticator();){
                    a.auth(user, credential.getClearTextPassword());
                    b = a.isAuthenticated();
                    credential.setAuthenticatedExternally(b);
                }
                catch (Throwable throwable) {
                    var9_13 = throwable;
                    throw throwable;
                }
            }
            if (credential.isAuthenticatedExternally()) {
                credential.setAuthenticatedExternally(false);
                RoiCredentialManager.updatePasswordHashes(conn, credential);
            }
        }
        catch (NamingException e) {
            e.printStackTrace(System.err);
            System.err.println("\n-------------- Error in checkCredential ------\nDBRef does not exists\n-------------- Error in checkCredential ------\n\n");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return b;
    }

    private boolean checkAuthInterface(ClassBasedAuthInterface authInt) {
        String cn;
        boolean bRet = false;
        if (authInt != null && ((cn = authInt.getClass().getName()).equals("agorum.roi.autoupdate.service.AutoUpdateApplicationService") || cn.equals("agorum.roi.installation.InstallRoi") || cn.equals("agorum.roi.ejb.common.ServiceAuthInterface"))) {
            bRet = true;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCredentialManagerName(CredentialObject credential) {
        String credentialManager = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String user = credential.getUserName();
        if (user != null) {
            try {
                conn = new ConnectionUtils().getConnection(true);
                pstmt = conn.prepareStatement("select DISTINGUISHEDNAME from ROICREDENTIALALIASES where ALIAS=?");
                pstmt.setString(1, user.toUpperCase());
                rs = pstmt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        user = rs.getString(1);
                    }
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                String select = "select credentialmanager from DIRECTORYUSEROBJECT where DISTINGUISHEDNAME = ?";
                pstmt = conn.prepareStatement(select);
                pstmt.setString(1, user.toUpperCase());
                rs = pstmt.executeQuery();
                if (rs != null && rs.next()) {
                    credentialManager = rs.getString(1);
                }
                credential.setCredentialManager(credentialManager);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                try {
                    rs.close();
                    rs = null;
                }
                catch (Exception exception) {}
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return credentialManager;
    }

    public abstract boolean checkCredentialInternal(Connection var1, CredentialObject var2) throws Exception;

    public CredentialPasswordBean getPasswordHashes(Connection conn, CredentialObject credential) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCredential(SessionController sessionController, CredentialObject credential, CredentialCallerBean credentialCaller) throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        String user = credential.getUserName();
        String password = credential.getPassWord();
        StringUtils stringUtils = new StringUtils();
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            DesEncryption des = new DesEncryption();
            String lmHash = des.getBaseDESPassword(password);
            credential.setPassWord(lmHash);
            NTLMEncryption ntlm = new NTLMEncryption();
            String ntlmHash = stringUtils.toHexString(ntlm.getNTLMHash(password));
            this.createCredentialInternal(sessionController, credential, ntlmHash, conn, credentialCaller);
            String insert = "insert into ROICREDENTIALALIASES (ALIAS,DISTINGUISHEDNAME) values (?,?)";
            pstmt = conn.prepareStatement(insert);
            pstmt.setString(1, user.toUpperCase());
            pstmt.setString(2, user.toUpperCase());
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public abstract void createCredentialInternal(SessionController var1, CredentialObject var2, String var3, Connection var4, CredentialCallerBean var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredential(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            this.deleteCredentialInternal(sessionController, distinguisheName, conn);
            String delete = "delete from ROICREDENTIALALIASES where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(delete);
            pstmt.setString(1, distinguisheName);
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpCredential(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            this.deleteCredentialInternal(sessionController, distinguisheName, conn);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public abstract void deleteCredentialInternal(SessionController var1, String var2, Connection var3) throws Exception;

    @Override
    public String getEncodedNTPassword(SessionController sessionController, String password, String user) throws Exception {
        this.checkAccess(sessionController, user);
        DirectoryUserObjectClientBean du = sessionController.getUserByName(user);
        EncoderHandler eh = new EncoderHandler("" + du.getUUID(), "" + du.getUUID() + "/" + du.getUUID());
        return password == null ? null : eh.getEncodedPassword(password);
    }

    public String getDecodedNTPassword(SessionController sessionController, String ntPassword, DirectoryUserObjectClientBean user) throws Exception {
        String password = null;
        this.checkAccess(sessionController, user.getName());
        try {
            EncoderHandler eh = new EncoderHandler("" + user.getUUID(), "" + user.getUUID() + "/" + user.getUUID());
            password = eh.getPassword(ntPassword);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return password;
    }

    public String getDecodedNTPasswordOld(SessionController sessionController, String ntPassword, DirectoryUserObjectClientBean user) throws Exception {
        String password = null;
        this.checkAccess(sessionController, user.getName());
        try {
            PrimaryUserProfileObjectClientBean pup = user.getPrimrayUserProfile();
            FolderObjectClientBean homeFolder = pup.getHomeFolder();
            EncoderHandler eh = new EncoderHandler("" + user.getId(), "" + homeFolder.getId());
            password = eh.getPassword(ntPassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return password;
    }

    public void changeAgorumPassword(SessionController sessionController, String password, DirectoryUserObjectClientBean user) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection conn = cu.getConnection();){
            String update = "update ROICREDENTIALMANAGER set NTPASSWORD=? where DISTINGUISHEDNAME=?";
            try (PreparedStatement pstmt = conn.prepareStatement(update);){
                pstmt.setString(1, password);
                pstmt.setString(2, user.getDistinguishedName().toUpperCase());
                pstmt.execute();
            }
        }
    }

    @Override
    public void changePassword(SessionController sessionController, String distinguisheName, String newPassword, CredentialCallerBean credentialCaller) throws Exception {
        try (Transaction t = new Transaction();){
            this.checkAccess(sessionController, distinguisheName);
            if (distinguisheName.equalsIgnoreCase("roi")) {
                new RoiProperties().setRoiSystemPassword(newPassword);
            }
            if (distinguisheName.equalsIgnoreCase("guest")) {
                new RoiProperties().setRoiGuestPassword(newPassword);
            }
            this.updatePasswords(sessionController, distinguisheName, newPassword, credentialCaller);
            HashMap<Long, Map<String, Object>> attributes = new HashMap<Long, Map<String, Object>>();
            HashMap<String, AttributeValue> attrSub = new HashMap<String, AttributeValue>();
            attributes.put(1L, attrSub);
            attrSub.put("PASSWORD", AttributeValue.newAttributeValueObject(""));
            DirectoryUserObjectClientBean user = sessionController.getUserByName(distinguisheName);
            AuditUtil.createAuditEntry(user, sessionController.getLoginUser(), AuditUtil.ACTION_UPDATE, attributes);
            t.commit();
        }
    }

    public abstract void changePasswordInternal(SessionController var1, String var2, String var3, String var4, String var5, Connection var6, CredentialCallerBean var7) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeDistinguisheName(SessionController sessionController, String distinguisheNameOld, String distinguisheNameNew, CredentialCallerBean credentialCaller) throws Exception {
        this.checkAccess(sessionController, distinguisheNameOld);
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            this.changeDistinguisheNameInternal(sessionController, distinguisheNameNew, distinguisheNameOld, conn, credentialCaller);
            String update = "update ROICREDENTIALMANAGER set DISTINGUISHEDNAME=? where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(update);
            pstmt.setString(1, distinguisheNameNew.toUpperCase());
            pstmt.setString(2, distinguisheNameOld.toUpperCase());
            pstmt.execute();
            pstmt.close();
            pstmt = null;
            update = "update ROICREDENTIALALIASES set DISTINGUISHEDNAME=? where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(update);
            pstmt.setString(1, distinguisheNameNew.toUpperCase());
            pstmt.setString(2, distinguisheNameOld.toUpperCase());
            pstmt.execute();
            pstmt.close();
            pstmt = null;
            update = "update ROICREDENTIALALIASES set ALIAS=? where ALIAS=?";
            pstmt = conn.prepareStatement(update);
            pstmt.setString(1, distinguisheNameNew.toUpperCase());
            pstmt.setString(2, distinguisheNameOld.toUpperCase());
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public abstract void changeDistinguisheNameInternal(SessionController var1, String var2, String var3, Connection var4, CredentialCallerBean var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAliases(SessionController sessionController, String distinguisheName, String[] aliases) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String delete = "delete from ROICREDENTIALALIASES where DISTINGUISHEDNAME=? and alias != DISTINGUISHEDNAME";
            pstmt = conn.prepareStatement(delete);
            pstmt.setString(1, distinguisheName.toUpperCase());
            pstmt.execute();
            pstmt.close();
            pstmt = null;
            if (aliases != null && aliases.length > 0) {
                int len = aliases.length;
                for (int i = 0; i < len; ++i) {
                    if (aliases[i] == null || aliases[i].length() <= 0) continue;
                    String insert = "insert into ROICREDENTIALALIASES (ALIAS,DISTINGUISHEDNAME) values (?,?)";
                    pstmt = conn.prepareStatement(insert);
                    pstmt.setString(1, aliases[i].toUpperCase());
                    pstmt.setString(2, distinguisheName.toUpperCase());
                    pstmt.execute();
                    pstmt.close();
                    pstmt = null;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAliases(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ConnectionUtils cu = null;
        String[] aliases = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String select = "select alias from ROICREDENTIALALIASES where DISTINGUISHEDNAME=? and alias != DISTINGUISHEDNAME";
            pstmt = conn.prepareStatement(select);
            pstmt.setString(1, distinguisheName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            Vector<String> v = new Vector<String>();
            if (rs != null) {
                while (rs.next()) {
                    String s = rs.getString(1);
                    if (s == null || s.length() <= 0) continue;
                    v.addElement(s);
                }
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            int len = v.size();
            if (len > 0) {
                aliases = new String[len];
                for (int i = 0; i < len; ++i) {
                    aliases[i] = (String)v.elementAt(i);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return aliases;
    }

    protected void checkAccess(SessionController sessionController, String userName) throws Exception {
        DirectoryUserObjectClientBean dirUser = sessionController.getLoginUser();
        long loginUserId = dirUser.getId();
        boolean hasAccess = false;
        if (!sessionController.isAdminEnabled()) {
            DirectoryUserObjectClientBean user = sessionController.getUserByName(userName);
            long userOwnerId = user.getOwner().getId();
            long userCreatorId = user.getCreator().getId();
            if (userOwnerId == loginUserId || userCreatorId == loginUserId) {
                hasAccess = true;
            }
        } else {
            hasAccess = true;
        }
        if (!hasAccess) {
            ExceptionUtils.handleException("No access for this user action", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    public static CredentialManager getCredentialManager(CredentialConfig credentialConfig) throws Exception {
        BaseCredentialManager cred = (BaseCredentialManager)Class.forName(credentialConfig.getCredentialClass()).newInstance();
        cred.setCredentialManagerName(credentialConfig.getName());
        return cred;
    }

    public static synchronized CredentialConfig getCredentialConfig(String credentialName) {
        CredentialConfig credentialConfig = null;
        if (credentialName != null) {
            long actFileTime;
            long lastFileTime;
            if (configCache == null) {
                configCache = new Hashtable();
            }
            if (configCache.containsKey(credentialName)) {
                credentialConfig = (CredentialConfig)configCache.get(credentialName);
            }
            if (credentialConfig != null && (lastFileTime = credentialConfig.getLastFileTime()) != (actFileTime = credentialConfig.getActualFileTime())) {
                credentialConfig = null;
                configCache.remove(credentialName);
            }
            try {
                if (credentialConfig == null) {
                    String serverHome = System.getProperty("jboss.server.home.dir");
                    String configDir = serverHome + "/deploy/roi.ear/config/credentialconfig/" + credentialName + "_credential.xml";
                    File file = new File(configDir);
                    if (file.exists()) {
                        XMLUtils xmlUtils = new XMLUtils();
                        InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                        Document doc = xmlUtils.parseXML(isr);
                        NodeList nl = doc.getChildNodes();
                        credentialConfig = new CredentialConfig();
                        credentialConfig.setConfigFile(configDir);
                        credentialConfig.setName(credentialName);
                        int len = nl.getLength();
                        for (int i = 0; i < len; ++i) {
                            Node node = nl.item(i);
                            if (!node.getNodeName().equalsIgnoreCase("CredentialConfig")) continue;
                            BaseCredentialManager.parseCredentialConfig(node, credentialConfig);
                        }
                        isr.close();
                        configCache.put(credentialName, credentialConfig);
                    } else {
                        System.err.println("Credential-Configuration: " + configDir + " is missing!");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return credentialConfig;
    }

    public static ArrayList getAllConfigs() throws Exception {
        String serverHome = System.getProperty("jboss.server.home.dir");
        String configDir = serverHome + "/deploy/roi.ear/config/credentialconfig";
        File dir = new File(configDir);
        File[] configFiles = dir.listFiles();
        ArrayList<CredentialConfig> al = new ArrayList<CredentialConfig>();
        if (configFiles != null) {
            int len = configFiles.length;
            for (int i = 0; i < len; ++i) {
                String confName = configFiles[i].getName();
                String name = confName.substring(0, confName.lastIndexOf(95));
                CredentialConfig config = BaseCredentialManager.getCredentialConfig(name);
                al.add(config);
            }
        }
        return al;
    }

    private static void parseCredentialConfig(Node node, CredentialConfig credentialConfig) throws Exception {
        NodeList nl = node.getChildNodes();
        XMLUtils xmlUtils = new XMLUtils();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node subNode = nl.item(i);
            if (subNode.getNodeName().equalsIgnoreCase("CredentialClass")) {
                credentialConfig.setCredentialClass(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (!subNode.getNodeName().equalsIgnoreCase("Parameters")) continue;
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            BaseCredentialManager.parseParameters(subNode, parameters);
            credentialConfig.setParameters(parameters);
        }
    }

    private static void parseParameters(Node node, Hashtable parameters) throws Exception {
        NodeList nl = node.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node subNode = nl.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase("Parameter")) continue;
            BaseCredentialManager.parseParameter(subNode, parameters);
        }
    }

    private static void parseParameter(Node node, Hashtable parameters) throws Exception {
        NodeList nl = node.getChildNodes();
        XMLUtils xmlUtils = new XMLUtils();
        int len = nl.getLength();
        String name = null;
        String value = null;
        for (int i = 0; i < len; ++i) {
            Node subNode = nl.item(i);
            if (subNode.getNodeName().equalsIgnoreCase("Name")) {
                name = xmlUtils.getValueFromNode(subNode);
                continue;
            }
            if (!subNode.getNodeName().equalsIgnoreCase("Value")) continue;
            value = xmlUtils.getValueFromNode(subNode);
        }
        if (name != null && value != null) {
            parameters.put(name, value);
        }
    }

    public static CredentialManager getCredentialManager(CredentialObject credential) throws Exception {
        String credentialManager = BaseCredentialManager.getCredentialManagerName(credential);
        CredentialConfig config = BaseCredentialManager.getCredentialConfig(credentialManager);
        BaseCredentialManager cm = null;
        if (config != null) {
            cm = (BaseCredentialManager)BaseCredentialManager.getCredentialManager(config);
            cm.setCredentialManagerName(credentialManager);
        }
        return cm;
    }

    public boolean updatePasswords(SessionController sessionController, DirectoryUserObjectClientBean user) throws Exception {
        boolean bRet = false;
        CredentialInfoBean infoBean = this.getCredentialInfo(sessionController, user.getDistinguishedName());
        if (infoBean != null) {
            if (infoBean.getNtPassWord() != null && infoBean.getNtPassWord().trim().length() != 0) {
                String password = this.getDecodedNTPassword(sessionController, infoBean.getNtPassWord(), user);
                this.updatePasswords(sessionController, user.getDistinguishedName(), password, null);
                bRet = true;
            } else {
                this.updatePasswords(sessionController, user.getDistinguishedName(), "pwd_" + System.currentTimeMillis(), null);
                bRet = false;
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLMAndNTHashes(SessionController sessionController, String userName, String lmHash, String ntHash, CredentialCallerBean credentialCaller) throws Exception {
        String ngosPassword = "disabled";
        Connection conn = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            StringUtils su = new StringUtils();
            if (ntHash != null) {
                byte[] pwBytes = StringUtils.hexToByte((String)ntHash);
                byte[] p21 = new byte[21];
                System.arraycopy(pwBytes, 0, p21, 0, pwBytes.length);
                ntHash = su.toHexString(p21);
            }
            this.changePasswordInternal(sessionController, userName, ntHash, lmHash, ngosPassword, conn, credentialCaller);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePasswords(SessionController sessionController, String dnName, String password, CredentialCallerBean credentialCaller) throws Exception {
        StringUtils stringUtils = new StringUtils();
        NTLMEncryption ntlm = new NTLMEncryption();
        String ntlmHash = stringUtils.toHexString(ntlm.getNTLMHash(password));
        DesEncryption des = new DesEncryption();
        String lmHash = des.getBaseDESPassword(password);
        String ngosPassword = this.getEncodedNTPassword(sessionController, password, dnName);
        Connection conn = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            this.changePasswordInternal(sessionController, dnName, ntlmHash, lmHash, ngosPassword, conn, credentialCaller);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    protected String getEncodedPassword(CredentialObject credential, String password) throws Exception {
        String ret = null;
        if (credential.getUseDesEncryption()) {
            StringUtils stringUtils = new StringUtils();
            NTLMEncryption ntlm = new NTLMEncryption();
            ret = stringUtils.toHexString(ntlm.getNTLMHash(password));
        } else {
            ret = password;
            if (!credential.isOwnDesEncryption()) {
                ret = password.toUpperCase();
            }
        }
        return ret;
    }

    protected String getEncodedOldPassword(CredentialObject credential, String password) throws Exception {
        String ret = null;
        if (credential.getUseDesEncryption()) {
            DesEncryption des = new DesEncryption();
            ret = des.getDesEncodedPasswordAsHexString(ChallengeGenerator.getChallenge((int)8), password);
        }
        return ret;
    }

    @Override
    public abstract CredentialInfoBean getCredentialInfo(SessionController var1, String var2) throws Exception;

    @Override
    public abstract void setCredentialInfo(SessionController var1, CredentialInfoBean var2) throws Exception;

    protected static String getPathOfUser(SessionController sessionController, String distinguisheName) throws Exception {
        try {
            DirectoryUserObjectClientBean user = sessionController.getUserByName(distinguisheName);
            String startPath = "/agorum/roi/Administration/User";
            GlobalObjectClientBean startFolder = sessionController.findGlobalObjectByPath(startPath);
            String folderPath = user.getAnyFolderPath(startFolder.getId());
            folderPath = folderPath.substring(1);
            folderPath = folderPath.lastIndexOf("/") != -1 ? folderPath.substring(0, folderPath.lastIndexOf("/")) : "";
            return folderPath;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public abstract void updatePaths(SessionController var1, String var2) throws Exception;

    @Override
    public abstract void updateUser(DirectoryUserObjectClientBean var1) throws Exception;
}

