/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AttributeValueMap
extends AttributeValue
implements Map<String, AttributeValue> {
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> map = new HashMap<String, AttributeValue>();
    private Map<String, String> lowerCase;

    public AttributeValueMap() {
        this.attributeValue = this.map;
        this.lowerCase = new HashMap<String, String>();
    }

    public AttributeValueMap(Map<? extends String, ? extends AttributeValue> pairs) {
        this();
        this.putAll(pairs);
    }

    @Override
    public AttributeValue put(String attributeName, AttributeValue attributeValue) {
        this.lowerCase.put(attributeName.toLowerCase(), attributeName);
        return this.map.put(attributeName, attributeValue);
    }

    @Override
    public String getDataType() {
        return "MAP";
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        for (Map.Entry<String, AttributeValue> entry : this.map.entrySet()) {
            sb.append(entry.getValue().getXMLTag(sessionController, entry.getKey(), globalObjectOnly));
            sb.append("\n");
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.lowerCase.containsKey(((String)key).toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public AttributeValue get(Object key) {
        return this.map.get(this.lowerCase.get(((String)key).toLowerCase()));
    }

    @Override
    public AttributeValue remove(Object key) {
        String mainKey = this.lowerCase.get(((String)key).toLowerCase());
        this.lowerCase.remove(mainKey.toLowerCase());
        return this.map.remove(mainKey);
    }

    @Override
    public void putAll(Map<? extends String, ? extends AttributeValue> m) {
        this.map.putAll(m);
        for (Map.Entry<? extends String, ? extends AttributeValue> entry : m.entrySet()) {
            String mainKey = entry.getKey();
            this.lowerCase.put(mainKey.toLowerCase(), mainKey);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.lowerCase.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<AttributeValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, AttributeValue>> entrySet() {
        return this.map.entrySet();
    }

    public Map<String, AttributeValue> getMap() {
        return this.map;
    }

    @Override
    public Map<String, Object> unwrap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map.size());
        for (Map.Entry<String, AttributeValue> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().unwrap());
        }
        return result;
    }
}

