/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;

public class AttributeValueFloatArray
extends AttributeValueArray {
    public AttributeValueFloatArray(Integer counter) {
        this.attributeValue = counter;
    }

    public AttributeValueFloatArray(AttributeValue[] values) {
        int len = values.length;
        Float[] array = new Float[len];
        this.attributeValue = len;
        this.attributeObjectArray = array;
        for (int i = 0; i < len; ++i) {
            array[i] = values[i].getObject();
        }
    }

    public AttributeValueFloatArray(Float[] value) {
        this.attributeObjectArray = value;
        this.attributeValue = this.getArrayLength();
    }

    public AttributeValueFloatArray(float[] value) {
        int len = value.length;
        this.attributeObjectArray = new Float(len);
        System.arraycopy(value, 0, this.attributeObjectArray, 0, len);
        this.attributeValue = len;
    }

    private Float[] getValue() {
        return (Float[])this.attributeObjectArray;
    }

    @Override
    public String getDataType() {
        return "FLOAT_ARRAY";
    }

    @Override
    public final String getValueType() {
        return "FLOAT";
    }

    @Override
    public int getArrayLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        Float[] bArr = this.getFloatArrayObject(sessionController);
        if (bArr != null) {
            int len = bArr.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.getXMLArrayStartTag(attributeName));
                sb.append(">");
                sb.append("" + bArr[i].floatValue());
                sb.append(this.getXMLArrayEndTag());
            }
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }
}

