/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AttributeValueDateArray
extends AttributeValueArray {
    public AttributeValueDateArray(Integer counter) {
        this.attributeValue = counter;
    }

    public AttributeValueDateArray(AttributeValue[] values) {
        int len = values.length;
        Date[] array = new Date[len];
        this.attributeValue = len;
        this.attributeObjectArray = array;
        for (int i = 0; i < len; ++i) {
            array[i] = values[i].getObject();
        }
    }

    public AttributeValueDateArray(Date[] value) {
        this.attributeObjectArray = value;
        this.attributeValue = new Integer(this.getArrayLength());
    }

    private Date[] getValue() {
        return (Date[])this.attributeObjectArray;
    }

    @Override
    public String getDataType() {
        return "DATE_ARRAY";
    }

    @Override
    public int getDataTypeInt() {
        return 13;
    }

    @Override
    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    @Override
    public final String getTableName() throws Exception {
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        return dbi.getAvDateArrayTableName();
    }

    @Override
    public final String getValueType() {
        return "DATE";
    }

    @Override
    public int getArrayLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        Date[] bArr = this.getDateArrayObject(sessionController);
        if (bArr != null) {
            int len = bArr.length;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            for (int i = 0; i < len; ++i) {
                sb.append(this.getXMLArrayStartTag(attributeName));
                sb.append(this.setXMLDateFormat());
                sb.append(this.setDateValue("yyyyMMdd", bArr[i]));
                sb.append(this.setTimeValue("HHmmss", bArr[i]));
                sb.append(">" + sdf.format(bArr[i]));
                sb.append(this.getXMLArrayEndTag());
            }
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }
}

