/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValueBasis;
import agorum.roi.ejb.common.SessionController;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AttributeValueDate
extends AttributeValueBasis {
    static Map<String, SimpleDateFormat> dateFormatCache = new HashMap<String, SimpleDateFormat>();

    public AttributeValueDate(Date value) {
        this.attributeValue = value == null ? new Date(0L) : value;
    }

    @Override
    public String getDataType() {
        return "DATE";
    }

    @Override
    public int getDataTypeInt() {
        return 1;
    }

    @Override
    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(this.setXMLDateFormat());
        sb.append(this.setDateValue("yyyyMMdd", this.getDate()));
        sb.append(this.setTimeValue("HHmmss", this.getDate()));
        sb.append(">");
        sb.append(AttributeValueDate.convertDateToString(this.getDate(), "yyyyMMddHHmmssSSS"));
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }

    private static SimpleDateFormat getDateFormatFromCache(String key) {
        SimpleDateFormat sdf = dateFormatCache.get(key);
        if (sdf == null) {
            sdf = new SimpleDateFormat(key);
            dateFormatCache.put(key, sdf);
        }
        return sdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date convertStringToDate(String dateString, String format) throws ParseException {
        Date result;
        SimpleDateFormat sdf;
        SimpleDateFormat simpleDateFormat = sdf = AttributeValueDate.getDateFormatFromCache(format);
        synchronized (simpleDateFormat) {
            result = sdf.parse(dateString);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertDateToString(Date date, String format) {
        String result;
        SimpleDateFormat sdf;
        SimpleDateFormat simpleDateFormat = sdf = AttributeValueDate.getDateFormatFromCache(format);
        synchronized (simpleDateFormat) {
            result = sdf.format(date);
        }
        return result;
    }
}

