/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiFileSystemInfoBean;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import java.util.Hashtable;

public class TestRoiFileSystem {
    private Hashtable seqHash = new Hashtable();
    private SessionController sessionController = null;

    public TestRoiFileSystem(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void test() throws Exception {
        RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
        FolderObjectClientBean myRoot = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/roi/Files/d4wdemo/Entwicklung");
        rfs.createFullpath("myRelFolder", myRoot, null);
    }

    public void testFileSystemInfo() throws Exception {
        RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
        FolderObjectClientBean myRoot = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/roi/Files");
        RoiFileSystemInfoBean rfsib = rfs.getFileSystemInfo(myRoot, 0);
        System.err.println("----------------- Info --------------------");
        System.err.println("fileSize              : " + rfsib.getFileSize());
        System.err.println("fileCount             : " + rfsib.getFileCount());
        System.err.println("folderCount           : " + rfsib.getFolderCount());
        System.err.println("fullpath              : " + rfsib.getFullpath());
        System.err.println("maxDepth              : " + rfsib.getMaxDepth());
        System.err.println("maxDepthPath          : " + rfsib.getMaxDepthPath());
        System.err.println("otherObjectCount      : " + rfsib.getOtherObjectCount());
        System.err.println("infoTime              : " + rfsib.getInfoTime());
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestRoiFileSystem");
            SessionController sessionController = SessionController.connect(credential);
            TestRoiFileSystem testRoiFileSystem = new TestRoiFileSystem(sessionController);
            testRoiFileSystem.testFileSystemInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

