/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FolderObjectSessionFacade;

public class TestGetAllAclIDs {
    private SessionController sessionController = null;

    public TestGetAllAclIDs(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void test() throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.findGlobalObjectByPath("/agorum/roi/Files/d4wdemo/Entwicklung");
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            FolderObjectSessionFacade facade = new FolderObjectSessionFacade(this.sessionController);
            facade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, "MeinScopeTestObject");
            facade.setWithTransaction(true);
            facade.setDestinationFolder((FolderObjectClientBean)gocb);
            FolderObjectClientBean myFolder = (FolderObjectClientBean)facade.create();
            Long fId = myFolder.getId();
            DirectoryUserObjectClientBean userVB = this.sessionController.getUserByName("d4wdemo_vb");
            DirectoryUserObjectClientBean userEN = this.sessionController.getUserByName("d4wdemo_en");
            AccessControlListObjectClientBean scopeAcl = this.sessionController.getAclByName("ACLd4wdemoSales");
            this.printAllAcls(this.sessionController, myFolder);
            this.printAccess(myFolder, userVB);
            System.err.println("XML:\n" + myFolder.getParseableForIndexXml());
            myFolder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(fId);
            GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)myFolder.getNewDefinition(this.sessionController);
            def.setSystemOption("setScopeAcls", new String[]{"ACLd4wdemoSales", "ACLd4wdemoDevelopment", "ACLd4wdemoInfo"});
            System.err.println("UPDATE\n\n");
            myFolder.update(def);
            this.printAllAcls(this.sessionController, myFolder);
            this.printAccess(myFolder, userVB);
            System.err.println("XML:\n" + myFolder.getParseableForIndexXml());
            myFolder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(fId);
            def = (GlobalObjectClientBeanDefinition)myFolder.getNewDefinition(this.sessionController);
            def.deleteAllScopeAcls();
            myFolder.update(def);
            this.printAllAcls(this.sessionController, myFolder);
            this.printAccess(myFolder, userVB);
            System.err.println("XML:\n" + myFolder.getParseableForIndexXml());
            myFolder.delete();
            rth.end();
            rth = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void printAccess(GlobalObjectClientBean clientBean, DirectoryUserObjectClientBean user) throws Exception {
        System.err.println(user.getName() + ", ALL : " + clientBean.checkEffectiveAccess(user, 0xFFFFFFL));
        System.err.println(user.getName() + ", WRITE : " + clientBean.checkEffectiveAccess(user, 2L));
        System.err.println(user.getName() + ", PROTECTED : " + clientBean.checkEffectiveAccess(user, 16384L));
        System.err.println(user.getName() + ", READ : " + clientBean.checkEffectiveAccess(user, 1L));
    }

    private void printAllAcls(SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        long[] allAcls = clientBean.getAllAclIDs();
        if (allAcls.length > 0) {
            int len = allAcls.length;
            for (int i = 0; i < len; ++i) {
                System.err.println("ACL[" + i + "] = " + allAcls[i] + ", " + sessionController.getGlobalObjectById(new Long(allAcls[i])).getName());
            }
        }
    }

    public static void main(String[] args) {
        System.err.println("Hallo");
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestGetAllAclIDs");
            SessionController sessionController = SessionController.connect(credential);
            TestGetAllAclIDs testGetAllAclIDs = new TestGetAllAclIDs(sessionController);
            testGetAllAclIDs.test();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende Programm");
    }
}

