/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Vector;

public class PrintDirectoryList {
    private SessionController sessionController = null;

    public PrintDirectoryList(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void print(String startFolder, String outputFile) throws Exception {
        Vector v = new Vector();
        FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(startFolder);
        this.printInternal(folder, startFolder, v);
        int len = v.size();
        Object[] sArray = new String[len];
        for (int i = 0; i < len; ++i) {
            sArray[i] = (String)v.elementAt(i);
        }
        Arrays.sort(sArray);
        File f = new File(outputFile);
        f.createNewFile();
        FileOutputStream fos = new FileOutputStream(f);
        for (int i = 0; i < len; ++i) {
            fos.write(((String)sArray[i] + "\n").getBytes());
        }
        fos.close();
    }

    private void printInternal(FolderObjectClientBean folder, String folderpath, Vector v) throws Exception {
        if (folder != null && folderpath != null) {
            this.appendToSB(v, folderpath, folder);
            GlobalObjectClientBean[] items = folder.getItems();
            if (items != null) {
                int len = items.length;
                for (int i = 0; i < len; ++i) {
                    String name = items[i].getName();
                    if (items[i] instanceof FolderObjectClientBean) {
                        this.printInternal((FolderObjectClientBean)items[i], folderpath + "/" + name, v);
                        continue;
                    }
                    this.appendToSB(v, folderpath + "/" + name, items[i]);
                }
            }
        }
    }

    private void appendToSB(Vector v, String s, GlobalObjectClientBean bean) throws Exception {
        v.addElement(s + " (" + bean.getClassName() + ")");
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("PrintDirectoryList");
            SessionController sessionController = SessionController.connect(credential);
            PrintDirectoryList printDirectoryList = new PrintDirectoryList(sessionController);
            printDirectoryList.print("/", "c:\\RoiDirectoryPrint.txt");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Programm ende");
    }
}

