/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.PropertyObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;

@ObjDoc(groups={ObjDoc.Group.ADMINISTRATION}, description="Client Bean for the PropertyObject Class")
public class PropertyObjectClientBean
extends GlobalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "PROPERTYOBJECT";
    public static final String PROPERTYVALUE_ATTRIBUTE = "PROPERTYVALUE";
    public static final String PROPERTYTEXTKEY_ATTRIBUTE = "PROPERTYTEXTKEY";
    public static final String PROPERTYSORTSEQUENCE_ATTRIBUTE = "PROPERTYSORTSEQUENCE";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new PropertyObjectClientBeanDefinition(sessionController);
    }

    public void setPropertyValue(String value) throws Exception {
        this.setAttribute(PROPERTYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setPropertyTextkey(String value) throws Exception {
        this.setAttribute(PROPERTYTEXTKEY_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setPropertySortsequence(int value) throws Exception {
        this.setAttribute(PROPERTYSORTSEQUENCE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get the property value")
    public String getPropertyValue() throws Exception {
        return this.getAttribute(PROPERTYVALUE_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="get the property text key")
    public String getPropertyTextkey() throws Exception {
        return this.getAttribute(PROPERTYTEXTKEY_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="get the property sort sequence")
    public int getPropertySortsequence() throws Exception {
        return this.getAttribute(PROPERTYSORTSEQUENCE_ATTRIBUTE).getInteger();
    }

    @Override
    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NOT_FOR_SYNC;
    }
}

