/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.common.MetaDbEntryUtils;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.Date;

@ObjDoc(groups={ObjDoc.Group.METADB}, description="Client Bean for the MetaDbPropertyEntryObject Class")
public class MetaDbPropertyEntryObjectClientBean
extends FileObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "METADBPROPERTYENTRYOBJECT";
    public static final String ENTRYDATATYPE_ATTRIBUTE = "ENTRYDATATYPE";
    public static final String STRINGVALUE_ATTRIBUTE = "STRINGVALUE";
    public static final String BOOLEANVALUE_ATTRIBUTE = "BOOLEANVALUE";
    public static final String INTVALUE_ATTRIBUTE = "INTVALUE";
    public static final String LONGVALUE_ATTRIBUTE = "LONGVALUE";
    public static final String DATEVALUE_ATTRIBUTE = "DATEVALUE";
    public static final String DOUBLEVALUE_ATTRIBUTE = "DOUBLEVALUE";
    public static final String STRINGARRAYVALUE_ATTRIBUTE = "STRINGARRAYVALUE";
    public static final String BOOLEANARRAYVALUE_ATTRIBUTE = "BOOLEANARRAYVALUE";
    public static final String INTARRAYVALUE_ATTRIBUTE = "INTARRAYVALUE";
    public static final String LONGARRAYVALUE_ATTRIBUTE = "LONGARRAYVALUE";
    public static final String DATEARRAYVALUE_ATTRIBUTE = "DATEARRAYVALUE";
    public static final String DOUBLEARRAYVALUE_ATTRIBUTE = "DOUBLEARRAYVALUE";
    public static final long ENTRYDATATYPE_STRING = 1L;
    public static final long ENTRYDATATYPE_BOOLEAN = 2L;
    public static final long ENTRYDATATYPE_INT = 4L;
    public static final long ENTRYDATATYPE_LONG = 8L;
    public static final long ENTRYDATATYPE_DATE = 16L;
    public static final long ENTRYDATATYPE_DOUBLE = 32L;
    public static final long ENTRYDATATYPE_STRING_ARRAY = 64L;
    public static final long ENTRYDATATYPE_BOOLEAN_ARRAY = 128L;
    public static final long ENTRYDATATYPE_INT_ARRAY = 256L;
    public static final long ENTRYDATATYPE_LONG_ARRAY = 512L;
    public static final long ENTRYDATATYPE_DATE_ARRAY = 1024L;
    public static final long ENTRYDATATYPE_DOUBLE_ARRAY = 2048L;
    public static final long ENTRYDATATYPE_CONTENT = 4096L;
    public static final long ENTRYDATATYPE_ENCRYPTED = 8192L;

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new MetaDbPropertyEntryObjectClientBeanDefinition(sessionController);
    }

    public void setEntryDataType(long value) throws Exception {
        this.setAttribute(ENTRYDATATYPE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setStringValue(String value) throws Exception {
        this.setAttribute(STRINGVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setBooleanValue(boolean value) throws Exception {
        this.setAttribute(BOOLEANVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setIntValue(int value) throws Exception {
        this.setAttribute(INTVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLongValue(long value) throws Exception {
        this.setAttribute(LONGVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDateValue(Date value) throws Exception {
        this.setAttribute(DATEVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDoubleValue(double value) throws Exception {
        this.setAttribute(DOUBLEVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setStringArrayValue(String[] value) throws Exception {
        this.setAttribute(STRINGARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setBooleanArrayValue(boolean[] value) throws Exception {
        this.setAttribute(BOOLEANARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setIntArrayValue(int[] value) throws Exception {
        this.setAttribute(INTARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLongArrayValue(long[] value) throws Exception {
        this.setAttribute(LONGARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDateArrayValue(Date[] value) throws Exception {
        this.setAttribute(DATEARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setDoubleArrayValue(double[] value) throws Exception {
        this.setAttribute(DOUBLEARRAYVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setEncryptedValue(String value) throws Exception {
        this.setAttribute(STRINGVALUE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the entry data type")
    public long getEntryDataType() throws Exception {
        return this.getAttribute(ENTRYDATATYPE_ATTRIBUTE).getLong();
    }

    @ObjDocAttribute(value="the string value")
    public String getStringValue() throws Exception {
        return this.getAttribute(STRINGVALUE_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the boolean value")
    public boolean getBooleanValue() throws Exception {
        return this.getAttribute(BOOLEANVALUE_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="the integer value")
    public int getIntValue() throws Exception {
        return this.getAttribute(INTVALUE_ATTRIBUTE).getInteger();
    }

    @ObjDocAttribute(value="the long value")
    public long getLongValue() throws Exception {
        return this.getAttribute(LONGVALUE_ATTRIBUTE).getLong();
    }

    @ObjDocAttribute(value="the date value")
    public Date getDateValue() throws Exception {
        return this.getAttribute(DATEVALUE_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the double value")
    public double getDoubleValue() throws Exception {
        return this.getAttribute(DOUBLEVALUE_ATTRIBUTE).getDouble();
    }

    public String[] getStringArrayValue() throws Exception {
        return this.getAttribute(STRINGARRAYVALUE_ATTRIBUTE).getStringArrayObject(this.sessionController);
    }

    public boolean[] getBooleanArrayValue() throws Exception {
        return this.getAttribute(BOOLEANARRAYVALUE_ATTRIBUTE).getBooleanArray(this.sessionController);
    }

    public int[] getIntArrayValue() throws Exception {
        return this.getAttribute(INTARRAYVALUE_ATTRIBUTE).getIntegerArray(this.sessionController);
    }

    public long[] getLongArrayValue() throws Exception {
        return this.getAttribute(LONGARRAYVALUE_ATTRIBUTE).getLongArray(this.sessionController);
    }

    public Date[] getDateArrayValue() throws Exception {
        return this.getAttribute(DATEARRAYVALUE_ATTRIBUTE).getDateArrayObject(this.sessionController);
    }

    public double[] getDoubleArrayValue() throws Exception {
        return this.getAttribute(DOUBLEARRAYVALUE_ATTRIBUTE).getDoubleArray(this.sessionController);
    }

    @ObjDocAttribute(value="")
    public String getEncryptedValue() throws Exception {
        return this.getAttribute(STRINGVALUE_ATTRIBUTE).getString();
    }

    public String[] replaceBasicKeywords(String[] sArray) {
        MetaDbEntryUtils metaDbEntryUtils = new MetaDbEntryUtils(this.sessionController);
        return metaDbEntryUtils.replaceBasicKeywords(sArray);
    }

    public String replaceBasicKeywords(String s) {
        MetaDbEntryUtils metaDbEntryUtils = new MetaDbEntryUtils(this.sessionController);
        return metaDbEntryUtils.replaceBasicKeywords(s);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        try {
            int i;
            int len;
            Object[] myArray;
            long myDataType = this.getEntryDataType();
            if ((myDataType & 1L) != 0L) {
                sb.append("String: '");
                sb.append(this.getStringValue() == null ? "" : this.getStringValue());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 2L) != 0L) {
                sb.append("Boolean: '");
                sb.append(this.getBooleanValue());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 4L) != 0L) {
                sb.append("Int: '");
                sb.append(this.getIntValue());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 8L) != 0L) {
                sb.append("Long: '");
                sb.append(this.getLongValue());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 0x10L) != 0L) {
                sb.append("Date: '");
                sb.append(this.getDateValue() == null ? "" : this.getDateValue().toString());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 0x20L) != 0L) {
                sb.append("Double: '");
                sb.append(this.getDoubleValue());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 0x40L) != 0L) {
                sb.append("String[]\n");
                myArray = this.getStringArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("String[" + i + "]: '" + (myArray[i] == null ? "" : myArray[i]) + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x80L) != 0L) {
                sb.append("Boolean[]\n");
                myArray = this.getBooleanArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("Boolean[" + i + "]: '" + (boolean)myArray[i] + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x100L) != 0L) {
                sb.append("Int[]\n");
                myArray = this.getIntArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("Int[" + i + "]: '" + (int)myArray[i] + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x200L) != 0L) {
                sb.append("Long[]\n");
                myArray = this.getLongArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("Long[" + i + "]: '" + (long)myArray[i] + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x400L) != 0L) {
                sb.append("Date[]\n");
                myArray = this.getDateArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("Date[" + i + "]: '" + (myArray[i] == null ? "" : "" + ((Date)((Object)myArray[i])).toString()) + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x800L) != 0L) {
                sb.append("Double[]\n");
                myArray = this.getDoubleArrayValue();
                if (myArray != null) {
                    len = myArray.length;
                    for (i = 0; i < len; ++i) {
                        sb.append("Double[" + i + "]: '" + (double)myArray[i] + "'\n");
                    }
                }
                sb.append("\n");
            }
            if ((myDataType & 0x1000L) != 0L) {
                sb.append("Content\n'");
                sb.append(this.getContentString());
                sb.append("'\n");
                sb.append("\n");
            }
            if ((myDataType & 0x2000L) != 0L) {
                sb.append("Encrypted: '**********'\n\n");
            }
        }
        catch (Exception e) {
            StringUtils su = new StringUtils();
            sb.append(su.exceptionToString(e));
        }
        return sb.toString();
    }

    public String getValueToString(long dataType) {
        MetaDbEntryUtils metaDbEntryUtils = new MetaDbEntryUtils(this.sessionController);
        return metaDbEntryUtils.getValueToString(dataType, this.getValueObject(dataType));
    }

    public Object getValueObject(long dataType) {
        Object o = null;
        try {
            if (dataType == 1L) {
                o = this.getStringValue() == null ? "" : this.getStringValue();
            } else if (dataType == 2L) {
                o = this.getBooleanValue();
            } else if (dataType == 4L) {
                o = this.getIntValue();
            } else if (dataType == 8L) {
                o = this.getLongValue();
            } else if (dataType == 16L) {
                o = this.getDateValue();
            } else if (dataType == 32L) {
                o = this.getDoubleValue();
            } else if (dataType == 64L) {
                o = this.getStringArrayValue();
            } else if (dataType == 128L) {
                o = this.getBooleanArrayValue();
            } else if (dataType == 256L) {
                o = this.getIntArrayValue();
            } else if (dataType == 512L) {
                o = this.getLongArrayValue();
            } else if (dataType == 1024L) {
                o = this.getDateArrayValue();
            } else if (dataType == 2048L) {
                o = this.getDoubleArrayValue();
            } else if (dataType == 4096L) {
                o = this.getContentString();
            } else if (dataType == 8192L) {
                o = this.getStringValue() == null ? "" : this.getStringValue();
            }
        }
        catch (Exception e) {
            StringUtils su = new StringUtils();
            o = su.exceptionToString(e);
        }
        return o;
    }

    @Override
    public boolean createAccessCounterObject() {
        return false;
    }

    @Override
    public boolean shouldMakeHistory() {
        return false;
    }

    @Override
    public boolean countDownloadQuota() {
        return false;
    }
}

