/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.callback.GlobalObjectCallBack;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailAttachmentsRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailBodyRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailDocumentObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailMsgRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ObjDoc(groups={ObjDoc.Group.MAIL}, description="Client Bean for the MailDocumentObject Class")
public class MailDocumentObjectClientBean
extends FileObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "MAILDOCUMENTOBJECT";
    public static final String MAIL_ATTACHMENT_OVERWRITE = "MAIN_MODULE_MANAGEMENT/roi/control/mail/AllowMailAttachmentOverwrite";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new MailDocumentObjectClientBeanDefinition(sessionController);
    }

    @Override
    @ObjDocAttribute(value="get ...")
    public ContentInterface getAccessCounterContentObject() throws Exception {
        return (ContentInterface)((Object)this.getMainObject());
    }

    @Override
    public boolean isBinary() throws Exception {
        return this.getMainObjectId().equals(this.getId()) || this.getLeftwardRelationCount(MailAttachmentsRelationObjectClientBean.CLASS_NAME) > 0 || this.getLeftwardRelationCount(MailMsgRelationObjectClientBean.CLASS_NAME) > 0;
    }

    @Override
    public boolean supportsPreview() throws Exception {
        return this.getLeftwardRelationCount(MailBodyRelationObjectClientBean.CLASS_NAME) <= 0;
    }

    @Override
    public boolean isIndexAble() throws Exception {
        return !this.isMailBody() && !this.isMailMsg() && super.isIndexAble();
    }

    @Override
    public String useLastAddedRelationClass() {
        try {
            if (this.isMainObject()) {
                return super.useLastAddedRelationClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MailAttachmentsRelationObjectClientBean.CLASS_NAME;
    }

    private boolean mayOverwriteAttachment() {
        return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, MAIL_ATTACHMENT_OVERWRITE, "true"));
    }

    public boolean hasMail() throws Exception {
        return this.getLeftwardRelations(MailAttachmentsRelationObjectClientBean.CLASS_NAME) != null;
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        if (!this.sessionController.isInSychronization()) {
            if ((accessLevel & 0x100000L) != 0L) {
                return false;
            }
            SuperObjectClientBean mail = null;
            try {
                GlobalObjectClientBean mainObj = this.getMainObj();
                mail = mainObj instanceof MailObjectClientBean ? (MailObjectClientBean)mainObj : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(mail == null || GlobalObjectCallBack.deleting().contains(mail.getId()) || ((MailObjectClientBean)mail).getDraft() || "drafts".equals(((MailObjectClientBean)mail).getMailStatus()))) {
                if ((accessLevel & 0x10L) != 0L) {
                    return false;
                }
                if (!((accessLevel & 8L) == 0L || Transaction.has(MailObjectClientBean.COPY_CONTEXT) || this.mayOverwriteAttachment() && this.isMailAttachment() || !this.isMailAttachment() && !this.isMailBody() && !this.isMailMsg() || super.getContentSize(false) <= 0L)) {
                    return false;
                }
            }
        }
        return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
    }

    @Override
    public boolean shouldMakeHistory() {
        return true;
    }

    @Override
    public List<GlobalObjectClientBean> getIndexMainObjects() throws Exception {
        HashSet<String> done = new HashSet<String>();
        ArrayList<GlobalObjectClientBean> objects = new ArrayList<GlobalObjectClientBean>();
        return this.getIndexMainObjects(this, objects, done);
    }

    private List<GlobalObjectClientBean> getIndexMainObjects(GlobalObjectClientBean obj, List<GlobalObjectClientBean> objects, Set<String> done) throws Exception {
        GlobalObjectClientBean[] mails = this.getLeftwardRelationObjects(MailAttachmentsRelationObjectClientBean.CLASS_NAME);
        if (mails == null || mails.length == 0) {
            objects.add(this.getIndexMainObject());
        } else {
            for (GlobalObjectClientBean mail : mails) {
                objects.add(mail);
                if (done.contains(obj.getID())) continue;
                done.add(mail.getID());
                this.getIndexMainObjects(mail, objects, done);
            }
        }
        return objects;
    }
}

