/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.ExtendedUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.InfoUserProfileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;

@ObjDoc(groups={ObjDoc.Group.USERMANAGEMENT}, description="Client Bean for the InfoUserProfileObject Class")
public class InfoUserProfileObjectClientBean
extends ExtendedUserProfileObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "INFOUSERPROFILEOBJECT";
    public static final String GIVENNAME_ATTRIBUTE = "GIVENNAME";
    public static final String FAMILYNAME_ATTRIBUTE = "FAMILYNAME";
    public static final String LANGUAGE_ATTRIBUTE = "LANGUAGE";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new InfoUserProfileObjectClientBeanDefinition(sessionController);
    }

    public void setGivenName(String value) throws Exception {
        this.setAttribute(GIVENNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setFamilyName(String value) throws Exception {
        this.setAttribute(FAMILYNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLanguage(String value) throws Exception {
        this.setAttribute(LANGUAGE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the given name")
    public String getGivenName() throws Exception {
        return this.getAttribute(GIVENNAME_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the family name")
    public String getFamilyName() throws Exception {
        return this.getAttribute(FAMILYNAME_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the language")
    public String getLanguage() throws Exception {
        String language = this.getAttribute(LANGUAGE_ATTRIBUTE).getString();
        if (language == null || language.isEmpty()) {
            RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
            language = rpmd.getDefaultLanguage();
        }
        return language;
    }

    @ObjDocAttribute(value="the full name")
    public String getFullName() throws Exception {
        String givenName = this.getGivenName();
        String familyName = this.getFamilyName();
        String fullName = (givenName == null ? "" : givenName) + " " + (familyName == null ? "" : familyName);
        return fullName;
    }
}

