/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class GlobalObjectClientBeanDefinition
extends SuperObjectClientBeanDefinition
implements Serializable {
    private static final String[] SKIP_ACLS_ATTRIBUTES = new String[]{GlobalObjectClientBean.ACL_ATTRIBUTE};
    private static final String[] SKIP_ACLS_OPTIONS = new String[]{"deleteAllScopeAcls", "deleteScopeAcls", "setScopeAcls"};
    private Hashtable extendedAttributes = null;
    private Hashtable updatedExtendedAttributes = null;
    private Hashtable removedExtendedAttributes = null;

    public GlobalObjectClientBeanDefinition(SessionController sessionController) throws Exception {
        super(sessionController, GlobalObjectClientBean.CLASS_NAME);
    }

    public boolean checkForNotAllowedChars() {
        return true;
    }

    public GlobalObjectClientBeanDefinition(SessionController sessionController, String className) throws Exception {
        super(sessionController, className);
    }

    public void setName(String name) throws Exception {
        this.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(name));
    }

    public void setUUID(String uuid) throws Exception {
        this.setAttribute(GlobalObjectClientBean.UUID_ATTRIBUTE, AttributeValue.newAttributeValueObject(uuid));
    }

    public void setObjectTextKey(String name) throws Exception {
        this.setAttribute(GlobalObjectClientBean.OBJECTTEXTKEY_ATTRIBUTE, AttributeValue.newAttributeValueObject(name));
    }

    public void setDescription(String description) throws Exception {
        this.setAttribute(GlobalObjectClientBean.DESCRIPTION_ATTRIBUTE, AttributeValue.newAttributeValueObject(description));
    }

    public void setLastModifyDate(Date date) throws Exception {
        this.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    public void setUpdateDate(Date date) throws Exception {
        this.setAttribute(GlobalObjectClientBean.UPDATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    public void setTimePhasedAction(String value) throws Exception {
        this.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTION_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setTimePhasedActionDate(Date date) throws Exception {
        this.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    public void setCreateDate(Date date) throws Exception {
        this.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(date));
    }

    public void setOwner(DirectoryUserObjectClientBean user) throws Exception {
        this.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, AttributeValue.newAttributeValueObject(user));
    }

    public void setCreator(DirectoryUserObjectClientBean user) throws Exception {
        this.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(user));
    }

    public void setLastModifier(DirectoryUserObjectClientBean user) throws Exception {
        this.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(user));
    }

    public void setMainObject(GlobalObjectClientBean value) throws Exception {
        this.setAttribute(GlobalObjectClientBean.MAINOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setAddToFolderOption(FolderObjectClientBean folder) throws Exception {
        try {
            this.setSystemOption("addToFolder", folder);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setAcl(AccessControlListObjectClientBean acl) throws Exception {
        this.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, AttributeValue.newAttributeValueObject(acl));
    }

    public AccessControlListObjectClientBean getAcl() throws Exception {
        AttributeValue av = this.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE);
        if (av != null) {
            return (AccessControlListObjectClientBean)av.getGlobalObjectClientBean(this.sessionController);
        }
        return null;
    }

    public String getName() throws Exception {
        AttributeValue av = this.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE);
        if (av != null) {
            return av.getString();
        }
        return null;
    }

    public AttributeValue getIsFolderAV() throws Exception {
        return this.getAttribute(GlobalObjectClientBean.ISFOLDER_ATTRIBUTE);
    }

    public void setIsFolder(boolean value) throws Exception {
        this.setAttribute(GlobalObjectClientBean.ISFOLDER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setExpirationDate(Date value) throws Exception {
        this.setAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setSystemFlags(long value) throws Exception {
        this.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setExtendedAttribute(String attrName, AttributeValue attributeValue) throws Exception {
        this.setExtendedAttribute(attrName, attributeValue, false);
    }

    public void setExtendedAttribute(String attrName, AttributeValue attributeValue, boolean update) throws Exception {
        if (update) {
            if (this.updatedExtendedAttributes == null) {
                this.updatedExtendedAttributes = new Hashtable();
            }
            this.updatedExtendedAttributes.remove(attrName);
            if (attributeValue != null) {
                this.updatedExtendedAttributes.put(attrName, attributeValue);
            }
        } else {
            if (this.extendedAttributes == null) {
                this.extendedAttributes = new Hashtable();
            }
            this.extendedAttributes.remove(attrName);
            if (attributeValue != null) {
                this.extendedAttributes.put(attrName, attributeValue);
            }
            StringBuffer sBuffer = new StringBuffer();
            Enumeration keyEnum = this.extendedAttributes.keys();
            while (keyEnum.hasMoreElements()) {
                String attributeName = (String)keyEnum.nextElement();
                AttributeValue attributeVal = (AttributeValue)this.extendedAttributes.get(attributeName);
                String xmlLine = attributeVal.getXMLTag(this.sessionController, attributeName, false);
                sBuffer.append(xmlLine + "\n");
            }
            this.setExtendedAttributesXML(sBuffer.toString());
        }
    }

    public void removeExtendedAttribute(String attrName) throws Exception {
        if (this.removedExtendedAttributes == null) {
            this.removedExtendedAttributes = new Hashtable();
        }
        this.removedExtendedAttributes.remove(attrName);
        this.removedExtendedAttributes.put(attrName, "");
    }

    public void setExtendedAttributesXML(String extendedAttributesXML, boolean inherited) throws Exception {
        try {
            if (inherited) {
                this.setSystemOption("extendedAttributesXMLInherited", extendedAttributesXML);
            } else {
                this.setSystemOption("extendedAttributesXML", extendedAttributesXML);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setExtendedAttributesXML(String extendedAttributesXML) throws Exception {
        this.setExtendedAttributesXML(extendedAttributesXML, false);
    }

    public void updateExtendedAttributes(Hashtable updatedExtendedAttributes, Hashtable removedExtendedAttributes) throws Exception {
        this.updateExtendedAttributes(updatedExtendedAttributes, removedExtendedAttributes, false);
    }

    public void updateExtendedAttributes(Hashtable updatedExtendedAttributes, Hashtable removedExtendedAttributes, boolean inherited) throws Exception {
        try {
            if (inherited) {
                if (updatedExtendedAttributes != null) {
                    this.setSystemOption("updatedExtendedAttributesInherited", updatedExtendedAttributes);
                }
                if (removedExtendedAttributes != null) {
                    this.setSystemOption("removedExtendedAttributesInherited", removedExtendedAttributes);
                }
            } else {
                if (updatedExtendedAttributes != null) {
                    this.setSystemOption("updatedExtendedAttributes", updatedExtendedAttributes);
                }
                if (removedExtendedAttributes != null) {
                    this.setSystemOption("removedExtendedAttributes", removedExtendedAttributes);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void saveUpdatedExtendedAttributes() throws Exception {
        this.updateExtendedAttributes(this.updatedExtendedAttributes, this.removedExtendedAttributes);
    }

    public void setScopeAcls(AccessControlListObjectClientBean[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("setScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setScopeAcls(Long[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("setScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setScopeAcls(long[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("setScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setScopeAcls(String[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("setScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void deleteScopeAcls(AccessControlListObjectClientBean[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("deleteScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void deleteScopeAcls(Long[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("deleteScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void deleteScopeAcls(String[] scopeAcls) throws Exception {
        try {
            this.setSystemOption("deleteScopeAcls", scopeAcls);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void deleteAllScopeAcls() throws Exception {
        try {
            this.setSystemOption("deleteAllScopeAcls", "");
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    @Override
    public AutoCloseable prepareUpdate(Long id) throws Exception {
        AutoCloseable suppressed = super.prepareUpdate(id);
        if (id.equals(this.getSystemOption("skipAcls"))) {
            suppressed = new SuperObjectClientBeanDefinition.Suppressed(this, suppressed, SKIP_ACLS_ATTRIBUTES, SKIP_ACLS_OPTIONS);
        }
        return suppressed;
    }
}

