/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.common.Relations;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CheckUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.cache.MetaDbCache;
import agorum.roi.util.annotations.ObjDoc;
import java.io.Serializable;
import java.util.Date;

@ObjDoc(groups={ObjDoc.Group.FOLDER, ObjDoc.Group.RELATION}, description="Client Bean for the DataBaseObject Class")
public class FolderRelationObjectClientBean
extends RelationObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "FOLDERRELATIONOBJECT";
    public static String SUBCHANGEDATE_ATTRIBUTE = "SUBCHANGEDATE";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new FolderRelationObjectClientBeanDefinition(sessionController);
    }

    public void setSubChangeDate(Date value) throws Exception {
        this.setAttribute(SUBCHANGEDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public Date getSubChangeDate() throws Exception {
        return this.getAttribute(SUBCHANGEDATE_ATTRIBUTE).getDate();
    }

    @Override
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        MetaDbCache.getInstance().removeItem(this.getLeftObject(), this.getRightObject());
        super.delete(def);
    }

    @Override
    public void deleteToRecycle(GlobalObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
            System.err.println("FR untersuche " + gocb.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null) {
            CheckUtils cu;
            if (gocb.getAttribute(GlobalObjectClientBean.DELETOR_ATTRIBUTE).getLong() == 0L && !(cu = new CheckUtils()).checkFolderRelation(this.sessionController, def, gocb, 1) && !cu.checkMainObject(this.sessionController, def, gocb)) {
                gocb.deleteToRecycling(def);
            }
            MetaDbCache.getInstance().removeItem(this.getLeftObject(), gocb);
        }
    }

    @Override
    public void undelete(GlobalObjectClientBeanDefinition def) throws Exception {
        CheckUtils cu;
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
            System.err.println("undelete RO untersuche " + gocb.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null && (cu = new CheckUtils()).isThisTheMainObject(this.sessionController, def, gocb)) {
            gocb.undelete(def);
        }
    }

    @Override
    public void leaveAcl(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
        CheckUtils cu;
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null && (cu = new CheckUtils()).isThisTheMainObject(this.sessionController, (GlobalObjectClientBeanDefinition)def, gocb)) {
            gocb.leaveAcl(acl, def);
        }
    }

    @Override
    public void deleteRightObject(SuperObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb == null) {
            return;
        }
        if (Relations.deleteRightObject(def, null, gocb)) {
            gocb.delete(def);
        } else {
            this.deleteMe(def);
        }
    }

    private void deleteMe(SuperObjectClientBeanDefinition def) throws Exception {
        if (def.getSystemOption("SetExpirationDateInsteadOfDelete") != null) {
            FolderObjectClientBean left = (FolderObjectClientBean)this.getLeftObject();
            left.addDeletedItem(this.getRightObject());
        }
        this.delete(def);
    }
}

