/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.EntityObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import java.io.Serializable;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.ADMINISTRATION}, description="Client Bean for the EntityObject Class")
public class EntityObjectClientBean
extends FolderDocumentObjectClientBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String CLASS_NAME = "ENTITYOBJECT";
    public static final String ENTITY_CLASS = "_agorum_entity_class";

    @Override
    public EntityObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new EntityObjectClientBeanDefinition(sessionController);
    }

    @Override
    public void fillIndexAttributes(Map<String, AttributeInfo> attributes, GlobalObjectClientBean mainObject) throws Exception {
        super.fillIndexAttributes(attributes, mainObject);
        FolderObjectClientBean parent = this.getFirstParent();
        if (parent != null) {
            AttributeInfo.put(attributes, "parent", parent.getUUID());
        }
        AttributeInfo.put(attributes, "class", this.getEntityClass());
    }

    @Override
    public String getXml(boolean withEndTag) throws Exception {
        StringBuilder sb = new StringBuilder(super.getXml(false));
        FolderObjectClientBean parent = this.getFirstParent();
        if (parent != null) {
            sb.append("<PARENT>");
            sb.append(parent.getUUID());
            sb.append("</PARENT>");
        }
        sb.append("<CLASS>");
        sb.append(this.getEntityClass());
        sb.append("</CLASS>");
        if (withEndTag) {
            sb.append(this.getXMLEndTag(this.sessionController));
        }
        return sb.toString();
    }

    public String getEntityClass() throws Exception {
        return (String)this.getExtendedAttribute(ENTITY_CLASS, false);
    }
}

