/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InfoUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.PrimaryUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.UserProfileObjectClientBean;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.QuotaHelper;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.interfaces.remote.DirectoryUserObjectRemote;
import agorum.roi.search.SearchClass;
import agorum.roi.sessionfacade.beans.DirectoryUserObjectSessionFacade;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

@ObjDoc(groups={ObjDoc.Group.USERMANAGEMENT}, description="Client Bean for the DirectoryUserObject Class")
public class DirectoryUserObjectClientBean
extends DirectoryObjectClientBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METADB_SYSTEM_OPTION = "UserMetaDbGroupPath";
    public static String CLASS_NAME = "DIRECTORYUSEROBJECT";
    public static String DISTINGUISHEDNAME_ATTRIBUTE = "DISTINGUISHEDNAME";
    public static String ADMINENABLED_ATTRIBUTE = "ADMINENABLED";
    public static String CREDENTIALMANAGER_ATTRIBUTE = "CREDENTIALMANAGER";
    public static String UNIQUENAME_ATTRIBUTE = "UNIQUENAME";
    public static String SYSTEMADMINENABLED_ATTRIBUTE = "SYSTEMADMINENABLED";
    public static String USERSEQUENCE_ATTRIBUTE = "USERSEQUENCE";
    public static String DEFAULTROLE_ATTRIBUTE = "DEFAULTROLE";
    public static String ASSOCIATEDROLES_ATTRIBUTE = "ASSOCIATEDROLES";
    public static final long ROI_USER_ID = 11000L;

    public void setDistinguishedName(String value) throws Exception {
        this.setAttribute(DISTINGUISHEDNAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get distinguished name")
    public String getDistinguishedName() throws Exception {
        return this.getAttribute(DISTINGUISHEDNAME_ATTRIBUTE).getString();
    }

    public void setUserSequence(int value) throws Exception {
        this.setAttribute(USERSEQUENCE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get user sequence")
    public int getUserSequence() throws Exception {
        return this.getAttribute(USERSEQUENCE_ATTRIBUTE).getInteger();
    }

    public void setAdminenabled(boolean value) throws Exception {
        this.setAttribute(ADMINENABLED_ATTRIBUTE, AttributeValue.newAttributeValueObject((Boolean)value));
    }

    @ObjDocAttribute(value="get admin enabled")
    public boolean getAdminenabled() throws Exception {
        AttributeValue av = this.getAttribute(ADMINENABLED_ATTRIBUTE);
        return av.getBoolean();
    }

    public void setDefaultRole(DirectoryObjectClientBean value) throws Exception {
        this.setAttribute(DEFAULTROLE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get default role")
    public DirectoryObjectClientBean getDefaultRole() throws Exception {
        try {
            return this.getAttribute(DEFAULTROLE_ATTRIBUTE).getDirectoryObjectClientBean(this.sessionController);
        }
        catch (Exception e) {
            System.err.println("could not get defaultRole User, no access");
            return this;
        }
    }

    public void setAssociatedRoles(DirectoryObjectClientBean value) throws Exception {
        this.setAttribute(ASSOCIATEDROLES_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get associated roles")
    public DirectoryObjectClientBean getAssociatedRoles() throws Exception {
        try {
            return this.getAttribute(ASSOCIATEDROLES_ATTRIBUTE).getDirectoryObjectClientBean(this.sessionController);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCredentialManager(String value) throws Exception {
        this.setAttribute(CREDENTIALMANAGER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get credentail manager")
    public String getCredentialManager() throws Exception {
        return this.getAttribute(CREDENTIALMANAGER_ATTRIBUTE).getString();
    }

    public void setUniqueName(String value) throws Exception {
        this.setAttribute(UNIQUENAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="get unique name")
    public String getUniqueName() throws Exception {
        return this.getAttribute(UNIQUENAME_ATTRIBUTE).getString();
    }

    public void setSystemAdminEnabled(boolean value) throws Exception {
        this.setAttribute(SYSTEMADMINENABLED_ATTRIBUTE, AttributeValue.newAttributeValueObject((Boolean)value));
    }

    @ObjDocAttribute(value="get sysytem admin enabled")
    public boolean getSystemAdminEnabled() throws Exception {
        return this.getAttribute(SYSTEMADMINENABLED_ATTRIBUTE).getBoolean();
    }

    public GlobalObjectClientBean[] getUserProfileObjects() throws RemoteException, Exception {
        GlobalObjectClientBean[] goRet = null;
        SearchClass sc = new SearchClass(this.sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME, UserProfileObjectClientBean.CLASS_NAME});
        sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, UserProfileObjectClientBean.CLASS_NAME, null);
        sc.setAttributeEQUAL(UserProfileObjectClientBean.CLASS_NAME, UserProfileObjectClientBean.DIRECTORYUSEROBJECT_ATTRIBUTE, (Object)this, false);
        sc.setSearchClauseAND();
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME, "DirectoryUserObjectClientBean.getUserProfileObjects");
        goRet = sc.getItems();
        sc.closeSearch();
        return goRet;
    }

    @ObjDocAttribute(value="get primary user profil")
    public PrimaryUserProfileObjectClientBean getPrimaryUserProfile() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getPrimrayUserProfile(this.sessionController, this);
    }

    @Deprecated
    public PrimaryUserProfileObjectClientBean getPrimrayUserProfile() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getPrimrayUserProfile(this.sessionController, this);
    }

    public EmailUserProfileObjectClientBean[] getEmailUserProfiles() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getEmailUserProfiles(this.sessionController, this);
    }

    @ObjDocAttribute(value="get info user profile")
    public InfoUserProfileObjectClientBean getInfoUserProfile() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getInfoUserProfile(this.sessionController, this);
    }

    public AppUserProfileObjectClientBean[] getApplicationUserProfiles(String application) throws Exception {
        String value = null;
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getApplicationUserProfiles(this.sessionController, this, application, value);
    }

    public AppUserProfileObjectClientBean getApplicationUserProfile(String application, String keyword) throws Exception {
        AppUserProfileObjectClientBean[] arr = ((DirectoryUserObjectRemote)this.getRemoteReference()).getApplicationUserProfiles(this.sessionController, this, application, keyword);
        return arr == null ? null : arr[0];
    }

    public AppUserProfileObjectClientBean[] getApplicationUserProfilesWithWildcard(String application, String keyword) throws Exception {
        AppUserProfileObjectClientBean[] arr = ((DirectoryUserObjectRemote)this.getRemoteReference()).getApplicationUserProfilesWithWildcard(this.sessionController, this, application, keyword);
        return arr == null ? null : arr;
    }

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new DirectoryUserObjectClientBeanDefinition(sessionController);
    }

    public EmailUserProfileObjectClientBean getDefaultEmailUserProfile(SessionController sessionController) throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getDefaultEmailUserProfile(sessionController, this);
    }

    public void setEmailAddresses(SessionController sessionController, String[] addresses) throws Exception {
        ((DirectoryUserObjectRemote)this.getRemoteReference()).setEmailAddresses(sessionController, this, addresses);
    }

    @Override
    @ObjDocAttribute(value="get xml of the client bean")
    public String getXml() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getXml(false));
        InfoUserProfileObjectClientBean infoUserProfile = this.getInfoUserProfile();
        sb.append("<INFOUSERPROFILE>\n");
        if (infoUserProfile != null) {
            sb.append(infoUserProfile.getXml());
        }
        sb.append("</INFOUSERPROFILE>\n");
        EmailUserProfileObjectClientBean[] emailUserProfiles = this.getEmailUserProfiles();
        sb.append("<EMAILUSERPROFILES>\n");
        if (emailUserProfiles != null) {
            int len = emailUserProfiles.length;
            for (int i = 0; i < len; ++i) {
                if (emailUserProfiles[i] == null) continue;
                sb.append(emailUserProfiles[i].getXml());
            }
        }
        sb.append("</EMAILUSERPROFILES>\n");
        sb.append("<FULLNAME>\n");
        String fullName = this.getFullName();
        if (fullName != null) {
            sb.append(fullName);
        }
        sb.append("</FULLNAME>\n");
        sb.append(this.getXMLEndTag(this.sessionController));
        return sb.toString();
    }

    @Override
    public void executeBeforeItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro, SuperObjectClientBeanDefinition relDef) throws Exception {
        if (!sessionController.isInSychronization()) {
            String pathPrefix = "/agorum/roi/administration/user";
            String loFolderPath = null;
            try {
                loFolderPath = lo.getAnyFolderPath().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loFolderPath != null && !loFolderPath.startsWith(pathPrefix)) {
                ExceptionUtils.handleException("Wrong folder for an user", "agorum.roi.remote.exception.WrongFolderForObject", 65);
            }
        }
        super.executeBeforeItemAdded(sessionController, lo, ro, relDef);
    }

    @Override
    public void executeAfterItemAdded(SessionController sessionController, GlobalObjectClientBean lo, GlobalObjectClientBean ro) throws Exception {
        if (this.getId().longValue() == ro.getId().longValue()) {
            String[] fullPath;
            System.err.println("executeAfterItemAdded : " + ro.getName());
            FolderObjectClientBean baseFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Administration/User");
            if (baseFolder != null && (fullPath = lo.getAllFolderPath()) != null) {
                DirectoryUserObjectSessionFacade facade2 = new DirectoryUserObjectSessionFacade(sessionController);
                facade2.setWithTransaction(true);
                facade2.setGlobalObject(ro);
                facade2.setDestinationFolder((FolderObjectClientBean)sessionController.findGlobalObjectByPath(fullPath[0]));
                facade2.addItemNotification();
            }
        }
    }

    @ObjDocAttribute(value="get fullName of this user object")
    public String getFullName() throws Exception {
        String fullName = null;
        try {
            fullName = this.getInfoUserProfile().getFullName().trim();
            if (fullName == null || fullName.length() == 0) {
                fullName = this.getName().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fullName;
    }

    @Override
    public void leaveAclAfterMove(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
    }

    @ObjDocAttribute(value="Getter for property readOnlyMode.")
    public boolean getReadOnlyMode() throws Exception {
        return (this.getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) > 0L;
    }

    public void setReadOnlyMode(boolean readOnlyMode) throws Exception {
        ((DirectoryUserObjectRemote)this.getRemoteReference()).setReadOnlyMode(this.sessionController, this, readOnlyMode);
    }

    @Deprecated
    public String getHomePath() throws Exception {
        return "/Home/" + this.getName();
    }

    @ObjDocAttribute(value="get the allowed quota for the user (can also depend on the group)<br />this is not the direct attached quota for the user!")
    public long getQuotaAllocatedStorage() throws Exception {
        return QuotaHelper.getAllocatedSpace(this.sessionController, this);
    }

    @ObjDocAttribute(value="get the given name (first name) of the user")
    public String getGivenName() throws Exception {
        return this.getInfoUserProfile().getGivenName();
    }

    @ObjDocAttribute(value="set the given name (first name) of the user")
    public void setGivenName(String value) throws Exception {
        this.getInfoUserProfile().setGivenName(value);
    }

    @ObjDocAttribute(value="get the family name of the user")
    public String getFamilyName() throws Exception {
        return this.getInfoUserProfile().getFamilyName();
    }

    @ObjDocAttribute(value="set the family name of the user")
    public void setFamilyName(String value) throws Exception {
        this.getInfoUserProfile().setFamilyName(value);
    }

    @ObjDocAttribute(value="get the language of the user (e.g. en, de, ...")
    public String getLanguage() throws Exception {
        return this.getInfoUserProfile().getLanguage();
    }

    @ObjDocAttribute(value="set the language of the user (e.g. en, de, ...")
    public void setLanguage(String value) throws Exception {
        this.getInfoUserProfile().setLanguage(value);
    }

    @ObjDocAttribute(value="get the email addresses of the user")
    public String[] getEmailAddresses() throws Exception {
        ArrayList<String> mailAddresses = new ArrayList<String>();
        EmailUserProfileObjectClientBean[] emailProfiles = this.getEmailUserProfiles();
        if (emailProfiles != null) {
            for (EmailUserProfileObjectClientBean emailProfile : emailProfiles) {
                mailAddresses.add(emailProfile.getEmailAddress());
            }
        }
        return mailAddresses.toArray(new String[0]);
    }

    @ObjDocAttribute(value="set the email addresses of the user")
    public void setEmailAddresses(String[] values) throws Exception {
        ((DirectoryUserObjectRemote)this.getRemoteReference()).setEmailAddresses(this.sessionController, this, values);
    }

    @ObjDocAttribute(value="get the consumed storage of this user")
    public long getQuotaConsumedStorage() throws Exception {
        return QuotaHelper.getConsumedSpace(this.sessionController, this);
    }

    @ObjDocAttribute(value="get the last login date from this user (not the active one)")
    public Date getLastLoginDate() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getLastLoginDate(this.sessionController, this, false);
    }

    @ObjDocAttribute(value="get the current login date from this user (the active one or the last one)")
    public Date getCurrentLoginDate() throws Exception {
        return ((DirectoryUserObjectRemote)this.getRemoteReference()).getLastLoginDate(this.sessionController, this, true);
    }

    private static GenericCache getProfilePictureCache() {
        return GenericCache.getInstance((Object)"ProfilePictureCache", (int)Integer.MAX_VALUE, (int)10000, (int)600000);
    }

    @ObjDocAttribute(value="get the user's profile picture")
    public FileObjectClientBean getProfilePicture() throws Exception {
        GlobalObjectClientBean[] profilePics;
        GenericCache gc = DirectoryUserObjectClientBean.getProfilePictureCache();
        if (gc.contains((Object)this.getId())) {
            Long ppId = (Long)gc.get((Object)this.getId());
            if (ppId != -1L) {
                FileObjectClientBean fo = null;
                try {
                    fo = (FileObjectClientBean)this.sessionController.getGlobalObjectById(ppId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fo != null) {
                    return fo;
                }
            } else {
                return null;
            }
        }
        SessionController scAdmin = SessionControllerAdmin.getService("ProfilePicture");
        DirectoryUserObjectClientBean usrCpy = (DirectoryUserObjectClientBean)scAdmin.getGlobalObjectById(this.getId());
        FolderObjectClientBean home = SessionController.getHomeFolder(usrCpy);
        home = (FolderObjectClientBean)home.getItem("MyAdmin");
        FolderObjectClientBean profileFolder = null;
        if (home != null && home.hasItem("Profile")) {
            profileFolder = (FolderObjectClientBean)home.getItem("Profile");
        }
        if (profileFolder != null && (profilePics = profileFolder.getItems()) != null) {
            for (GlobalObjectClientBean profilePic : profilePics) {
                if (!profilePic.getName().startsWith("picture.")) continue;
                Long ppId = profilePic.getId();
                gc.put((Object)this.getId(), (Object)ppId);
                return (FileObjectClientBean)this.sessionController.getGlobalObjectById(ppId);
            }
        }
        gc.put((Object)this.getId(), (Object)-1L);
        return null;
    }

    @ObjDocAttribute(value="set the user's profile picture")
    public void setProfilePicture(FileObjectClientBean picture) throws Exception {
        FileObjectClientBean profPic = this.getProfilePicture();
        if (profPic == null) {
            FolderObjectClientBean home = SessionController.getHomeFolder(this);
            RoiFileSystem rfs = new RoiFileSystem(this.getSessionController());
            FolderObjectClientBean profFolder = rfs.createFullpath("MyAdmin/Profile", home, home.getAcl(), true);
            FileObjectClientBeanDefinition fDef = new FileObjectClientBeanDefinition(this.getSessionController());
            fDef.setName("picture." + picture.getNameExtension());
            fDef.setAddToFolderOption(profFolder);
            profPic = (FileObjectClientBean)this.sessionController.createGlobalObject(fDef);
            profPic.setContent(picture.getContentStream());
        } else {
            profPic.setContent(picture.getContentStream());
        }
        profPic.setAcl(this.getSessionController().getAclByName("Published"));
        GenericCache gc = DirectoryUserObjectClientBean.getProfilePictureCache();
        gc.put((Object)this.getId(), (Object)profPic.getId());
    }

    @ObjDocAttribute(value="get the user's profile picture as a stream")
    public InputStream getProfilePictureContent() throws Exception {
        FileObjectClientBean ci = this.getProfilePicture();
        if (ci == null) {
            return new FileInputStream(System.getProperty("jboss.server.home.dir") + "/deploy/roi.ear/roiwebui.war/home_module/img/profilepicture-default.png");
        }
        return ci.getContentStream();
    }

    public void setProfilePicture(FileObjectClientBean picture, boolean deleteSource) throws Exception {
        this.setProfilePicture(picture);
        if (deleteSource) {
            picture.delete();
        }
    }

    @Override
    public void fillIndexAttributes(Map<String, AttributeInfo> attributes, GlobalObjectClientBean mainObject) throws Exception {
        super.fillIndexAttributes(attributes, mainObject);
        InfoUserProfileObjectClientBean infoProfile = this.getInfoUserProfile();
        if (infoProfile != null) {
            infoProfile.fillIndexAttributes(attributes, mainObject);
        }
        EmailUserProfileObjectClientBean[] emailProfiles = this.getEmailUserProfiles();
        ArrayList<String> emailAddresses = new ArrayList<String>();
        if (emailProfiles != null) {
            for (EmailUserProfileObjectClientBean emailProfile : emailProfiles) {
                emailProfile.fillIndexAttributes(attributes, mainObject);
                emailAddresses.add(emailProfile.getEmailAddress());
            }
        }
        if (!emailAddresses.isEmpty()) {
            AttributeInfo.put(attributes, "emailaddresses", emailAddresses);
        }
        AttributeInfo.put(attributes, "readonlymode", this.getReadOnlyMode());
        AttributeInfo.put(attributes, "fullname", AttributeInfo.getFromObject(this.getFullName()));
        AttributeInfo.put(attributes, "lastlogindate", AttributeInfo.getFromObject(this.getLastLoginDate()));
        AttributeInfo.put(attributes, "currentlogindate", AttributeInfo.getFromObject(this.getCurrentLoginDate()));
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        if (!this.sessionController.isInSychronization()) {
            boolean isModify;
            long effAccessLevel = 0xFFFFFFFAL;
            boolean bl = isModify = (effAccessLevel & accessLevel) > 0L;
            if (isModify && this.sessionController.isMainAdmin(this.getId(), this.getId()) && !this.sessionController.isMainAdmin()) {
                return false;
            }
        }
        return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
    }

    @Override
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        if (def != null && def.getSystemOption("SetExpirationDateInsteadOfDelete") != null) {
            ExceptionUtils.handleException("User can not be put into the trash, but only deleted directly", "agorum.roi.remote.exception.NotAllowed", 20);
        }
        super.delete(def);
    }
}

