/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.ApplicationObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;

@ObjDoc(groups={ObjDoc.Group.ADMINISTRATION}, description="Client Bean for the ContentQuotaObject Class")
public class ContentQuotaObjectClientBean
extends ApplicationObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "CONTENTQUOTAOBJECT";
    public static String ALLOCATEDSTORAGE_ATTRIBUTE = "ALLOCATEDSTORAGE";
    public static String CONSUMEDSTORAGE_ATTRIBUTE = "CONSUMEDSTORAGE";
    public static String ASSOCIATEDGLOBALOBJECT_ATTRIBUTE = "ASSOCIATEDGLOBALOBJECT";
    public static String UNIQUENAME_ATTRIBUTE = "UNIQUENAME";
    public static String ENABLED_ATTRIBUTE = "ENABLED";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new ContentQuotaObjectClientBeanDefinition(sessionController);
    }

    @ObjDocAttribute(value="Return the allocated storage of the Object")
    public long getAllocatedStorage() throws Exception {
        return this.getAttribute(ALLOCATEDSTORAGE_ATTRIBUTE).getLong();
    }

    public void setAllocatedStorage(long allocatedStorage) throws Exception {
        this.setAttribute(ALLOCATEDSTORAGE_ATTRIBUTE, AttributeValue.newAttributeValueObject(allocatedStorage));
    }

    @ObjDocAttribute(value="Return the consumed storage of the Object")
    public long getConsumedStorage() throws Exception {
        return this.getAttribute(CONSUMEDSTORAGE_ATTRIBUTE).getLong();
    }

    public void setConsumedStorage(long consumedStorage) throws Exception {
        this.setAttribute(CONSUMEDSTORAGE_ATTRIBUTE, AttributeValue.newAttributeValueObject(consumedStorage));
    }

    @ObjDocAttribute(value="get enable status")
    public boolean getEnabled() throws Exception {
        return this.getAttribute(ENABLED_ATTRIBUTE).getBoolean();
    }

    public void setEnabled(boolean enabled) throws Exception {
        this.setAttribute(ENABLED_ATTRIBUTE, AttributeValue.newAttributeValueObject(enabled));
    }

    @ObjDocAttribute(value="get unique name")
    public String getUniqueName() throws Exception {
        return this.getAttribute(UNIQUENAME_ATTRIBUTE).getString();
    }

    public void setUniqueName(String uniqueName) throws Exception {
        this.setAttribute(UNIQUENAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(uniqueName));
    }

    @ObjDocAttribute(value="Return the associated global object of the Object")
    public DirectoryObjectClientBean getAssociatedGlobalObject() throws Exception {
        GlobalObjectClientBean obj = this.getAttribute(ASSOCIATEDGLOBALOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
        if (obj instanceof DirectoryObjectClientBean) {
            return (DirectoryObjectClientBean)obj;
        }
        return null;
    }

    public void setAssociatedGlobalObject(DirectoryObjectClientBean associatedObject) throws Exception {
        if (associatedObject != null) {
            this.setAttribute(ASSOCIATEDGLOBALOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(this.id));
        }
    }

    @Override
    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NORMAL;
    }
}

