/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ExtendedUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.UnsupportedEncodingException;

@ObjDoc(groups={ObjDoc.Group.USERMANAGEMENT}, description="Client Bean for the AppUserProfileObject Class")
public class AppUserProfileObjectClientBean
extends ExtendedUserProfileObjectClientBean {
    private static final long serialVersionUID = 1L;
    public static String CLASS_NAME = "APPUSERPROFILEOBJECT";
    public static final String APPKEYWORD_ATTRIBUTE = "APPKEYWORD";
    public static final String APPVALUE_ATTRIBUTE = "APPVALUE";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new AppUserProfileObjectClientBeanDefinition(sessionController);
    }

    public void setAppKeyWord(String value) throws Exception {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setAttribute(APPKEYWORD_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setAppValue(String value) throws Exception {
        this.setAttribute(APPVALUE_ATTRIBUTE, AppUserProfileObjectClientBean.stringToBlob(value));
    }

    @ObjDocAttribute(value="the app key word")
    public String getAppKeyWord() throws Exception {
        return this.getAttribute(APPKEYWORD_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the app value")
    public String getAppValue() throws Exception {
        return AppUserProfileObjectClientBean.blobToString(this.getAttribute(APPVALUE_ATTRIBUTE));
    }

    @Override
    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NORMAL;
    }

    private static AttributeValue stringToBlob(String value) throws Exception {
        if (value == null) {
            return null;
        }
        return AttributeValue.newAttributeValueObject(value.getBytes("UTF-8"));
    }

    private static String blobToString(AttributeValue av) throws UnsupportedEncodingException {
        if (av == null) {
            return null;
        }
        byte[] bytes = av.getBlob();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }
}

