/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.CustomFileObjectCallBack;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.cache.MetaDbCache;

public class MetaDbPropertyEntryObjectCallBack
extends CustomFileObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        this.encryptValue(sessionController, def);
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        MetaDbCache.getInstance().update((GlobalObjectClientBean)clientBean);
        super.executeAfterUpdate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.encryptValue(sessionController, def);
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    private void encryptValue(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        MetaDbPropertyEntryObjectClientBeanDefinition entryDef = (MetaDbPropertyEntryObjectClientBeanDefinition)def;
        AttributeValue av = entryDef.getAttribute("ENTRYDATATYPE");
        if (av != null && av.getLong() == 8192L) {
            String value = entryDef.getAttribute("STRINGVALUE").getString();
            if (value != null && value.length() > 0) {
                if (sessionController.isInSychronization()) {
                    entryDef.setStringValue(value);
                } else {
                    CryptKeyController cryptKeyController = new CryptKeyController();
                    entryDef.setStringValue(cryptKeyController.encrypt(value, "metadb", sessionController));
                }
            } else {
                entryDef.setAttribute("STRINGVALUE", null);
            }
        }
    }
}

