/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.common.FolderItemsChangedDeleted;
import agorum.roi.common.utils.CycleUtils;
import agorum.roi.ejb.callback.CustomFolderRelationObjectCallBack;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.FolderUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import java.sql.Connection;

public class FolderPathRelationObjectCallBack
extends CustomFolderRelationObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        FolderPathRelationObjectClientBeanDefinition gDef = (FolderPathRelationObjectClientBeanDefinition)def;
        GlobalObjectClientBean leftObject = gDef.getLeftObject();
        GlobalObjectClientBean rightObject = gDef.getRightObject();
        gDef.setLeftObjectCopy(leftObject);
        gDef.setRightObjectName(rightObject.getName().toLowerCase());
        if (sessionController.isFolder(rightObject)) {
            RoiFileSystem rfs = new RoiFileSystem(sessionController);
            rfs.doCycleCheck(leftObject, rightObject);
        }
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue av = clientBean.getAttribute(FolderPathRelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE);
        if (av != null) {
            Long folderId = av.getLong();
            GlobalObjectClientBean object = null;
            object = sessionController.getGlobalObjectById(folderId);
            if (object != null && object instanceof FolderObjectClientBean) {
                FolderUtils folderUtils = new FolderUtils(sessionController, (FolderObjectClientBean)object);
                folderUtils.performFolderTask(def, true);
            }
        }
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        FolderPathRelationObjectClientBean fpro = (FolderPathRelationObjectClientBean)clientBean;
        GlobalObjectClientBean ro = fpro.getRightObject();
        if (sessionController.isFolder(ro)) {
            ConnectionUtils cou = null;
            try {
                CycleUtils cu = new CycleUtils(sessionController);
                cou = new ConnectionUtils(sessionController);
                Connection conn = cou.getConnection();
                cu.deleteCycleCheck(conn, fpro.getLeftObject().getId(), fpro.getRightObject().getId());
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    cou.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        if (ro.supportsFolderItemsChangeDelete()) {
            FolderItemsChangedDeleted.invalidateOnCommit(fpro.getLeftObjectId(), null, false);
        }
        super.executeBeforeDelete(sessionController, def, clientBean);
    }
}

