/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.callback.CustomDirectoryObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AclUserResolver;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.interfaces.adminsync.AdminSyncServiceCaller;
import java.util.Vector;

public class DirectoryGroupObjectCallBack
extends CustomDirectoryObjectCallBack {
    public static final String METADB_BASE = "MAIN_GROUP_MANAGEMENT";

    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        DirectoryGroupObjectClientBeanDefinition gDef = (DirectoryGroupObjectClientBeanDefinition)def;
        if (gDef.getIsFolderAV() == null) {
            gDef.setIsFolder(true);
        }
        gDef.setOwnerUniqueName(gDef.getName());
        super.executeBeforeCreate(sessionController, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        if (!sessionController.isInSychronization() && sessionController.isWorldGroup((DirectoryGroupObjectClientBean)clientBean)) {
            ExceptionUtils.handleException("World group must not be changed", "agorum.roi.remote.exception.NoAccess", 21);
        }
        GenericCache gc = null;
        String adminSyncKey = "noAdminSyncFor_" + ((GlobalObjectClientBean)clientBean).getId();
        try {
            gc = GenericCache.getInstance((Object)("AdminSyncGenericCache_" + sessionController.getSessionId()), (int)10000, (int)1000000, (int)8000000);
            gc.put((Object)adminSyncKey, (Object)"");
            System.err.println("put (Delete): " + adminSyncKey);
            AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
            assu.syncObject(sessionController, (GlobalObjectClientBean)clientBean, null, null, null, true, def.getAllSystemOption(), "executeBeforeDelete");
            DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)clientBean;
            AclUserResolver.removeAllEntrysFromDirectoryObject(group);
            group.removeMembers(group.getDirectMembers());
            AccessControlListObjectClientBean acl = group.getAcl();
            String uuid = group.getUUID();
            if (acl.getName().equals("ACL_GROUP_" + uuid)) {
                group.setAcl(sessionController.getAclByName("private"));
                long counter = sessionController.getAclUsedCount(acl);
                if (counter == 0L) {
                    acl.delete();
                }
            }
            super.executeBeforeDelete(sessionController, def, clientBean);
        }
        finally {
            if (gc != null && gc.contains((Object)adminSyncKey)) {
                System.err.println("remove (Delete): " + adminSyncKey);
                gc.remove((Object)adminSyncKey);
            }
        }
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AttributeValue av;
        if (!sessionController.isInSychronization() && sessionController.isWorldGroup((DirectoryGroupObjectClientBean)clientBean)) {
            ExceptionUtils.handleException("World group must not be changed", "agorum.roi.remote.exception.NoAccess", 21);
        }
        if ((av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) != null) {
            def.setAttribute(DirectoryGroupObjectClientBean.OWNERUNIQUENAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(av.getString()));
        }
        this.addOrRemoveMembers(sessionController, (DirectoryGroupObjectClientBeanDefinition)def, (DirectoryGroupObjectClientBean)clientBean);
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        GenericCache gc = null;
        String adminSyncKey = "noAdminSyncFor_" + ((GlobalObjectClientBean)clientBean).getId();
        DirectoryGroupObjectClientBean ducb = (DirectoryGroupObjectClientBean)clientBean;
        String aclName = "ACL_GROUP_" + ducb.getUUID();
        AccessControlListObjectClientBean acl = sessionController.getAclByName(aclName);
        if (acl == null) {
            AccessControlListObjectClientBeanDefinition aclDef = new AccessControlListObjectClientBeanDefinition(sessionController);
            aclDef.setName(aclName);
            aclDef.setAttribute(AccessControlListObjectClientBean.ADMINSAFFECTED_ATTRIBUTE, AttributeValue.newAttributeValueObject(true));
            acl = (AccessControlListObjectClientBean)sessionController.createGlobalObject(aclDef);
            AccessControlEntryObjectClientBeanDefinition ace = new AccessControlEntryObjectClientBeanDefinition(sessionController);
            ace.setGranted(true);
            ace.setGrantee(ducb);
            PermissionBundleObjectClientBean pb = sessionController.getPermissionBundleByName("AG_PB_READ");
            ace.addPermissionBundle(pb);
            acl.grantOrRevokeAccess(ace);
        }
        ducb.setScopeAcl(acl);
        try {
            this.addOrRemoveMembers(sessionController, (DirectoryGroupObjectClientBeanDefinition)def, (DirectoryGroupObjectClientBean)clientBean);
            gc = GenericCache.getInstance((Object)("AdminSyncGenericCache_" + sessionController.getSessionId()), (int)10000, (int)1000000, (int)8000000);
            gc.put((Object)adminSyncKey, (Object)"");
            System.err.println("put (create): " + adminSyncKey);
            super.executeAfterCreate(sessionController, def, clientBean);
            AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
            assu.syncObject(sessionController, (GlobalObjectClientBean)clientBean, null, null, null, false, def.getAllSystemOption(), "executeAfterCreate");
        }
        finally {
            if (gc != null && gc.contains((Object)adminSyncKey)) {
                System.err.println("remove (create): " + adminSyncKey);
                gc.remove((Object)adminSyncKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        GenericCache gc = null;
        String adminSyncKey = "noAdminSyncFor_" + ((GlobalObjectClientBean)clientBean).getId();
        String name = ((GlobalObjectClientBean)clientBean).getName();
        AttributeValue av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE);
        String oldName = null;
        if (av != null) {
            oldName = name;
            name = av.getString();
        }
        if (!(gc = GenericCache.getInstance((Object)("AdminSyncGenericCache_" + sessionController.getSessionId()), (int)10000, (int)10000, (int)80000)).contains((Object)adminSyncKey)) {
            try {
                System.err.println("put (Update): " + adminSyncKey);
                gc.put((Object)adminSyncKey, (Object)"");
                super.executeAfterUpdate(sessionController, def, clientBean);
                AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
                assu.syncObject(sessionController, (GlobalObjectClientBean)clientBean, null, name, oldName, false, def.getAllSystemOption(), "executeAfterUpdate");
            }
            finally {
                if (gc != null && gc.contains((Object)adminSyncKey)) {
                    System.err.println("remove (Update) : " + adminSyncKey);
                    gc.remove((Object)adminSyncKey);
                }
            }
        } else {
            super.executeAfterUpdate(sessionController, def, clientBean);
        }
    }

    private void addOrRemoveMembers(SessionController sessionController, DirectoryObjectClientBeanDefinition def, DirectoryGroupObjectClientBean group) throws Exception {
        boolean resolveAcls = false;
        if (this.removeMembers(sessionController, def, group)) {
            resolveAcls = true;
        }
        if (this.addMember(sessionController, def, group)) {
            resolveAcls = true;
        }
        if (resolveAcls) {
            sessionController.resolveAffectedAcls(group);
        }
    }

    private boolean removeMembers(SessionController sessionController, DirectoryObjectClientBeanDefinition def, DirectoryGroupObjectClientBean group) throws Exception {
        DirectoryObjectClientBean[] dObjects;
        if (!sessionController.isInSychronization() && sessionController.isWorldGroup(group)) {
            ExceptionUtils.handleException("World group must not be changed", "agorum.roi.remote.exception.NoAccess", 21);
        }
        boolean b = false;
        if (def.getSystemOption("groupRemoveMembers") != null && (dObjects = (DirectoryObjectClientBean[])def.getSystemOption("groupRemoveMembers")) != null) {
            int len = dObjects.length;
            for (int i = 0; i < len; ++i) {
                this.onlyRemoveMember(sessionController, group, dObjects[i]);
            }
            def.setSystemOption("PerformUpdateCallbacks", "");
            b = true;
        }
        return b;
    }

    private void onlyRemoveMember(SessionController sessionController, DirectoryGroupObjectClientBean group, DirectoryObjectClientBean dObject) throws Exception {
        RelationObjectClientBean[] relArr;
        if (dObject != null && (relArr = group.getRelations(GroupMemberRelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, dObject)) != null && relArr.length > 0) {
            group.removeRelationship(relArr[0]);
        }
    }

    private boolean addMember(SessionController sessionController, DirectoryObjectClientBeanDefinition def, DirectoryGroupObjectClientBean group) throws Exception {
        if (!sessionController.isInSychronization() && sessionController.isWorldGroup(group)) {
            ExceptionUtils.handleException("World group must not be changed", "agorum.roi.remote.exception.NoAccess", 21);
        }
        boolean b = false;
        if (def.getSystemOption("groupAddMembers") != null) {
            DirectoryObjectClientBean[] dObjects = (DirectoryObjectClientBean[])def.getSystemOption("groupAddMembers");
            boolean primaryGroup = false;
            if (def.getSystemOption("groupAddMembersPrimaryGroup") != null) {
                try {
                    primaryGroup = (Boolean)def.getSystemOption("primaryGroup");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GroupMemberRelationObjectClientBeanDefinition rel = new GroupMemberRelationObjectClientBeanDefinition(sessionController);
            Vector<DirectoryObjectClientBean> membersArr = new Vector<DirectoryObjectClientBean>();
            DirectoryObjectClientBean[] dObjectsNoGroupMembers = null;
            if (dObjects != null) {
                int i;
                int len = dObjects.length;
                for (i = 0; i < len; ++i) {
                    if (group.isDirectMember(dObjects[i])) continue;
                    membersArr.addElement(dObjects[i]);
                }
                len = membersArr.size();
                if (len > 0) {
                    dObjectsNoGroupMembers = new DirectoryObjectClientBean[len];
                    for (i = 0; i < len; ++i) {
                        DirectoryObjectClientBean groupMember;
                        dObjectsNoGroupMembers[i] = groupMember = (DirectoryObjectClientBean)membersArr.elementAt(i);
                    }
                }
            }
            if (dObjectsNoGroupMembers != null && dObjectsNoGroupMembers.length > 0) {
                rel.setPrimaryGroup(primaryGroup);
                group.addRelationship(dObjectsNoGroupMembers, (RelationObjectClientBeanDefinition)rel);
                def.setSystemOption("PerformUpdateCallbacks", "");
                b = true;
            }
        }
        return b;
    }
}

