/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.callback.CustomGlobalObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AclUserResolver;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.BaseDatabaseImpl;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class AccessControlListObjectCallBack
extends CustomGlobalObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        AccessControlListObjectClientBeanDefinition gDef = (AccessControlListObjectClientBeanDefinition)def;
        gDef.setOwnerUniqueName(gDef.getName());
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.grantOrRevokeAccess(sessionController, (AccessControlListObjectClientBeanDefinition)def, (AccessControlListObjectClientBean)clientBean);
        sessionController.resolveAcl((AccessControlListObjectClientBean)clientBean);
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    private void grantOrRevokeAccess(SessionController sessionController, AccessControlListObjectClientBeanDefinition def, AccessControlListObjectClientBean acl) throws Exception {
        int len;
        AccessControlEntryObjectClientBeanDefinition[] aces = def.getGranteeOrRevokeeAceDefinition();
        if (aces != null && (len = aces.length) > 0) {
            for (int i = 0; i < len; ++i) {
                aces[i].resolvePermissionBundles();
                if (aces[i].getAttribute(AccessControlEntryObjectClientBean.ACL_ATTRIBUTE) == null) {
                    aces[i].setAcl(acl);
                }
                sessionController.createInternalObject(aces[i]);
            }
            sessionController.resolveAcl(acl);
        }
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AccessControlListObjectClientBeanDefinition gDef = (AccessControlListObjectClientBeanDefinition)def;
        AttributeValue av = gDef.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE);
        if (av != null) {
            gDef.setOwnerUniqueName(av.getString());
        }
        this.grantOrRevokeAccess(sessionController, (AccessControlListObjectClientBeanDefinition)def, (AccessControlListObjectClientBean)clientBean);
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)clientBean;
        if (sessionController.getAclUsedCount(acl) > 0L) {
            BaseDatabaseImpl dbi = (BaseDatabaseImpl)new DatabaseUtils().getDatabaseInterfaceImpl();
            boolean unchanged = true;
            try (Connection connection = new ConnectionUtils().getConnection();
                 PreparedStatement ps = connection.prepareStatement("select a.objectid from aclobjecttable a left outer join globalobject g on a.objectid = g.id where a.aclid = ?", 1003, 1007);){
                ps.setLong(1, acl.getId());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        unchanged = false;
                        dbi.deleteAclObjectTableAllScopes(connection, rs.getLong(1));
                    }
                }
            }
            if (unchanged || sessionController.getAclUsedCount(acl) > 0L) {
                throw ExceptionUtils.get("ACL couldn't be deleted, it has a reference to an object", "agorum.roi.remote.exception.AclHasReference", 402);
            }
        }
        acl.removeAllAccessControlEntryObject();
        AclUserResolver.removeAcl(acl);
        super.executeBeforeDelete(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        sessionController.resolveAcl((AccessControlListObjectClientBean)clientBean);
        super.executeAfterUpdate(sessionController, def, clientBean);
    }
}

