/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.DbRoiSequencePrimaryKey;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;

public class RoiSequenceIdEntity
implements EntityBean {
    protected transient boolean dirty;
    private transient long sequenceId;
    private transient String sequenceIdentifier;
    protected EntityContext eCtx = null;
    public static final long SEQUENCE_POOL_SIZE = 200L;

    public DbRoiSequencePrimaryKey ejbCreate(DbRoiSequencePrimaryKey pk) throws CreateException {
        return pk;
    }

    public void ejbPostCreate(DbRoiSequencePrimaryKey pk) {
        this.dirty = false;
    }

    public void ejbPassivate() {
        System.err.println("SEQ ejbPassivate");
        this.dirty = false;
        this.sequenceId = 0L;
        this.sequenceIdentifier = null;
    }

    public void ejbActivate() {
        System.err.println("SEQ ejbActivate");
        DbRoiSequencePrimaryKey pk = (DbRoiSequencePrimaryKey)this.eCtx.getPrimaryKey();
        this.sequenceIdentifier = pk.getSequnceIdentifier();
        this.dirty = true;
    }

    public void ejbRemove() throws RemoteException {
    }

    public void unsetEntityContext() throws RemoteException {
        this.eCtx = null;
    }

    public void setEntityContext(EntityContext eCtx) throws RemoteException {
        this.eCtx = eCtx;
    }

    public void ejbStore() throws RemoteException {
        if (this.dirty) {
            Connection conn = null;
            ConnectionUtils cu = new ConnectionUtils();
            try {
                conn = cu.getConnection(true);
                String update = "update SEQUENCE_T set SEQUENCE_ID = ? where SEQUENCE_IDENT=?";
                if (this.sequenceId < 1000000L) {
                    System.err.println("SequenceId is below 100000, something wrong, shutting down to prevent errors");
                    System.exit(1);
                }
                try (PreparedStatement pstmt = conn.prepareStatement(update);){
                    pstmt.setLong(1, this.sequenceId);
                    pstmt.setString(2, this.sequenceIdentifier);
                    pstmt.executeUpdate();
                }
            }
            catch (Exception e) {
                throw new RemoteException("Error storing SequenceId");
            }
            finally {
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        this.dirty = false;
    }

    public void ejbLoad() throws RemoteException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ConnectionUtils cu = new ConnectionUtils();
        try {
            conn = cu.getConnection(true);
            String select = "select SEQUENCE_ID from SEQUENCE_T where SEQUENCE_IDENT=?";
            pstmt = conn.prepareStatement(select);
            pstmt.setString(1, this.sequenceIdentifier);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.sequenceId = rs.getLong(1);
            }
            if (this.sequenceId < 1000000L) {
                System.err.println("SequenceId is below 100000, something wrong, shutting down to prevent errors");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RemoteException("Error storing SequenceId");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        this.dirty = false;
    }

    public DbRoiSequencePrimaryKey ejbFindByPrimaryKey(DbRoiSequencePrimaryKey pk) throws FinderException, RemoteException {
        if (pk == null || pk.getSequnceIdentifier() == null) {
            throw new FinderException("PK is null");
        }
        return pk;
    }

    public synchronized Long getSequenceId() throws RemoteException, Exception {
        return this.getSequenceId(200L);
    }

    public synchronized Long getSequenceId(long amount) throws RemoteException, Exception {
        this.sequenceId += amount;
        Long id = new Long(this.sequenceId);
        if (id < 1000000L) {
            System.err.println("SequenceId is below 100000, something wrong, shutting down to prevent errors");
            System.exit(1);
        }
        this.dirty = true;
        return id;
    }
}

