/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.EventAssistanceBean;
import agorum.roi.ejb.common.EventAssistanceUtils;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;

public class EventAssistanceMessageMDB
implements MessageDrivenBean,
MessageListener {
    private MessageDrivenContext ctx = null;
    private QueueConnection conn = null;
    private QueueSession session = null;
    private SessionController sessionController = null;
    private static Hashtable userEventAssistanceHash = null;

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.ctx = ctx;
    }

    public void ejbCreate() {
        try {
            System.err.println("-------==============================----------");
            System.err.println("ejbCreate: EventAssistanceMessageMDB registered");
            System.err.println("-------==============================----------");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void ejbRemove() {
        System.err.println("-------================================----------");
        System.err.println("ejbRemove: EventAssistanceMessageMDB unregistered");
        System.err.println("-------================================----------");
        this.ctx = null;
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessage(Message msg) {
        try {
            String eventInfo = (String)msg.getObjectProperty("value");
            StringTokenizer st = new StringTokenizer(eventInfo, "||");
            Long id = new Long(st.nextElement().toString());
            String action = st.nextElement().toString();
            System.err.println("----==== Event Assistance ====----");
            System.err.println("Object: " + id);
            System.err.println("EventType: " + action);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private void saveToEventAssistance(Long id, String action, EventAssistanceUtils eau) throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(id);
        GlobalObjectClientBean mainObject = gocb.getMainObject();
        if (mainObject != null && mainObject.getId().longValue() != gocb.getId().longValue()) {
            gocb = mainObject;
        }
        if (gocb != null) {
            Hashtable<String, List<GlobalObjectClientBean>> folderHash = gocb.getAllFolderPathObjects();
            Enumeration<List<GlobalObjectClientBean>> folderEnum = folderHash.elements();
            while (folderEnum.hasMoreElements()) {
                Vector pathPieces = (Vector)folderEnum.nextElement();
                int len = pathPieces.size();
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean pathObject = (GlobalObjectClientBean)pathPieces.elementAt(i);
                    if (pathObject == null) continue;
                    Long pathObjectId = pathObject.getId();
                    Enumeration enumUser = userEventAssistanceHash.keys();
                    while (enumUser.hasMoreElements()) {
                        Long userId = (Long)enumUser.nextElement();
                        Hashtable userEventId = (Hashtable)userEventAssistanceHash.get(userId);
                        if (!userEventId.containsKey(pathObjectId)) continue;
                        eau.setBitHash((Integer)userEventId.get(pathObjectId));
                    }
                }
            }
            EventAssistanceBean eab = new EventAssistanceBean();
            eab.setId(gocb.getId());
            eab.setType(action);
            eab.setClassName(gocb.getClassName());
            eau.printBitHash();
            eau.insertBitHashToDB(eab, false);
        }
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                System.err.println("####### Connect #############");
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("EventAssistanceMessageMDB");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    private void init() throws Exception {
        if (userEventAssistanceHash == null) {
            System.err.println("in init");
            userEventAssistanceHash = new Hashtable();
            DirectoryUserObjectClientBean[] duocb = this.sessionController.getAllDirectoryUsers();
            if (duocb != null) {
                int len = duocb.length;
                for (int i = 0; i < len; ++i) {
                    AppUserProfileObjectClientBean[] appUp = duocb[i].getApplicationUserProfiles("EventAssistance");
                    Integer userSequence = new Integer(duocb[i].getUserSequence());
                    if (appUp == null) continue;
                    Hashtable userObjectIdHash = null;
                    if (userEventAssistanceHash.containsKey(duocb[i].getId())) {
                        userObjectIdHash = (Hashtable)userEventAssistanceHash.get(duocb[i].getId());
                    } else {
                        userObjectIdHash = new Hashtable();
                        userEventAssistanceHash.put(duocb[i].getId(), userObjectIdHash);
                    }
                    int len1 = appUp.length;
                    for (int j = 0; j < len1; ++j) {
                        try {
                            Long objId = new Long(appUp[j].getAppKeyWord());
                            if (userObjectIdHash.containsKey(objId)) continue;
                            System.err.println("into Hash " + objId + ", us = " + userSequence);
                            userObjectIdHash.put(objId, userSequence);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

