/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.commons.cache.CacheRemoveCallback;
import agorum.commons.cache.GenericCache;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.utils.AccessOrderHashEntry;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.BackendCacheInfo;
import agorum.roi.ejb.common.BackendHelper;
import agorum.roi.ejb.common.BackendInformationBean;
import agorum.roi.ejb.common.BackendLock;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ContentCacheCallBack;
import agorum.roi.ejb.common.ContentCacheHolder;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.ContentUtils;
import agorum.roi.ejb.common.DataBaseProperties;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.exception.ContentReadException;
import agorum.roi.exception.ContentWriteException;
import agorum.roi.exception.RoiException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class ContentEJB
implements SessionBean {
    private static final long serialVersionUID = 1L;
    protected SessionContext context = null;
    private int maxInMemory = 20;
    private int timeToLive = 5000;

    public ContentEJB() {
        DataBaseProperties prop = new DataBaseProperties();
        this.maxInMemory = prop.getContentTransferMaxInMemory();
        this.timeToLive = prop.getContentTransferTimeToLiveInMemory() * 1000;
    }

    public void ejbCreate() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sCtx) {
        this.context = sCtx;
    }

    public void moveContent(SessionController sessionController, ContentInterface obj, BackendInformationBean destBackend, long blockSize, ContentUtils cu) throws RemoteException, Exception {
        BackendLock.acquireLock(obj.getId() + "", false);
        if (obj.getContentSize(true) <= 0L) {
            return;
        }
        String tableName = obj.getTableName();
        BackendInformationBean srcBackend = this.getBackendInformation(sessionController, obj.getId(), tableName, cu);
        if (destBackend == null) {
            destBackend = new BackendInformationBean(true);
        }
        if (obj.supportsBackend() && (destBackend.storeInDb != srcBackend.storeInDb && srcBackend.backendConfiguration == null && destBackend.backendConfiguration != null || srcBackend.backendConfiguration != null && destBackend.backendConfiguration == null || srcBackend.backendConfiguration != null && destBackend.backendConfiguration != null && !srcBackend.backendConfiguration.equals(destBackend.backendConfiguration))) {
            int blockNumber = 0;
            while (true) {
                ContentTransferBean ctb = null;
                try {
                    ctb = this.getBuffer(sessionController, obj, srcBackend, blockNumber, blockSize);
                }
                catch (Exception e) {
                    throw new ContentReadException("could not read from storage", e);
                }
                if (ctb == null) break;
                try {
                    this.storeBuffer(obj, destBackend, blockNumber, blockSize, ctb);
                }
                catch (Exception e) {
                    throw new ContentWriteException("could not write to storage", e);
                }
                ++blockNumber;
            }
            this.clearContentInternal(sessionController, obj.getId(), tableName, obj, srcBackend);
        }
    }

    public void copyContent(SessionController sessionController, ContentInterface sourceObj, ContentInterface destObj, String sourceTable, String destinationTable, ContentUtils cu) throws Exception {
        this.copyOrMoveContent(sessionController, sourceObj, destObj, false, sourceTable, destinationTable, cu);
    }

    public void moveContent(SessionController sessionController, ContentInterface docObj, String sourceTable, String destinationTable, ContentUtils cu) throws Exception {
        this.copyOrMoveContent(sessionController, docObj, docObj, true, sourceTable, destinationTable, cu);
    }

    private void copyOrMoveContent(SessionController sessionController, ContentInterface sourceObj, ContentInterface destObj, boolean isMove, String sourceTable, String destinationTable, ContentUtils cou) throws Exception {
        BackendInformationBean backendDest;
        BackendLock.acquireLock(destObj.getId() + "", false);
        BackendInformationBean backendSource = this.getBackendInformation(sessionController, sourceObj.getId(), sourceTable, cou);
        BackendInformationBean previousBackendDest = backendDest = this.getBackendInformation(sessionController, destObj.getId(), destinationTable, null);
        if (backendDest.storeInDb && !backendSource.storeInDb) {
            backendDest = backendSource;
        }
        if (backendSource.storeInDb && backendDest.storeInDb) {
            this.log("copyOrMoveContent.source", sessionController, sourceObj.getId());
            this.log("copyOrMoveContent.dest", sessionController, destObj.getId());
            sessionController.reconnectIfNeeded();
            try (Connection conn = new ConnectionUtils().getConnection();){
                new DatabaseUtils().getDatabaseInterfaceImpl().contentEJBMoveOrCopyContent(conn, sourceObj.getId(), destObj.getId(), isMove, sourceTable, destinationTable);
                if (destObj.getBlockSize() != sourceObj.getBlockSize()) {
                    GlobalObjectClientBean destGO = (GlobalObjectClientBean)((Object)destObj);
                    SuperObjectClientBeanDefinition blockSizeDef = destGO.getNewDefinition(sessionController);
                    blockSizeDef.setSystemOption("FORCE_BLOCKSIZE_CHANGE", "true");
                    blockSizeDef.setAttribute(FileObjectClientBean.BLOCKSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(sourceObj.getBlockSize()));
                    destGO.update(blockSizeDef);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ExceptionUtils.handleException(e);
            }
        } else {
            boolean dedupPossible;
            if (sourceObj.getId().equals(destObj.getId())) {
                return;
            }
            boolean backendChange = backendDest != previousBackendDest;
            boolean bl = dedupPossible = backendSource.settingsId == backendDest.settingsId && backendSource.deDuplicate;
            if (backendChange || dedupPossible) {
                this.clearContentInternal(sessionController, destObj.getId(), destinationTable, destObj, previousBackendDest);
            }
            if (backendChange) {
                BackendHelper.backendInterface.inheritStorage((GlobalObjectClientBean)((Object)sourceObj), (GlobalObjectClientBean)((Object)destObj));
            }
            if (backendSource.settingsId == backendDest.settingsId && backendSource.deDuplicate) {
                BackendHelper.backendInterface.reUseContent(sessionController, backendSource, sourceObj.getId(), destObj.getId());
                destObj.setContentSize(sourceObj.getContentSize());
                new ContentUtils(sessionController, destObj).performContentTask(false);
            } else {
                ContentUtils cuIn = new ContentUtils(sessionController, (ContentInterface)((Object)sessionController.getGlobalObjectById(sourceObj.getId())));
                ContentUtils cuOut = new ContentUtils(sessionController, (ContentInterface)((Object)sessionController.getGlobalObjectById(destObj.getId())));
                try (InputStream is = cuIn.getContentStream();
                     OutputStream os = cuOut.getContentOutputStream();){
                    StringConverterUtils.pipe((InputStream)is, (OutputStream)os, (int)524288);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferContent(SessionController sessionController, ContentTransferBean ctb, Long id, long blockNumber, String tableName, int blockSize, ContentUtils cu) throws RemoteException, Exception {
        BackendLock.acquireLock(id + "", false);
        this.log("transferContent", sessionController, id);
        sessionController.reconnectIfNeeded();
        if (ctb.isCacheEnabled()) {
            GenericCache gc;
            GenericCache genericCache = gc = this.getCache(sessionController, id);
            synchronized (genericCache) {
                ContentCacheHolder ch = (ContentCacheHolder)gc.get((Object)("" + blockNumber));
                if (ch == null) {
                    ch = new ContentCacheHolder(sessionController, id, blockNumber, tableName, blockSize);
                    gc.put((Object)("" + blockNumber), (Object)ch);
                }
                ctb.setHasBeenModified(true);
                ch.storeTransferBean(ctb);
                this.invalidateCacheIfEmpty(gc);
            }
        } else {
            this.transferContentUpdateToDB(sessionController, ctb, id, blockNumber, tableName, cu);
        }
    }

    public void transferContentUpdate(SessionController sessionController, ContentTransferBean ctb, Long id, long blockNumber, String tableName, int blockSize, ContentUtils cu) throws RemoteException, Exception {
        this.transferContent(sessionController, ctb, id, blockNumber, tableName, blockSize, cu);
    }

    public void transferContentUpdateToDB(SessionController sessionController, ContentTransferBean ctb, Long id, long blockNumber, String tableName, ContentUtils cou) throws RemoteException, Exception {
        BackendLock.acquireLock(id + "", false);
        this.log("transferContentUpdateToDB", sessionController, id);
        sessionController.reconnectIfNeeded();
        BackendInformationBean backend = this.getBackendInformation(sessionController, id, tableName, cou);
        if (backend.storeInDb) {
            this.storeDbBuffer(tableName, blockNumber, id, ctb);
        } else {
            ContentInterface obj = (ContentInterface)((Object)sessionController.getGlobalObjectById(id));
            BackendHelper.backendInterface.transferContent(backend, blockNumber, obj.getBlockSize(), id, ctb);
        }
    }

    public void openTransfer(SessionController sessionController, Long id, String tableName, ContentInterface contentInterface, ContentUtils cou) throws RemoteException, Exception {
        this.log("openTransfer", sessionController, id);
        ContentUtils cu = new ContentUtils(sessionController, contentInterface);
        cu.clearContent(sessionController, id, tableName);
    }

    public void closeTransfer(SessionController sessionController, Long id, ContentUtils cu) throws RemoteException, Exception {
        this.log("closeTransfer", sessionController, id);
        this.clearCache(sessionController, id, cu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(SessionController sessionController, Long id, ContentUtils cu) throws RemoteException, Exception {
        GenericCache gc;
        GenericCache genericCache = gc = this.getCache(sessionController, id);
        synchronized (genericCache) {
            ArrayList<String> removerId;
            Enumeration enumer;
            gc.suspendCache();
            try {
                enumer = gc.getCacheEntries();
                removerId = new ArrayList<String>();
                while (enumer.hasMoreElements()) {
                    AccessOrderHashEntry entry = (AccessOrderHashEntry)enumer.nextElement();
                    ContentCacheHolder cacheHolder = (ContentCacheHolder)entry.getStoredObject();
                    removerId.add((String)entry.getKey());
                    if (cacheHolder.getHadWrites()) {
                        this.transferContentUpdateToDB(sessionController, cacheHolder.buildTransferBean(true), id, cacheHolder.getBlockNumber(), cacheHolder.getTableName(), cu);
                    }
                    cacheHolder.invalidate();
                }
                int len = removerId.size();
                for (int i = 0; i < len; ++i) {
                    gc.remove((Object)((String)removerId.get(i)).toString());
                }
            }
            catch (Throwable throwable) {
                Enumeration enumer2 = gc.getCacheEntries();
                ArrayList<String> removerId2 = new ArrayList<String>();
                while (enumer2.hasMoreElements()) {
                    AccessOrderHashEntry entry = (AccessOrderHashEntry)enumer2.nextElement();
                    ContentCacheHolder cacheHolder = (ContentCacheHolder)entry.getStoredObject();
                    removerId2.add((String)entry.getKey());
                    cacheHolder.invalidate();
                }
                int len = removerId2.size();
                for (int i = 0; i < len; ++i) {
                    gc.remove((Object)((String)removerId2.get(i)).toString());
                }
                gc.invalidateCache();
                throw throwable;
            }
            enumer = gc.getCacheEntries();
            removerId = new ArrayList();
            while (enumer.hasMoreElements()) {
                AccessOrderHashEntry entry = (AccessOrderHashEntry)enumer.nextElement();
                ContentCacheHolder cacheHolder = (ContentCacheHolder)entry.getStoredObject();
                removerId.add((String)entry.getKey());
                cacheHolder.invalidate();
            }
            int len = removerId.size();
            for (int i = 0; i < len; ++i) {
                gc.remove((Object)((String)removerId.get(i)).toString());
            }
            gc.invalidateCache();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentTransferBean getDbBuffer(String tableName, long blockNumber, long id) throws RemoteException, RoiException {
        try (Connection conn = new ConnectionUtils().getConnection();
             PreparedStatement pstmt = conn.prepareStatement("select CONTENT from " + tableName + " where ID = ? and DOCID = ?");){
            pstmt.setLong(1, blockNumber);
            pstmt.setLong(2, id);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                byte[] buffer = new DatabaseUtils().getDatabaseInterfaceImpl().getBlob(rs);
                int len = buffer.length;
                ContentTransferBean ctb = new ContentTransferBean(buffer, len);
                ctb.setIsFilled(true);
                ContentTransferBean contentTransferBean = ctb;
                return contentTransferBean;
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return null;
    }

    private ContentTransferBean getBuffer(SessionController sessionController, ContentInterface obj, BackendInformationBean backend, int blockNumber, long blockSize) throws Exception {
        ContentTransferBean ctb = null;
        if ((long)blockNumber * blockSize < obj.getContentSize()) {
            ctb = backend.storeInDb ? this.getDbBuffer(obj.getTableName(), blockNumber, obj.getId()) : BackendHelper.backendInterface.getContent(sessionController, backend, blockNumber, obj.getBlockSize(), obj.getId());
        }
        if (ctb != null) {
            ctb.setPreviousBufferLength(ctb.getBufferLength());
        }
        return ctb;
    }

    private void storeDbBuffer(String tableName, long blockNumber, long id, ContentTransferBean ctb) throws RemoteException, RoiException {
        try (Connection conn = new ConnectionUtils().getConnection();){
            boolean update = false;
            try (PreparedStatement pstmt = conn.prepareStatement("select ID from " + tableName + " where ID = ? and DOCID = ?");){
                pstmt.setLong(1, blockNumber);
                pstmt.setLong(2, id);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        update = true;
                    }
                }
            }
            new DatabaseUtils().getDatabaseInterfaceImpl().contentEJBTransferContentUpdate(conn, tableName, update, blockNumber, id, ctb);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ExceptionUtils.handleException(e);
        }
    }

    private void storeBuffer(ContentInterface obj, BackendInformationBean backend, int blockNumber, long blockSize, ContentTransferBean ctb) throws Exception {
        if (backend.storeInDb) {
            this.storeDbBuffer(obj.getTableName(), blockNumber, obj.getId(), ctb);
        } else {
            BackendHelper.backendInterface.transferContent(backend, blockNumber, obj.getBlockSize(), obj.getId(), ctb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTransferBean getBuffer(SessionController sessionController, Long id, long blockNumber, String tableName, long contentSize, long blockSize, boolean bufferd, ContentUtils cou) throws RemoteException, Exception {
        GenericCache gc;
        this.log("getBuffer", sessionController, id);
        sessionController.reconnectIfNeeded();
        ContentTransferBean ctb = null;
        GenericCache genericCache = gc = this.getCache(sessionController, id);
        synchronized (genericCache) {
            ContentCacheHolder ch;
            if (bufferd && (ch = (ContentCacheHolder)gc.get((Object)("" + blockNumber))) != null) {
                return ch.buildTransferBean(false);
            }
            if (blockNumber * blockSize < contentSize) {
                BackendInformationBean backend = this.getBackendInformation(sessionController, id, tableName, cou);
                if (backend.storeInDb) {
                    ctb = this.getDbBuffer(tableName, blockNumber, id);
                } else {
                    byte[] buffer;
                    ContentTransferBean ctbTmp = BackendHelper.backendInterface.getContent(sessionController, backend, blockNumber, blockSize, id);
                    if (ctbTmp != null && (buffer = ctbTmp.getBuffer()) != null) {
                        int len = buffer.length;
                        ctb = new ContentTransferBean(buffer, len);
                        ctb.setIsFilled(true);
                    }
                }
                if (ctb == null) {
                    long maxFullBlock = contentSize / blockSize - 1L;
                    long remainder = contentSize % blockSize;
                    if (blockNumber <= maxFullBlock) {
                        byte[] buffer = new byte[(int)blockSize];
                        ctb = new ContentTransferBean(buffer, (int)blockSize);
                        ctb.setIsEmptyBlock(true);
                        ctb.setIsFilled(true);
                    } else if (remainder > 0L) {
                        byte[] buffer = new byte[(int)remainder];
                        ctb = new ContentTransferBean(buffer, (int)remainder);
                        ctb.setIsEmptyBlock(true);
                        ctb.setIsFilled(true);
                    } else {
                        ctb = new ContentTransferBean(null, 0);
                        ctb.setIsFilled(false);
                    }
                }
                ctb.setCacheEnabled(bufferd);
                if (bufferd) {
                    ContentCacheHolder ch2 = new ContentCacheHolder(sessionController, id, blockNumber, tableName, (int)blockSize);
                    ch2.storeTransferBean(ctb);
                    gc.put((Object)("" + blockNumber), (Object)ch2);
                }
            }
            this.invalidateCacheIfEmpty(gc);
        }
        return ctb;
    }

    public void setContentSize(SessionController sessionController, ContentInterface contentInterface, long value, ContentUtils cu) throws RemoteException, Exception {
        contentInterface.setContentSize(value);
    }

    public void closeForRead(SessionController sessionController, ContentInterface contentInterface, ContentUtils cu) throws RemoteException, Exception {
        Long id = contentInterface.getId();
        this.log("closeForRead", sessionController, id);
        this.closeTransfer(sessionController, id, cu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void truncate(SessionController sessionController, Long docId, String tableName, long newFileLength, long blockSize, ContentUtils cou) throws RemoteException, Exception {
        this.log("truncate", sessionController, docId);
        var10_8 = gc = this.getCache(sessionController, docId);
        synchronized (var10_8) {
            gc.suspendCache();
            blockCount = newFileLength / blockSize + 1L;
            lastBlockSize = newFileLength - (blockCount - 1L) * blockSize;
            sessionController.reconnectIfNeeded();
            backend = this.getBackendInformation(sessionController, docId, tableName, cou);
            if (backend.storeInDb) {
                conn = null;
                pstmt = null;
                rs = null;
                cu = null;
                try {
                    du = new DatabaseUtils();
                    dbi = du.getDatabaseInterfaceImpl();
                    cu = new ConnectionUtils(sessionController);
                    conn = cu.getConnection();
                    ch = (ContentCacheHolder)gc.get((Object)("" + (blockCount - 1L)));
                    buffer = null;
                    if (ch == null) {
                        ch = new ContentCacheHolder(sessionController, docId, blockCount - 1L, tableName, (int)blockSize);
                        pstmt = conn.prepareStatement("select CONTENT from " + tableName + " where ID = ? and DOCID = ?");
                        pstmt.setLong(1, blockCount - 1L);
                        pstmt.setLong(2, docId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            buffer = dbi.getBlob(rs);
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        if (buffer != null) {
                            ctb = new ContentTransferBean(buffer, buffer.length);
                            ctb.setFirstBytePos(0L);
                            ctb.setModifiedLength(buffer.length);
                            ctb.setHasBeenModified(true);
                            ctb.setIsFilled(true);
                            ctb.setIsEmptyBlock(false);
                            ch.storeTransferBean(ctb);
                        }
                    } else {
                        buffer = ch.getBuffer();
                    }
                    if (buffer == null) ** GOTO lbl101
                    pstmt = conn.prepareStatement("delete from " + tableName + " where docid=? and id >= ?");
                    pstmt.setLong(1, docId);
                    pstmt.setLong(2, blockCount - 1L);
                    pstmt.execute();
                    pstmt.close();
                    pstmt = null;
                    ctb = new ContentTransferBean(buffer, (int)lastBlockSize);
                    ctb.setHasBeenModified(true);
                    ch.storeTransferBean(ctb);
                    this.transferContentUpdateToDB(sessionController, ctb, docId, ch.getBlockNumber(), ch.getTableName(), cou);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    ExceptionUtils.handleException(e);
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    catch (Exception var20_23) {}
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (Exception var20_24) {}
                    try {
                        cu.closeConnection();
                    }
                    catch (Exception var20_25) {}
                }
            } else {
                ch = (ContentCacheHolder)gc.get((Object)("" + (blockCount - 1L)));
                buffer = null;
                if (ch == null) {
                    ch = new ContentCacheHolder(sessionController, docId, blockCount - 1L, tableName, (int)blockSize);
                    ctbTmp = BackendHelper.backendInterface.getContent(sessionController, backend, blockCount - 1L, blockSize, docId);
                    if (ctbTmp == null) {
                        ctbTmp = this.getDbBuffer(tableName, blockCount - 1L, docId);
                    }
                    if (ctbTmp != null && (buffer = ctbTmp.getBuffer()) != null) {
                        ctb = new ContentTransferBean(buffer, buffer.length);
                        ctb.setFirstBytePos(0L);
                        ctb.setModifiedLength(buffer.length);
                        ctb.setHasBeenModified(true);
                        ctb.setIsFilled(true);
                        ctb.setIsEmptyBlock(false);
                        ch.storeTransferBean(ctb);
                    }
                } else {
                    buffer = ch.getBuffer();
                }
                if (buffer != null) {
                    BackendHelper.backendInterface.deleteContentTail(sessionController, backend, blockCount - 1L, docId);
                    ctb = new ContentTransferBean(buffer, (int)lastBlockSize);
                    ctb.setHasBeenModified(true);
                    ch.storeTransferBean(ctb);
                    this.transferContentUpdateToDB(sessionController, ctb, docId, ch.getBlockNumber(), ch.getTableName(), cou);
                }
            }
lbl101:
            // 6 sources

            enumer = gc.getCacheEntries();
            removerId = new ArrayList<String>();
            while (enumer.hasMoreElements()) {
                entry = (AccessOrderHashEntry)enumer.nextElement();
                cacheHolder = (ContentCacheHolder)entry.getStoredObject();
                if (cacheHolder.getBlockNumber() < blockCount - 1L) continue;
                removerId.add((String)entry.getKey());
                cacheHolder.invalidate();
            }
            len = removerId.size();
            for (i = 0; i < len; ++i) {
                gc.remove((Object)((String)removerId.get(i)).toString());
            }
            gc.resumeCache();
        }
    }

    public void clearContent(SessionController sessionController, Long id, String tableName, ContentInterface contentInterface, ContentUtils cu) throws RemoteException, Exception {
        this.log("clearContent", sessionController, id);
        if (id == null) {
            return;
        }
        BackendInformationBean backend = this.getBackendInformation(sessionController, id, tableName, cu);
        this.clearContentInternal(sessionController, id, tableName, contentInterface, backend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearContentInternal(SessionController sessionController, Long id, String tableName, ContentInterface contentInterface, BackendInformationBean backend) throws RemoteException, Exception {
        if (backend.storeInDb) {
            Connection conn = null;
            Statement pstmt = null;
            ConnectionUtils cu = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                long maxId = -1L;
                ResultSet rs = null;
                try {
                    pstmt = conn.prepareStatement("select max(ID), count(*) from " + tableName + " where DOCID=?");
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs != null && rs.next() && rs.getLong(2) > 0L) {
                        maxId = rs.getLong(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    catch (Exception e) {}
                }
                if (maxId < 0L) return;
                for (long currId = 0L; currId <= maxId; ++currId) {
                    pstmt = conn.prepareStatement("delete from " + tableName + " where DOCID=? and ID=?");
                    pstmt.setLong(1, id);
                    pstmt.setLong(2, currId);
                    pstmt.execute();
                    pstmt.close();
                }
                return;
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
                return;
            }
            finally {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        BackendHelper.backendInterface.deleteContentAll(sessionController, backend, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericCache getCache(SessionController sessionController, Long id) {
        GenericCache gc;
        GenericCache genericCache = gc = GenericCache.getInstance((Object)("ContentCache_" + sessionController.getSessionId() + "_" + id), (int)1000, (int)3000, (int)(this.timeToLive * 10));
        synchronized (genericCache) {
            if (!(gc.getCacheRemoveCallback() instanceof ContentCacheCallBack)) {
                gc.setCacheRemoveCallback((CacheRemoveCallback)new ContentCacheCallBack(sessionController, id));
            }
            try {
                this.checkSwapping(sessionController, gc, id);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return gc;
    }

    private void invalidateCacheIfEmpty(GenericCache gc) {
        if (gc.size() == 0) {
            gc.invalidateCache();
        }
    }

    private void checkSwapping(SessionController sessionController, GenericCache gc, Long id) throws Exception {
        if (gc.size() > this.maxInMemory) {
            int maxRun = gc.size() - this.maxInMemory;
            Enumeration enumer = gc.getCacheEntries();
            ArrayList<String> removerId = new ArrayList<String>();
            while (enumer.hasMoreElements()) {
                AccessOrderHashEntry entry = (AccessOrderHashEntry)enumer.nextElement();
                ContentCacheHolder cacheHolder = (ContentCacheHolder)entry.getStoredObject();
                ContentCacheCallBack ccb = new ContentCacheCallBack(sessionController, cacheHolder.getId());
                ccb.removeFromCacheCallback(entry.getKey(), entry.getStoredObject(), true, true);
                removerId.add((String)entry.getKey());
                if (maxRun <= 0) break;
                --maxRun;
            }
            int len = removerId.size();
            for (int i = 0; i < len; ++i) {
                gc.remove((Object)((String)removerId.get(i)).toString());
            }
        }
    }

    private void cleanUpBuffer(int start, byte[] internalBuffer) throws IOException {
        int i;
        int deleteSize = 1024;
        byte[] clearBuffer = new byte[deleteSize];
        for (int i2 = 0; i2 < deleteSize; ++i2) {
            clearBuffer[i2] = 0;
        }
        int len = internalBuffer.length;
        int n = i = start >= 0 ? start : 0;
        while (i < len) {
            int myLen = deleteSize;
            if (i > len - deleteSize) {
                myLen = len - i;
            }
            System.arraycopy(internalBuffer, i, clearBuffer, 0, myLen);
            i += deleteSize;
        }
    }

    private void log(String func, SessionController sessionController, Long id) {
    }

    private GenericCache getBackendInformationCache() {
        return GenericCache.getInstance((Object)("ContentUtilsBackendInformationCache_" + BackendCacheInfo.cacheCounter), (int)10000, (int)10000, (int)60000);
    }

    private BackendInformationBean getBackendInformation(SessionController sessionController, Long id, String tableName, ContentUtils cou) throws Exception {
        BackendInformationBean bib;
        if (cou != null && (bib = (BackendInformationBean)this.getBackendInformationCache().get((Object)(cou.getContentUtilsId() + "_" + id))) != null) {
            return bib;
        }
        bib = new BackendInformationBean(true);
        if (id != null && BackendHelper.backendInterface != null) {
            try (Connection conn = new ConnectionUtils().getConnection();
                 PreparedStatement pstmt = conn.prepareStatement("select count(*) from " + tableName + " where DOCID=?");){
                pstmt.setLong(1, id);
                try (ResultSet rs = pstmt.executeQuery();){
                    GlobalObjectClientBean gocb;
                    BackendInformationBean bibBackend;
                    if (!(rs.next() && rs.getLong(1) > 0L || (bibBackend = BackendHelper.backendInterface.getBackendInformation(gocb = sessionController.getGlobalObjectById(id))) == null)) {
                        bib = bibBackend;
                    }
                }
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        }
        if (cou != null) {
            this.getBackendInformationCache().put((Object)(cou.getContentUtilsId() + "_" + id), (Object)bib);
        }
        return bib;
    }
}

