/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.cron;

import agorum.commons.string.StringUtils;
import agorum.commons.xml.XMLUtils;
import agorum.roi.common.beans.UserImportBean;
import agorum.roi.cron.RoiCronTaskInterface;
import agorum.roi.ejb.agents.mail.SendMail;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManager;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.exception.RoiException;
import agorum.roi.sessionfacade.beans.DirectoryUserObjectSessionFacade;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserImportCronTaskFactory
implements RoiCronTaskInterface {
    public static Hashtable errorFiles = new Hashtable();

    public void runCronJob(SessionController sessionController, String settingName, Hashtable parameters) throws Exception {
        this.doLog("begin importing users...");
        String mailErrorsTo = "roi@agorumcore.com";
        String userPath = "UserImport";
        String queuePath = "/opt/agorum/agorumcore/jboss/server/default/userqueue";
        if (parameters.containsKey("QueuePath")) {
            queuePath = (String)parameters.get("QueuePath");
        }
        if (parameters.containsKey("MailErrorsTo")) {
            mailErrorsTo = (String)parameters.get("MailErrorsTo");
        }
        if (parameters.containsKey("UserPath")) {
            userPath = (String)parameters.get("UserPath");
        }
        this.importUsers(sessionController, queuePath, userPath, mailErrorsTo);
    }

    public void importUsers(SessionController sessionController, String queuePath, String userPath, String mailErrorsTo) throws Exception {
        File[] files;
        File qDir;
        StringUtils su = new StringUtils();
        String serverHome = System.getProperty("jboss.server.home.dir");
        if (new File(queuePath = su.strReplace(queuePath, "${ServerHome}", serverHome)).exists() && (qDir = new File(queuePath)).exists() && (files = qDir.listFiles()) != null) {
            Arrays.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return new Long(((File)o1).lastModified()).compareTo(new Long(((File)o2).lastModified()));
                }
            });
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                if (!files[i].isFile() || !files[i].getName().toLowerCase().endsWith(".xml") || files[i].lastModified() + 2000L >= System.currentTimeMillis()) continue;
                System.out.println(files[i].getAbsolutePath());
                try {
                    ArrayList uibs = this.parseUserXML(files[i]);
                    UserImportBean uibOld = (UserImportBean)uibs.get(0);
                    UserImportBean uibNew = (UserImportBean)uibs.get(1);
                    System.out.println("Parsed");
                    this.handleUser(sessionController, uibOld, uibNew, files[i], userPath);
                    errorFiles.clear();
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (!errorFiles.containsKey(files[i].getAbsolutePath())) {
                            errorFiles.put(files[i].getAbsolutePath(), "");
                            SendMail sm = new SendMail(sessionController);
                            String defaultAddress = sessionController.getLoginUser().getEmailUserProfiles()[0].getEmailAddress();
                            mailErrorsTo = su.strReplace(mailErrorsTo, "${Default}", defaultAddress);
                            String[] toAddress = mailErrorsTo.split(";");
                            String msg = "The user import of the directory \"" + queuePath + "\" produced an error with the file: \"" + files[i].getName() + "\"\r\n";
                            msg = msg + "The user import has been stopped, until the error is fixed\r\n\r\n";
                            msg = msg + "The following exception has been reported: \r\n\r\n";
                            msg = msg + su.exceptionToString(e);
                            sm.sendSimpleMail(toAddress, null, null, "agorum core: error in UserImport", msg);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace(System.err);
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUser(SessionController sessionController, UserImportBean uibOld, UserImportBean uibNew, File f, String userPath) throws Exception {
        RoiTransactionHandler rth = new RoiTransactionHandler();
        rth.begin();
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        FolderObjectClientBean destFolder = rfs.createFullpath("/agorum/roi/Administration/User/" + userPath);
        if (uibOld != null && uibOld.getUid() != null && (uibOld.getUid().equalsIgnoreCase("guest") || uibOld.getUid().equalsIgnoreCase("roi")) || uibNew != null && uibNew.getUid() != null && (uibNew.getUid().equalsIgnoreCase("guest") || uibNew.getUid().equalsIgnoreCase("roi"))) {
            f.delete();
            rth.end();
            rth = null;
            return;
        }
        try {
            if (uibOld.getMode() != null) {
                if (uibOld.getMode().equalsIgnoreCase("delete")) {
                    this.doLog("UserImport: deleting user: " + uibOld.getUid());
                    DirectoryUserObjectClientBean user = sessionController.getUserByName(uibOld.getUid());
                    if (user != null) {
                        String newUserName = user.getName() + "_deleted_" + user.getId();
                        UserManagerBean umb = new UserManagerBean();
                        umb.setUserName(newUserName);
                        DirectoryUserObjectSessionFacade userSessionFacade = new DirectoryUserObjectSessionFacade(sessionController);
                        userSessionFacade.setWithTransaction(true);
                        userSessionFacade.setGlobalObject(user.getId());
                        String userMailAddress = user.getEmailUserProfiles()[0].getEmailAddress();
                        String[] emailAddresses = new String[]{"deleted_" + user.getId() + "_" + userMailAddress};
                        userSessionFacade.setEmailAddresses(emailAddresses);
                        userSessionFacade.setUserName(newUserName);
                        user = (DirectoryUserObjectClientBean)userSessionFacade.update();
                        UserManager um = new UserManager(sessionController);
                        um.update(umb, user);
                        user.lock(1);
                        this.doLog("UserImport: user deleted (locked): " + uibOld.getUid());
                    }
                } else if (uibOld.getMode().equalsIgnoreCase("create") || uibOld.getMode().equalsIgnoreCase("update")) {
                    UserManager um;
                    UserManagerBean umb = new UserManagerBean();
                    DirectoryUserObjectSessionFacade userSessionFacade = new DirectoryUserObjectSessionFacade(sessionController);
                    userSessionFacade.setWithTransaction(true);
                    umb.setUserName(uibNew.getUid());
                    userSessionFacade.setUserName(uibNew.getUid());
                    boolean doUpdate = false;
                    DirectoryUserObjectClientBean user = null;
                    if (uibOld.getMode().equalsIgnoreCase("update")) {
                        this.doLog("UserImport: create or update user: old=" + uibOld.getUid() + ", new=" + uibNew.getUid());
                        if (uibOld.getUid() != null && uibNew.getUid() != null && !uibOld.getUid().equalsIgnoreCase(uibNew.getUid()) && (user = sessionController.getUserByName(uibOld.getUid())) != null) {
                            userSessionFacade.setGlobalObject(user.getId());
                            doUpdate = true;
                        }
                    }
                    if (user == null && (user = sessionController.getUserByName(uibNew.getUid())) != null) {
                        userSessionFacade.setGlobalObject(user.getId());
                        doUpdate = true;
                    }
                    if (doUpdate) {
                        this.doLog("UserImport: user is already in agorum core, so update it");
                    }
                    userSessionFacade.setPassWord("agorum");
                    String[] emailAddresses = null;
                    if (uibNew.getMailPrimaryAddress() != null) {
                        this.doLog("UserImport: check mail address: " + uibNew.getMailPrimaryAddress());
                        emailAddresses = new String[]{uibNew.getMailPrimaryAddress()};
                    } else {
                        RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(sessionController);
                        String defaultEmailDomain = rpmd.getEmailDomain();
                        emailAddresses = new String[]{uibNew.getUid() + "@" + defaultEmailDomain};
                    }
                    DirectoryUserObjectSessionFacade checkSF = new DirectoryUserObjectSessionFacade(sessionController);
                    checkSF.setUserName(uibNew.getUid());
                    checkSF.setDestinationFolder(destFolder.getId());
                    checkSF.setEmailAddresses(emailAddresses);
                    try {
                        checkSF.check(user);
                    }
                    catch (RoiException e) {
                        String errorKey = e.getErrorKey();
                        if (errorKey.equals("agorum.roi.remote.exception.MailAddressAlreadyExists")) {
                            emailAddresses = new String[]{System.currentTimeMillis() + "_" + emailAddresses[0]};
                            this.doLog("UserImport: mail address already in use: " + emailAddresses[0]);
                        }
                        throw new Exception("something wrong in check", e);
                    }
                    userSessionFacade.setEmailAddresses(emailAddresses);
                    userSessionFacade.setDescription(uibNew.getDescription());
                    userSessionFacade.setFamilyName(uibNew.getSurName());
                    userSessionFacade.setGivenName(uibNew.getGivenName());
                    if (!doUpdate) {
                        this.doLog("UserImport: it is an create");
                        userSessionFacade.setDestinationFolder(destFolder.getId());
                        userSessionFacade.setLanguage("de");
                        userSessionFacade.setCredentialManager("roi");
                        userSessionFacade.setDefaultRoleName(null);
                        userSessionFacade.setAssociatedRoleName(null);
                        userSessionFacade.setIsRole("false");
                    }
                    if (doUpdate) {
                        user = (DirectoryUserObjectClientBean)userSessionFacade.update();
                        um = new UserManager(sessionController);
                        umb.setSambaLMPassword(uibNew.getSambaLMPassword());
                        umb.setSambaNTPassword(uibNew.getSambaNTPassword());
                        um.update(umb, user);
                        if (uibNew.getAgorumcoreAccount() == null || uibNew.getAgorumcoreAccount().equals("0")) {
                            if (!user.isLocked()) {
                                this.doLog("UserImport: user has no agorumcoreAccount, so lock it");
                                user.lock(1);
                            }
                        } else if (user.isLocked()) {
                            this.doLog("UserImport: user has an agorumcoreAccount, so unlock it");
                            user.unlock();
                        }
                    } else if (uibNew.getAgorumcoreAccount() != null && uibNew.getAgorumcoreAccount().equals("1")) {
                        this.doLog("UserImport: creating new user");
                        user = (DirectoryUserObjectClientBean)userSessionFacade.create();
                        um = new UserManager(sessionController);
                        umb.setSambaLMPassword(uibNew.getSambaLMPassword());
                        umb.setSambaNTPassword(uibNew.getSambaNTPassword());
                        um.update(umb, user);
                    } else {
                        this.doLog("UserImport: do not create user, has no agorumcoreAccount");
                    }
                }
            }
            this.doLog("UserImport: user handling finished\n\n\n");
            f.delete();
            rth.end();
            rth = null;
        }
        finally {
            if (rth != null) {
                rth.abort();
            }
        }
    }

    private void doLog(String s) {
        System.out.println(s);
    }

    private ArrayList parseUserXML(File f) throws Exception {
        ArrayList<UserImportBean> al = new ArrayList<UserImportBean>();
        UserImportBean uibOld = new UserImportBean();
        UserImportBean uibNew = new UserImportBean();
        String mode = null;
        XMLUtils xmlUtils = new XMLUtils();
        FileInputStream is = new FileInputStream(f);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        Document xmlDoc = xmlUtils.parseXML(isr);
        NodeList nl = xmlDoc.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node subNode = nl.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase("User")) continue;
            NodeList nl1 = subNode.getChildNodes();
            int len1 = nl1.getLength();
            for (int i1 = 0; i1 < len1; ++i1) {
                Node subNode1 = nl1.item(i1);
                if (subNode1.getNodeName().equalsIgnoreCase("Mode")) {
                    mode = xmlUtils.getValueFromNode(subNode1);
                    continue;
                }
                if (subNode1.getNodeName().equalsIgnoreCase("Old")) {
                    this.parseUserEntry(subNode1, uibOld);
                    continue;
                }
                if (!subNode1.getNodeName().equalsIgnoreCase("New")) continue;
                this.parseUserEntry(subNode1, uibNew);
            }
        }
        uibOld.setMode(mode);
        uibNew.setMode(mode);
        al.add(uibOld);
        al.add(uibNew);
        return al;
    }

    private void parseUserEntry(Node node, UserImportBean uib) throws Exception {
        XMLUtils xmlUtils = new XMLUtils();
        NodeList nl = node.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            String s;
            Node subNode = nl.item(i);
            if (subNode.getNodeName().equalsIgnoreCase("AgorumcoreAccount")) {
                uib.setAgorumcoreAccount(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("Uid")) {
                uib.setUid(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("SambaLMPassword")) {
                uib.setSambaLMPassword(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("UidNumber")) {
                uib.setUidNumber(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("Cn")) {
                uib.setCn(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("SambaNTPassword")) {
                uib.setSambaNTPassword(xmlUtils.getValueFromNode(subNode));
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("GivenName")) {
                s = xmlUtils.getValueFromNode(subNode);
                if (s == null) {
                    s = "";
                }
                uib.setGivenName(s);
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("SurName")) {
                s = xmlUtils.getValueFromNode(subNode);
                if (s == null) {
                    s = "";
                }
                uib.setSurName(s);
                continue;
            }
            if (subNode.getNodeName().equalsIgnoreCase("Description")) {
                s = xmlUtils.getValueFromNode(subNode);
                if (s == null) {
                    s = "";
                }
                uib.setDescription(s);
                continue;
            }
            if (!subNode.getNodeName().equalsIgnoreCase("MailPrimaryAddress")) continue;
            uib.setMailPrimaryAddress(xmlUtils.getValueFromNode(subNode));
        }
    }
}

