/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.utils.TempFile;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    @Deprecated
    public static File compress(List<GlobalObjectClientBean> objects, String fileName) throws Exception {
        return ZipUtils.compress(objects);
    }

    public static File compress(List<GlobalObjectClientBean> objects) throws Exception {
        File zipFile = TempFile.createTempFile((long)3600000L);
        try (FileOutputStream outputStream = new FileOutputStream(zipFile);){
            ZipUtils.compress(objects, outputStream);
        }
        return zipFile;
    }

    public static void compress(List<GlobalObjectClientBean> objects, OutputStream outputStream) throws Exception {
        ZipUtils.compress(objects, outputStream, false, null);
    }

    public static void compress(List<GlobalObjectClientBean> objects, OutputStream outputStream, boolean includeEmptyDirectories, String encoding) throws Exception {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try (ZipOutputStream zipOut = new ZipOutputStream(outputStream, Charset.forName(encoding));){
            for (GlobalObjectClientBean object : objects) {
                if (object instanceof ContentInterface) {
                    ZipUtils.compressContentInterfaceObject((ContentInterface)((Object)object), object.getName(), zipOut);
                    continue;
                }
                if (!(object instanceof FolderObjectClientBean)) continue;
                ZipUtils.addDir((FolderObjectClientBean)object, object.getName(), zipOut, includeEmptyDirectories);
            }
        }
    }

    private static void addDir(FolderObjectClientBean folder, String path, ZipOutputStream zipOut, boolean includeEmptyDirectories) throws Exception {
        GlobalObjectClientBean[] items = folder.getItems();
        if (items != null && items.length != 0) {
            for (GlobalObjectClientBean object : items) {
                if (object instanceof ContentInterface) {
                    ZipUtils.compressContentInterfaceObject((ContentInterface)((Object)object), path + "/" + object.getName(), zipOut);
                    continue;
                }
                if (!(object instanceof FolderObjectClientBean)) continue;
                ZipUtils.addDir((FolderObjectClientBean)object, path + "/" + object.getName(), zipOut, includeEmptyDirectories);
            }
        } else if (includeEmptyDirectories) {
            ZipEntry entry = new ZipEntry(path + "/");
            zipOut.putNextEntry(entry);
        }
    }

    private static void compressContentInterfaceObject(ContentInterface ci, String entryName, ZipOutputStream zipOut) throws IOException, Exception {
        byte[] buffer = new byte[1024];
        try (InputStream is = ci.getContentStream();){
            int length;
            zipOut.putNextEntry(new ZipEntry(entryName));
            while ((length = is.read(buffer)) > 0) {
                zipOut.write(buffer, 0, length);
            }
            zipOut.closeEntry();
        }
    }
}

