/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.logging.TimeSpanLogger;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.roi.common.utils.Chain;
import agorum.roi.ejb.common.Transaction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Broadcast {
    private static final long TIMESPAN_WARN_MILLIS = 1000L;
    private static final CoreStatistic stat = CoreStatistic.getInstance();
    private static final Map<String, Set<Subscriber>> subscribers = new HashMap<String, Set<Subscriber>>();
    private static final Chain chain = new Chain();
    public static String VERSION = "cdev-roi-11.7.2.3-1804";

    public static Subscriber sub(String channel, Subscriber subscriber) {
        chain.sync(() -> subscribers.computeIfAbsent(channel, k -> new HashSet()).add(subscriber));
        return subscriber;
    }

    public static void unsub(String channel, Subscriber subscriber) {
        chain.sync(() -> {
            Set<Subscriber> set = subscribers.get(channel);
            if (set == null || !set.remove(subscriber)) {
                stat.debug("Trying to unsubscribe without being subscribed: " + channel);
                return;
            }
            if (set.isEmpty()) {
                subscribers.remove(channel);
            }
        });
    }

    public static void pub(String channel, Object data) {
        try {
            Transaction.finishedCommit(() -> chain.sync(() -> {
                Set<Subscriber> set = subscribers.get(channel);
                if (set == null) {
                    return;
                }
                for (Subscriber subscriber : set) {
                    TimeSpanLogger.Auto tsl = new TimeSpanLogger((Statistic)stat).name("Broadcast").detail("Channel", channel).logAs("DEBUG").alertAs("WARNING").alertAt(1000L).measurement().auto();
                    Throwable throwable = null;
                    try {
                        subscriber.consume(channel, data);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tsl == null) continue;
                        if (throwable != null) {
                            try {
                                tsl.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tsl.close();
                    }
                }
            }));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void push(String channel, Object data) {
        try {
            chain.sync(() -> {
                Set<Subscriber> set = subscribers.get(channel);
                if (set == null) {
                    return;
                }
                for (Subscriber subscriber : set) {
                    subscriber.consume(channel, data);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface Subscriber {
        public void consume(String var1, Object var2);
    }
}

