/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.commons.cron.SystemTimer;
import agorum.roi.common.utils.Broadcast;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ObjectUpdateCollector {
    private static final String RTH_CHANGES_KEY = ObjectUpdateCollector.class.getName();
    private static Map<String, List<String[]>> throttled = new HashMap<String, List<String[]>>();

    public static void changed(String objectId, SuperObjectClientBeanDefinition def) throws Exception {
        for (Object attributes : def.getAttributes().values()) {
            if (attributes == null) continue;
            for (Object keyObj : ((Hashtable)attributes).keySet()) {
                String key = (String)keyObj;
                if (key == null || Objects.equals(def.getAttributeBeforUpdate(key), def.getAttribute(key))) continue;
                ObjectUpdateCollector.changed(objectId, key);
            }
        }
    }

    public static void changed(String objectId, String changeKey) throws Exception {
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth == null) {
            ObjectUpdateCollector.pub(objectId, new String[]{changeKey.toLowerCase()});
        } else {
            HashMap<String, Set> changes = (HashMap<String, Set>)rth.get(RTH_CHANGES_KEY);
            if (changes == null) {
                changes = new HashMap<String, Set>();
                rth.put(RTH_CHANGES_KEY, changes);
                HashMap<String, Set> myChanges = changes;
                Transaction.afterCommit(() -> {
                    for (Map.Entry entry : myChanges.entrySet()) {
                        ObjectUpdateCollector.pub((String)entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]));
                    }
                });
            }
            changes.computeIfAbsent(objectId, k -> new HashSet()).add(changeKey.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pub(String id, String[] keys) {
        Map<String, List<String[]>> map = throttled;
        synchronized (map) {
            List<String[]> deferred = throttled.get(id);
            if (deferred != null) {
                deferred.add(keys);
                return;
            }
            throttled.put(id, new ArrayList());
        }
        Broadcast.pub("object-updated-" + id, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDeferred() {
        Map<String, List<String[]>> myThrottled = throttled;
        throttled = new HashMap<String, List<String[]>>();
        Map<String, List<String[]>> map = myThrottled;
        synchronized (map) {
            for (Map.Entry<String, List<String[]>> entry : myThrottled.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                HashSet<String> allKeys = new HashSet<String>();
                for (String[] keys : entry.getValue()) {
                    allKeys.addAll(Arrays.asList(keys));
                }
                Broadcast.pub("object-updated-" + entry.getKey(), allKeys.toArray(new String[0]));
            }
        }
    }

    static {
        SystemTimer.ofPeriod((long)5000L).name(ObjectUpdateCollector.class.getName() + "_throttled_updates").call(ObjectUpdateCollector::processDeferred);
    }
}

