/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import java.util.HashSet;

public class FolderItemsChangedDeleted {
    private static final String TRANS_CACHE_KEY = "FolderItemsChangedDeletedAfterCommit";

    private static GenericCache getCache() {
        return GenericCache.getInstance((Object)FolderItemsChangedDeleted.class.getName(), (int)Integer.MAX_VALUE, (int)60000, (int)Integer.MAX_VALUE);
    }

    public static void invalidateOnCommit(Long folderId, Long objectId, boolean create) {
        if (!RoiTransactionHandler.isTransactionActive()) {
            return;
        }
        HashSet<String> ids = (HashSet<String>)Transaction.get(TRANS_CACHE_KEY);
        if (ids == null) {
            final HashSet<String> finalIds = ids = new HashSet<String>();
            Transaction.put(TRANS_CACHE_KEY, ids);
            try {
                Transaction.afterCommit(TRANS_CACHE_KEY, new RoiTransactionHandler.Handler(){

                    @Override
                    public void run() throws Exception {
                        for (String id : finalIds) {
                            if (id.endsWith("-c")) continue;
                            FolderItemsChangedDeleted.invalidate(Long.parseLong(id));
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (objectId != null && create) {
            ids.add(objectId + "-c");
        } else if (folderId != null && objectId != null) {
            if (!ids.contains(objectId + "-c")) {
                ids.add("" + folderId);
            }
        } else if (folderId != null) {
            ids.add("" + folderId);
        }
    }

    public static Long get(Long folderId) {
        Object o = FolderItemsChangedDeleted.getCache().get((Object)folderId);
        if (o == null) {
            FolderItemsChangedDeleted.touch(folderId);
            return FolderItemsChangedDeleted.get(folderId);
        }
        return (Long)o;
    }

    public static void touch(Long folderId) {
        FolderItemsChangedDeleted.getCache().put((Object)folderId, (Object)System.currentTimeMillis());
    }

    public static void invalidate(Long folderId) {
        FolderItemsChangedDeleted.getCache().remove((Object)folderId);
    }
}

