/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.behavior;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.behavior.BaseBehavior;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.EngineContext;

public class FolderScriptBehavior
extends BaseBehavior {
    private SessionController sessionControllerAdmin;
    private GlobalObjectClientBean object;
    private String beforeAddId;
    private String afterAddId;
    private String beforeRemoveId;
    private ContentInterface beforeAdd;
    private ContentInterface afterAdd;
    private ContentInterface beforeRemove;

    @Override
    public void init(SessionController sessionControllerAdmin, GlobalObjectClientBean object, String basePath) throws Exception {
        this.sessionControllerAdmin = sessionControllerAdmin;
        this.object = object;
        MetaDb metaDb = sessionControllerAdmin.getMetaDbInstance();
        this.beforeAddId = FolderScriptBehavior.getString(metaDb, basePath + "BeforeAdd");
        this.afterAddId = FolderScriptBehavior.getString(metaDb, basePath + "AfterAdd");
        this.beforeRemoveId = FolderScriptBehavior.getString(metaDb, basePath + "BeforeRemove");
    }

    @Override
    public void beforeAssociateRight(RelationObjectClientBeanDefinition relationDef, GlobalObjectClientBean other) throws Exception {
        if (relationDef instanceof FolderRelationObjectClientBeanDefinition) {
            this.run(other, this.getBeforeAdd());
        }
    }

    @Override
    public void afterAssociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        if (relation instanceof FolderRelationObjectClientBean) {
            this.run(other, this.getAfterAdd());
        }
    }

    @Override
    public void beforeDissociateRight(RelationObjectClientBean relation, GlobalObjectClientBean other) throws Exception {
        if (relation instanceof FolderRelationObjectClientBean) {
            this.run(other, this.getBeforeRemove());
        }
    }

    private static String getString(MetaDb metaDb, String path) throws Exception {
        String[] array = metaDb.getSimplePropertyValue(path);
        if (array != null && array.length > 0) {
            return array[0];
        }
        return null;
    }

    private void run(GlobalObjectClientBean other, ContentInterface script) throws Exception {
        if (script == null) {
            return;
        }
        EngineContext context = new EngineContext(false, this.sessionControllerAdmin);
        context.put("sessionController", other.getSessionController());
        context.put("sc", other.getSessionController());
        context.put("sessionControllerAdmin", this.sessionControllerAdmin);
        context.put("sca", this.sessionControllerAdmin);
        context.put("folder", this.object);
        context.put("object", other);
        context.exec(script);
    }

    private ContentInterface getBeforeAdd() throws Exception {
        if (this.beforeAddId == null) {
            return null;
        }
        if (this.beforeAdd == null) {
            this.beforeAdd = (ContentInterface)((Object)this.sessionControllerAdmin.findGlobalObjectByPathOrId(this.beforeAddId));
        }
        return this.beforeAdd;
    }

    private ContentInterface getAfterAdd() throws Exception {
        if (this.afterAddId == null) {
            return null;
        }
        if (this.afterAdd == null) {
            this.afterAdd = (ContentInterface)((Object)this.sessionControllerAdmin.findGlobalObjectByPathOrId(this.afterAddId));
        }
        return this.afterAdd;
    }

    private ContentInterface getBeforeRemove() throws Exception {
        if (this.beforeRemoveId == null) {
            return null;
        }
        if (this.beforeRemove == null) {
            this.beforeRemove = (ContentInterface)((Object)this.sessionControllerAdmin.findGlobalObjectByPathOrId(this.beforeRemoveId));
        }
        return this.beforeRemove;
    }
}

