/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.auth;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.encrypt.ntlm.DesEncryption;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.statistic.Statistic;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.tuple.Pair;
import agorum.roi.auth.Authentication;
import agorum.roi.auth.netlogon.NetlogonConnection;
import agorum.roi.auth.netlogon.message.NetrLogonSamLogon;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialManager;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CredentialPasswordBean;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiCredentialManager;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.statistic.SessionControllerStatistic;
import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ietf.jgss.GSSName;

public class AuthenticatorFactory {
    private static final Statistic stat = SessionControllerStatistic.getInstance();
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/auth/";
    private static final String METADB_DOMAIN = "domain";
    private final String name;
    private final String className;
    private final String serviceName;
    private final String servicePass;
    private final boolean disableNtlm;
    private final Map<String, String> options;
    private final Map<String, String> ntlmOptions;
    private final Map<String, String> users;

    private AuthenticatorFactory(String name, String className, String servicePass, boolean disableNtlm, Map<String, String> options, Map<String, String> ntlmOptions, Map<String, String> users) {
        String principal;
        this.name = name;
        this.className = className;
        this.servicePass = servicePass;
        this.disableNtlm = disableNtlm;
        this.options = options;
        this.ntlmOptions = ntlmOptions;
        this.users = users;
        if (className != null && options != null && (principal = options.get("principal")) != null) {
            int i = principal.indexOf(47);
            this.serviceName = principal.substring(0, i);
            return;
        }
        this.serviceName = null;
    }

    public static AuthenticatorFactory get(String service) {
        MetaDb metaDb = AuthenticatorFactory.getSessionController().getMetaDbInstance();
        String className = metaDb.getString(METADB_BASE + service + "/Class");
        String servicePass = new CryptKeyController().tryDecrypt(metaDb.getString(METADB_BASE + service + "/ServicePass"), "metadb", AuthenticatorFactory.getSessionController());
        boolean disableNtlm = metaDb.getBoolean(METADB_BASE + service + "/DisableNtlm", false);
        HashMap<String, String> options = new HashMap<String, String>();
        String[] keys = metaDb.listSimplePropertyEntry(METADB_BASE + service + "/options");
        if (keys != null) {
            for (String key : keys) {
                options.put(key, metaDb.getString(METADB_BASE + service + "/options/" + key));
            }
        }
        return new AuthenticatorFactory(service, className, servicePass, disableNtlm, options, null, null);
    }

    public static AuthenticatorFactory get(String name, String className, String servicePass, Map<String, String> options, Map<String, String> ntlmOptions, Map<String, String> users) {
        return new AuthenticatorFactory(name, className, servicePass, false, options, ntlmOptions, users);
    }

    public Authenticator getAuthenticator() throws AuthException {
        InternalAuthenticator internal = new InternalAuthenticator(this.users == null ? new Ntlm() : new TestNtlm());
        String authenticatorClass = MetaDbSuperCache.getSimplePropertyValue(AuthenticatorFactory.getSessionController(), "MAIN_MODULE_MANAGEMENT/auth/AuthenticatorClass");
        if (authenticatorClass != null) {
            try {
                return (Authenticator)Class.forName(authenticatorClass).getConstructor(Authenticator.class, String.class).newInstance(internal, this.name);
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not instantiate custom authenticator class: " + authenticatorClass);
            }
        }
        return internal;
    }

    private static SessionController getSessionController() {
        return SessionControllerAdmin.getService(AuthenticatorFactory.class);
    }

    public static void checkKerberos(String name, String testUser, String testPass) throws AuthException {
        AuthenticatorFactory.get(name).checkKerberos(testUser, testPass);
    }

    private void checkKerberos(String testUser, String testPass) throws AuthException {
        Authentication.Identity client;
        Authentication.Identity service;
        try {
            service = Authentication.loginService(this.serviceName, this.servicePass, this.className, this.options);
        }
        catch (Exception e) {
            throw new AuthException("Service account login failed: " + e.getMessage(), e);
        }
        try {
            client = Authentication.loginClient(service, testUser, testPass);
        }
        catch (Exception e) {
            throw new AuthException("Test user login failed: " + e.getMessage(), e);
        }
        try {
            client.context.requestMutualAuth(true);
            byte[] token = new byte[]{};
            while (token != null) {
                byte[] clientInToken = token;
                if ((token = Authentication.inContext(client.loginContext, () -> client.context.initSecContext(clientInToken, 0, clientInToken.length))) == null) continue;
                byte[] serverInToken = token;
                token = Authentication.inContext(service.loginContext, () -> service.context.acceptSecContext(serverInToken, 0, serverInToken.length));
            }
        }
        catch (Exception e) {
            throw new AuthException("Client/server authentication failed: " + e.getMessage(), e);
        }
        if (!service.context.isEstablished()) {
            throw new AuthException("Client failed to authenticate to server");
        }
        if (!client.context.isEstablished()) {
            throw new AuthException("Server failed to authenticate to client");
        }
    }

    public static void checkNtlmPassThrough(String netBiosDomain, String netBiosName, String netBiosDomainController, String domainController, String servicePass, String testUser, String testPass) throws IOException {
        int status;
        String workstation = "TESTWORKSTATION";
        Type1Message t1m = new Type1Message(Type1Message.getDefaultFlags(), netBiosDomain, "TESTWORKSTATION");
        Type2Message t2m = Authentication.ntlmChallenge(t1m, netBiosDomain, netBiosName);
        Type3Message t3m = new Type3Message(t2m, testPass, netBiosDomain, testUser, "TESTWORKSTATION", 0);
        try (NetlogonConnection conn = new NetlogonConnection(domainController, netBiosDomainController, netBiosDomain, netBiosName, servicePass);){
            status = conn.logon(netBiosDomain, testUser, "TESTWORKSTATION", t2m.getChallenge(), t3m.getNTResponse(), t3m.getLMResponse()).getStatus();
        }
        catch (Exception e) {
            throw new AuthException("Service account login failed: " + e.getMessage(), e);
        }
        if (status != 0) {
            SmbException e = new SmbException(status, false);
            throw new AuthException("Test user login failed: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        if (System.getProperty("sun.security.spnego.msinterop") == null) {
            System.setProperty("sun.security.spnego.msinterop", "false");
        }
        try {
            MetaDb metaDb = AuthenticatorFactory.getSessionController().getMetaDbInstance();
            String realm = metaDb.getString("MAIN_MODULE_MANAGEMENT/auth/domain/Realm");
            String kdc = metaDb.getString("MAIN_MODULE_MANAGEMENT/auth/domain/KDC");
            if (realm != null && kdc != null) {
                System.setProperty("java.security.krb5.realm", realm);
                System.setProperty("java.security.krb5.kdc", kdc);
            }
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
    }

    public class InternalAuthenticator
    implements Authenticator {
        private final Ntlm ntlm;
        private Authentication.Identity service;
        private State state = State.NONE;
        private byte[] buffer;
        private byte[] challenge;
        private byte[] exportedSessionKey;
        private boolean authenticated;
        private String userName;
        private String userDomain;
        private String userWorkstation;
        private SessionController sessionController;

        private InternalAuthenticator(Ntlm ntlm) {
            this.ntlm = ntlm;
        }

        private void setAuthenticated(boolean authenticated) {
            this.authenticated = authenticated;
            this.close();
        }

        @Override
        public boolean isAuthenticated() {
            return this.authenticated;
        }

        @Override
        public String getName() {
            return this.userName;
        }

        @Override
        public String getDomain() {
            return this.userDomain;
        }

        @Override
        public byte[] getChallenge() {
            return this.challenge;
        }

        @Override
        public byte[] getExportedSessionKey() {
            return this.exportedSessionKey;
        }

        protected void finalize() {
            this.close();
        }

        @Override
        public void close() {
            this.state = State.NONE;
            if (this.service != null) {
                try {
                    this.service.context.dispose();
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                try {
                    this.service.loginContext.logout();
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
                this.service = null;
            }
        }

        @Override
        public byte[] negTokenInit() throws IOException {
            DERSequence mechTypes;
            if (this.init()) {
                mechTypes = AuthenticatorFactory.this.disableNtlm ? Authentication.buildSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.2.840.113554.1.2.2"), new DERObjectIdentifier("1.2.840.48018.1.2.2")}) : Authentication.buildSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.2.840.113554.1.2.2"), new DERObjectIdentifier("1.2.840.48018.1.2.2"), new DERObjectIdentifier("1.3.6.1.4.1.311.2.2.10")});
            } else {
                if (AuthenticatorFactory.this.disableNtlm) {
                    throw new AuthException("No available authentication mechanisms");
                }
                mechTypes = Authentication.buildSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.3.6.1.4.1.311.2.2.10")});
            }
            DERSequence negHints = Authentication.buildSequence(new ASN1Encodable[]{new DERTaggedObject(0, (DEREncodable)new DERGeneralString("not_defined_in_RFC4178@please_ignore"))});
            DERSequence negTokenInit = Authentication.buildSequence(new ASN1Encodable[]{new DERTaggedObject(0, (DEREncodable)mechTypes), new DERTaggedObject(3, (DEREncodable)negHints)});
            ASN1EncodableVector appSpec = new ASN1EncodableVector();
            appSpec.add((DEREncodable)new DERObjectIdentifier("1.3.6.1.5.5.2"));
            appSpec.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)negTokenInit));
            DERApplicationSpecific token = new DERApplicationSpecific(0, appSpec);
            return token.getEncoded();
        }

        private byte[] negTokenTarg(String supportedMechId) throws IOException {
            DEREnumerated negState = new DEREnumerated(1);
            DERObjectIdentifier supportedMech = new DERObjectIdentifier(supportedMechId);
            DERSequence negTokenTarg = Authentication.buildSequence(new ASN1Encodable[]{new DERTaggedObject(0, (DEREncodable)negState), new DERTaggedObject(1, (DEREncodable)supportedMech)});
            ASN1EncodableVector appSpec = new ASN1EncodableVector();
            appSpec.add((DEREncodable)new DERObjectIdentifier("1.3.6.1.5.5.2"));
            appSpec.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)negTokenTarg));
            DERApplicationSpecific token = new DERApplicationSpecific(0, appSpec);
            return token.getEncoded();
        }

        @Override
        public byte[] auth(byte[] token) throws AuthException {
            this.authenticated = false;
            if (this.buffer != null) {
                byte[] concatenated = new byte[this.buffer.length + token.length];
                System.arraycopy(this.buffer, 0, concatenated, 0, this.buffer.length);
                System.arraycopy(token, 0, concatenated, this.buffer.length, token.length);
                this.buffer = null;
                token = concatenated;
            }
            try {
                byte[] response = this.ntlmDetect(token);
                if (response != null) {
                    if (AuthenticatorFactory.this.disableNtlm) {
                        throw new AuthException("NTLM not allowed");
                    }
                    return response;
                }
                switch (this.state) {
                    case NONE: {
                        return this.acceptPeek(token);
                    }
                    case JGSS: {
                        return this.acceptJgss(token);
                    }
                    case NTLM: {
                        return this.acceptNtlm(token);
                    }
                }
                throw new AuthException("Invalid state: " + (Object)((Object)this.state));
            }
            catch (AuthException e) {
                this.close();
                stat.error().exception((Throwable)e).send("Authentication failed");
                throw e;
            }
            catch (Exception e) {
                this.close();
                stat.error().exception((Throwable)e).send("Authentication failed");
                throw new AuthException(e);
            }
        }

        @Override
        public void auth(String username, String password) {
            try {
                if (this.init()) {
                    Authentication.Identity client = Authentication.loginClient(this.service, username, password);
                    byte[] token = new byte[]{};
                    while (token != null) {
                        byte[] clientInToken = token;
                        if ((token = Authentication.inContext(client.loginContext, () -> client.context.initSecContext(clientInToken, 0, clientInToken.length))) == null) continue;
                        token = this.auth(token);
                    }
                    if (this.authenticated) {
                        RoiCredentialManager.updatePasswordHashes(username, password);
                    }
                } else {
                    String domain = this.ntlm.netBiosDomain;
                    String workstation = "TESTWORKSTATION";
                    Type1Message t1m = new Type1Message(Type1Message.getDefaultFlags(), domain, "TESTWORKSTATION");
                    Type2Message t2m = new Type2Message(this.auth(t1m.toByteArray()));
                    Type3Message t3m = new Type3Message(t2m, password, domain, username, "TESTWORKSTATION", 0);
                    this.auth(t3m.toByteArray());
                }
            }
            catch (Exception e) {
                stat.debug((Throwable)e);
            }
        }

        @Override
        public SessionController getSessionController() throws AuthException {
            if (this.sessionController == null) {
                if (!this.authenticated) {
                    throw new AuthException("Not authenticated");
                }
                CredentialObject credential = new CredentialObject();
                credential.setUserName(this.userName, this.userDomain);
                credential.setModulInfo(AuthenticatorFactory.this.name);
                credential.setAuthInterface(new ServiceAuthInterface());
                try {
                    this.sessionController = SessionController.connect(credential);
                }
                catch (Exception e) {
                    throw new AuthException(e);
                }
            }
            return this.sessionController;
        }

        private boolean init() throws AuthException {
            if (AuthenticatorFactory.this.serviceName == null) {
                return false;
            }
            if (this.service != null) {
                return true;
            }
            try {
                this.service = Authentication.loginService(AuthenticatorFactory.this.serviceName, AuthenticatorFactory.this.servicePass, AuthenticatorFactory.this.className, AuthenticatorFactory.this.options);
            }
            catch (Exception e) {
                throw new AuthException(e);
            }
            return true;
        }

        private byte[] ntlmDetect(byte[] token) throws Exception {
            Type1Message t1m = null;
            try {
                t1m = new Type1Message(token);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t1m != null) {
                return this.ntlmChallenge(t1m, false);
            }
            Type3Message t3m = null;
            try {
                t3m = new Type3Message(token);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t3m != null) {
                return this.ntlmAuth(t3m, false);
            }
            return null;
        }

        private byte[] acceptJgss(byte[] token) throws Exception {
            byte[] response = Authentication.inContext(this.service.loginContext, () -> this.service.context.acceptSecContext(token, 0, token.length));
            if (this.service.context.isEstablished()) {
                GSSName srcName = this.service.context.getSrcName();
                String fullName = srcName.toString();
                int i = fullName.lastIndexOf("@");
                if (i < 0) {
                    this.userDomain = null;
                    this.userName = fullName;
                } else {
                    this.userDomain = fullName.substring(i + 1);
                    this.userName = fullName.substring(0, i);
                }
                this.logSuccess("Kerberos");
                Key key = (Key)((ExtendedGSSContext)this.service.context).inquireSecContext(InquireType.KRB5_GET_SESSION_KEY);
                if (key != null) {
                    this.exportedSessionKey = key.getEncoded();
                }
                this.setAuthenticated(true);
            }
            return response;
        }

        private byte[] acceptPeek(byte[] token) throws Exception {
            DERApplicationSpecific appSpec;
            try {
                appSpec = Authentication.cast(Authentication.parse(token), DERApplicationSpecific.class);
            }
            catch (IOException e) {
                if (token != null && token.length > 0) {
                    SessionControllerStatistic.getInstance().debug().send((Throwable)e);
                    this.buffer = token;
                    return new byte[0];
                }
                throw e;
            }
            DERSequence seq = Authentication.cast(appSpec.getObject(16), DERSequence.class);
            DERObjectIdentifier oid = Authentication.get(seq, 0, DERObjectIdentifier.class);
            if (!"1.3.6.1.5.5.2".equals(oid.getId())) {
                throw new AuthException("Not SPNEGO");
            }
            DERSequence negTokenInit = Authentication.getTag(seq, 0, DERSequence.class);
            DERSequence mechTypes = Authentication.getTag(negTokenInit, 0, DERSequence.class);
            DERObjectIdentifier preferredMechOid = Authentication.get(mechTypes, 0, DERObjectIdentifier.class);
            if ("1.3.6.1.4.1.311.2.2.10".equals(preferredMechOid.getId()) && !AuthenticatorFactory.this.disableNtlm) {
                DEROctetString type1 = Authentication.getTag(negTokenInit, 2, DEROctetString.class);
                return this.ntlmChallenge(new Type1Message(type1.getOctets()), true);
            }
            if (this.init()) {
                this.state = State.JGSS;
                return this.acceptJgss(token);
            }
            if (!AuthenticatorFactory.this.disableNtlm) {
                for (int i = 1; i < mechTypes.size(); ++i) {
                    if (!"1.3.6.1.4.1.311.2.2.10".equals(Authentication.get(mechTypes, i, DERObjectIdentifier.class).getId())) continue;
                    return this.negTokenTarg("1.3.6.1.4.1.311.2.2.10");
                }
            }
            throw new AuthException("Mechanism not supported: " + preferredMechOid.getId());
        }

        private byte[] ntlmChallenge(Type1Message t1m, boolean gssApi) throws IOException {
            this.state = State.NTLM;
            Type2Message t2m = Authentication.ntlmChallenge(t1m, this.ntlm.netBiosDomain, this.ntlm.netBiosName);
            this.challenge = t2m.getChallenge();
            if (gssApi) {
                return new DERTaggedObject(1, (DEREncodable)Authentication.buildSequence(new ASN1Encodable[]{new DERTaggedObject(0, (DEREncodable)new DEREnumerated(1)), new DERTaggedObject(1, (DEREncodable)new DERObjectIdentifier("1.3.6.1.4.1.311.2.2.10")), new DERTaggedObject(2, (DEREncodable)new DEROctetString(t2m.toByteArray()))})).getEncoded();
            }
            return t2m.toByteArray();
        }

        private byte[] acceptNtlm(byte[] token) throws Exception {
            DERTaggedObject obj = Authentication.cast(Authentication.parse(token), DERTaggedObject.class);
            DERSequence negTokenTarg = Authentication.get(obj, 1, DERSequence.class);
            DEROctetString type3 = Authentication.getTag(negTokenTarg, 2, DEROctetString.class);
            return this.ntlmAuth(new Type3Message(type3.getOctets()), true);
        }

        private byte[] ntlmAuth(Type3Message t3m, boolean gssApi) throws Exception {
            this.userWorkstation = t3m.getWorkstation();
            this.userDomain = t3m.getDomain();
            this.userName = t3m.getUser();
            Pair<String, String> hashes = this.ntlm.getHashes(this.userName);
            if (hashes != null) {
                try {
                    this.setAuthenticated(this.authNtlm(t3m, (String)hashes.getFirst(), (String)hashes.getSecond()));
                }
                catch (Exception e) {
                    throw new AuthException("Authentication failed for " + this.userName + "@" + this.userDomain + " on " + this.userWorkstation, e);
                }
            }
            if (!this.authenticated) {
                throw new AuthException("Authentication failed for " + this.userName + "@" + this.userDomain + " on " + this.userWorkstation);
            }
            if (gssApi) {
                return new DERTaggedObject(1, (DEREncodable)Authentication.buildSequence(new ASN1Encodable[]{new DERTaggedObject(0, (DEREncodable)new DEREnumerated(0))})).getEncoded();
            }
            return new byte[0];
        }

        private boolean authNtlm(Type3Message t3m, String lmHash, String ntlmHash) throws Exception {
            String lmPassword;
            if (this.authNtlmPassThrough(t3m)) {
                this.logSuccess("NTLM pass-through");
                return true;
            }
            byte[] ntResponse = t3m.getNTResponse();
            byte[] lmResponse = t3m.getLMResponse();
            if (ntResponse == null || ntResponse.length <= 0) {
                throw new AuthException("Invalid NTLM response (missing password)");
            }
            String ntResponseHex = StringConverterUtils.toHexString((byte[])ntResponse);
            if (this.authNtlmv2(t3m, ntResponseHex, ntlmHash)) {
                this.logSuccess("NTLMv2");
                return true;
            }
            byte[] nTOWFv1 = StringConverterUtils.toByte((String)ntlmHash);
            if (lmResponse.length >= 8 && ntResponseHex.equals(StringConverterUtils.toHexString((byte[])NtlmPasswordAuthentication.getNTLM2Response((byte[])nTOWFv1, (byte[])this.challenge, (byte[])lmResponse)))) {
                this.logWarn("NTLM");
                return true;
            }
            String ntlmPassword = StringConverterUtils.toHexString((byte[])NTLMEncryption.encryptFromHash((String)ntlmHash, (byte[])this.challenge));
            if (ntResponseHex.equals(ntlmPassword)) {
                this.logWarn("NT");
                return true;
            }
            String string = lmPassword = lmHash == null ? null : StringConverterUtils.toHexString((byte[])new DesEncryption().getDesEncodedPasswordFromBase(lmHash, this.challenge));
            if (ntResponseHex.equals(lmPassword)) {
                this.logWarn("LM");
                return true;
            }
            this.logFailure("NTLM");
            return false;
        }

        private boolean authNtlmv2(Type3Message t3m, String ntResponseHex, String ntlmHash) throws Exception {
            String domain = this.userDomain;
            if (!ntResponseHex.equals(NTLMEncryption.getCompletePasswordHash((String)ntResponseHex, (String)this.userName, (String)ntlmHash, (String)this.userDomain, (byte[])this.challenge, (boolean)false))) {
                domain = domain.toUpperCase();
                if (!ntResponseHex.equals(NTLMEncryption.getCompletePasswordHash((String)ntResponseHex, (String)this.userName, (String)ntlmHash, (String)this.userDomain, (byte[])this.challenge, (boolean)false))) {
                    return false;
                }
            }
            byte[] keyExchangeKey = NTLMEncryption.getSessionBaseKey((String)ntResponseHex, (String)ntlmHash, (String)this.userName, (String)domain);
            this.setSessionKey(t3m, keyExchangeKey);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean authNtlmPassThrough(Type3Message t3m) {
            String domainController = this.ntlm.domainController;
            String domainControllerName = this.ntlm.domainControllerName;
            String domainName = this.ntlm.netBiosDomain;
            String serviceMachineName = this.ntlm.netBiosName;
            String servicePass = this.ntlm.servicePass;
            if (servicePass == null) {
                return false;
            }
            try (NetlogonConnection conn = new NetlogonConnection(domainController, domainControllerName, domainName, serviceMachineName, servicePass);){
                NetrLogonSamLogon nlsl = conn.logon(this.userDomain, this.userName, this.userWorkstation, this.challenge, t3m.getNTResponse(), t3m.getLMResponse());
                if (nlsl.getStatus() != 0) return false;
                this.setSessionKey(t3m, NTLMEncryption.decryptRc4((byte[])conn.getSessionKey(), (byte[])nlsl.getNetlogonValidationSamInfo().getUserSessionKey()));
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                stat.error((Throwable)e);
            }
            return false;
        }

        private void setSessionKey(Type3Message t3m, byte[] keyExchangeKey) throws InvalidKeyException, ShortBufferException, NoSuchAlgorithmException, NoSuchPaddingException {
            this.exportedSessionKey = t3m.getFlag(0x40000000) && t3m.getFlag(16) || t3m.getFlag(32) ? NTLMEncryption.getExportedSessionKey((byte[])keyExchangeKey, (byte[])t3m.getSessionKey()) : keyExchangeKey;
        }

        private void logSuccess(String mech) {
            stat.debug("User " + this.userName + "@" + this.userDomain + " authenticated successfully using " + mech);
        }

        private void logWarn(String mech) {
            stat.warning("User " + this.userName + "@" + this.userDomain + " authenticated successfully using " + mech);
            stat.warning().sticky("OBSOLETE_AUTH_MECHANISM").send("At least one client is using an obsolete authentication mechanism. This is not only insecure but can also lead to SMB connection problems. Please check the log for affected clients.");
        }

        private void logFailure(String mech) {
            stat.debug("User " + this.userName + "@" + this.userDomain + " failed to authenticate using " + mech);
        }
    }

    public static interface Authenticator
    extends AutoCloseable {
        @Override
        public void close();

        public byte[] negTokenInit() throws IOException;

        public byte[] getChallenge();

        public byte[] auth(byte[] var1) throws AuthException;

        public void auth(String var1, String var2);

        public boolean isAuthenticated();

        public String getName();

        public String getDomain();

        public SessionController getSessionController() throws AuthException;

        public byte[] getExportedSessionKey();
    }

    private class TestNtlm
    extends Ntlm {
        private TestNtlm() {
            super((String)AuthenticatorFactory.this.ntlmOptions.get("netBiosName"), (String)AuthenticatorFactory.this.ntlmOptions.get("netBiosDomain"), (String)AuthenticatorFactory.this.ntlmOptions.get("servicePass"), (String)AuthenticatorFactory.this.ntlmOptions.get("domainController"), (String)AuthenticatorFactory.this.ntlmOptions.get("domainControllerName"));
        }

        @Override
        protected Pair<String, String> getHashes(String username) {
            String password = (String)AuthenticatorFactory.this.users.get(username);
            if (password == null) {
                return null;
            }
            return new Pair((Object)new DesEncryption().getBaseDESPassword(password), (Object)StringConverterUtils.toHexString((byte[])new NTLMEncryption().getNTLMHash(password)));
        }
    }

    private static class Ntlm {
        final String netBiosName;
        final String netBiosDomain;
        final String servicePass;
        final String domainController;
        final String domainControllerName;

        private Ntlm(String netBiosName, String netBiosDomain, String servicePass, String domainController, String domainControllerName) {
            this.netBiosName = netBiosName;
            this.netBiosDomain = netBiosDomain;
            this.servicePass = servicePass;
            this.domainController = domainController;
            this.domainControllerName = domainControllerName;
        }

        private Ntlm() {
            SessionController sc = AuthenticatorFactory.getSessionController();
            this.netBiosName = MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/NetBiosName", "AGORUM");
            this.netBiosDomain = MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/NetBiosDomain", "AGORUM");
            this.servicePass = MetaDbSuperCache.getEncryptedPropertyValue(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/ServicePass");
            this.domainController = MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/DomainController");
            this.domainControllerName = MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/NetBiosDomainController");
        }

        protected Pair<String, String> getHashes(String userName) throws Exception {
            int i = userName.indexOf(92);
            int j = userName.indexOf(64);
            DirectoryUserObjectClientBean dirObj = null;
            if (i >= 0) {
                dirObj = AuthenticatorFactory.getSessionController().getUserByName(userName.substring(i + 1));
            } else if (j >= 0) {
                dirObj = AuthenticatorFactory.getSessionController().getUserByName(userName.substring(0, j));
            }
            if (dirObj == null) {
                dirObj = AuthenticatorFactory.getSessionController().getUserByName(userName);
            }
            if (dirObj == null) {
                throw new AuthException("User unknown: " + userName);
            }
            CredentialConfig config = BaseCredentialManager.getCredentialConfig(dirObj.getCredentialManager());
            CredentialManager cm = BaseCredentialManager.getCredentialManager(config);
            if (cm instanceof BaseCredentialManager) {
                CredentialObject credential = new CredentialObject();
                credential.setUserName(dirObj.getName());
                try (Connection conn = new ConnectionUtils().getConnection();){
                    CredentialPasswordBean cpb = ((BaseCredentialManager)cm).getPasswordHashes(conn, credential);
                    if (cpb != null) {
                        Pair pair = new Pair((Object)cpb.getLmHash(), (Object)cpb.getNtlmHash());
                        return pair;
                    }
                }
            }
            return null;
        }
    }

    public static class AuthException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AuthException(String message) {
            super(message);
        }

        public AuthException(String message, Throwable cause) {
            super(message, cause);
        }

        public AuthException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }

    private static enum State {
        NONE,
        JGSS,
        NTLM;

    }
}

