/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.auth;

import agorum.commons.statistic.Statistic;
import agorum.commons.utils.ChallengeGenerator;
import agorum.roi.auth.AgorumKrb5LoginModule;
import agorum.roi.auth.AuthenticatorFactory;
import agorum.roi.statistic.SessionControllerStatistic;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Authentication {
    private static final Statistic stat = SessionControllerStatistic.getInstance();
    private static final boolean LEGACY_MODE;
    private static final String LEGACY_MODE_STICKY;
    public static final int KRB_NT_ENTERPRISE;
    public static final String KERBEROS_LOGIN_MODULE;
    public static final String OID_SPNEGO = "1.3.6.1.5.5.2";
    public static final String OID_KRB5 = "1.2.840.113554.1.2.2";
    public static final String OID_MS_KRB5 = "1.2.840.48018.1.2.2";
    public static final String OID_NTLMSSP = "1.3.6.1.4.1.311.2.2.10";

    private static String getServicePrincipal(LoginContext lc) {
        return lc.getSubject().getPrincipals().iterator().next().getName();
    }

    private static CallbackHandler callbackHandler(String name, String password) {
        return password == null ? null : callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof TextOutputCallback) continue;
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(name);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unsupported callback");
            }
        };
    }

    public static <T> T inContext(LoginContext loginContext, PrivilegedExceptionAction<T> action) throws Exception {
        try {
            return Subject.doAs(loginContext.getSubject(), action);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Identity loginService(String serviceName, String servicePass, String className, Map<String, String> options) throws Exception {
        Identity service = new Identity();
        service.loginContext = new LoginContext(serviceName, null, Authentication.callbackHandler(options.get("principal"), servicePass), new DynamicConfiguration(className, options));
        service.loginContext.login();
        GSSManager gssManager = GSSManager.getInstance();
        Oid oid = new Oid(OID_SPNEGO);
        service.name = gssManager.createName(Authentication.getServicePrincipal(service.loginContext), null).canonicalize(oid);
        Authentication.inContext(service.loginContext, () -> {
            service.context = gssManager.createContext(gssManager.createCredential(service.name, 0, oid, 2));
            return service.context;
        });
        return service;
    }

    public static Identity loginClient(Identity service, String userName, String userPass) throws Exception {
        int i;
        String spn = Authentication.getServicePrincipal(service.loginContext);
        String realmSuffix = spn.substring(spn.lastIndexOf("@"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (!userName.toLowerCase().endsWith(realmSuffix.toLowerCase())) {
            if (userName.contains("@")) {
                userName = userName.replace("@", "\\@");
            }
            userName = userName + realmSuffix;
        }
        if ((i = userName.lastIndexOf("@")) < 0) {
            throw new AuthenticatorFactory.AuthException("Invalid principal name (realm missing): " + userName);
        }
        if (userName.contains("\\@")) {
            options.put("principalType", KRB_NT_ENTERPRISE);
            if (LEGACY_MODE) {
                stat.warning().sticky(LEGACY_MODE_STICKY).detail((Object)"Password authentication for users using UPN suffixes that don't match the domain name are not supported for your JVM version. Please consider upgrading.").send("You are using an outdated JVM, please consider upgrading.");
            }
        }
        userName = userName.substring(0, i + 1) + userName.substring(i + 1).toUpperCase();
        options.put("storeKey", "true");
        Identity client = new Identity();
        client.loginContext = new LoginContext("TestKerberosClient", null, Authentication.callbackHandler(userName, userPass), new DynamicConfiguration(KERBEROS_LOGIN_MODULE, options));
        client.loginContext.login();
        GSSManager gssManager = GSSManager.getInstance();
        Oid oid = new Oid(OID_SPNEGO);
        client.name = gssManager.createName(userName, null).canonicalize(oid);
        GSSCredential clientCreds = Authentication.inContext(client.loginContext, () -> gssManager.createCredential(client.name, 0, oid, 1));
        client.context = gssManager.createContext(service.name, oid, clientCreds, 0);
        return client;
    }

    public static Type2Message ntlmChallenge(Type1Message t1m, String domain, String name) throws IOException {
        Type2Message t2m = new Type2Message(t1m, ChallengeGenerator.getRealChallenge((int)8), domain, domain);
        String netBiosDomain = domain.toUpperCase();
        String netBiosName = name.toUpperCase();
        String dnsDomain = domain;
        String dnsName = name;
        ByteArrayOutputStream targetInfo = new ByteArrayOutputStream();
        Authentication.putBlock(targetInfo, 2, netBiosDomain);
        Authentication.putBlock(targetInfo, 1, netBiosName);
        Authentication.putBlock(targetInfo, 4, dnsDomain);
        Authentication.putBlock(targetInfo, 3, dnsName);
        Authentication.putBlock(targetInfo, 7, System.currentTimeMillis() * 10000L + 116444736000000000L);
        Authentication.putBlock(targetInfo, 0, "");
        t2m.setTargetInformation(targetInfo.toByteArray());
        return t2m;
    }

    private static void putBlock(ByteArrayOutputStream os, int type, byte[] contentBytes) throws IOException {
        int length = contentBytes.length;
        os.write((byte)(type & 0xFF));
        os.write((byte)((type & 0xFF00) >> 8));
        os.write((byte)(length & 0xFF));
        os.write((byte)((length & 0xFF00) >> 8));
        os.write(contentBytes);
    }

    private static void putBlock(ByteArrayOutputStream os, int type, long content) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put((byte)content);
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        bb.put((byte)(content >>= 8));
        Authentication.putBlock(os, type, bb.array());
    }

    private static void putBlock(ByteArrayOutputStream os, int type, String content) throws IOException {
        Authentication.putBlock(os, type, content.getBytes(StandardCharsets.UTF_16LE));
    }

    public static DERObject parse(byte[] data) throws IOException {
        try (ASN1InputStream ais = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));){
            DERObject dERObject = ais.readObject();
            return dERObject;
        }
    }

    public static DERSequence buildSequence(ASN1Encodable ... item) {
        return new DERSequence(item);
    }

    public static <T> T cast(Object object, Class<T> type) throws AuthenticatorFactory.AuthException {
        if (object == null) {
            throw new AuthenticatorFactory.AuthException("Expected object of type " + type + ", got null");
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new AuthenticatorFactory.AuthException("Expected object of type " + type + ", got " + object.getClass().getName());
        }
        return (T)object;
    }

    public static <T> T get(DERTaggedObject tagged, int tag, Class<T> type) throws AuthenticatorFactory.AuthException {
        if (tagged.getTagNo() != tag) {
            throw new AuthenticatorFactory.AuthException("Expected tag " + tag + ", got tag " + tagged.getTagNo());
        }
        return Authentication.cast(tagged.getObject(), type);
    }

    public static <T> T get(DERSequence seq, int i, Class<T> type) throws AuthenticatorFactory.AuthException {
        if (seq.size() <= i) {
            throw new AuthenticatorFactory.AuthException("Sequence too short - expected at least length " + i);
        }
        return Authentication.cast(seq.getObjectAt(i), type);
    }

    public static <T> T getTag(DERSequence seq, int tag, Class<T> type) throws AuthenticatorFactory.AuthException {
        for (int i = 0; i < seq.size(); ++i) {
            DERTaggedObject tagged;
            DEREncodable obj = seq.getObjectAt(i);
            if (!(obj instanceof DERTaggedObject) || (tagged = (DERTaggedObject)obj).getTagNo() != tag) continue;
            return Authentication.cast(tagged.getObject(), type);
        }
        throw new AuthenticatorFactory.AuthException("Missing tag " + tag);
    }

    static {
        LEGACY_MODE_STICKY = Authentication.class.getCanonicalName() + ".LEGACY_MODE";
        int krbNtEnterprise = -1;
        try {
            Class.forName("sun.security.krb5.Credentials").getMethod("getProxy", new Class[0]);
            krbNtEnterprise = (Integer)Class.forName("sun.security.krb5.PrincipalName").getField("KRB_NT_ENTERPRISE").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        KRB_NT_ENTERPRISE = krbNtEnterprise;
        if (KRB_NT_ENTERPRISE >= 0) {
            LEGACY_MODE = false;
            KERBEROS_LOGIN_MODULE = AgorumKrb5LoginModule.class.getCanonicalName();
        } else {
            LEGACY_MODE = true;
            KERBEROS_LOGIN_MODULE = Krb5LoginModule.class.getCanonicalName();
        }
    }

    private static class DynamicConfiguration
    extends Configuration {
        private final String className;
        private final Map<String, ?> options;

        public DynamicConfiguration(String className, Map<String, ?> options) {
            this.className = className;
            this.options = options;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{new AppConfigurationEntry(this.className, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.options)};
        }
    }

    public static class Identity {
        public GSSName name;
        public GSSContext context;
        public LoginContext loginContext;
    }
}

