/*
 * Decompiled with CFR 0.152.
 */
package agorum.api.common.beans.common;

import agorum.api.common.beans.adapters.PropertyDeserializer;
import agorum.api.common.beans.adapters.PropertySerializer;
import agorum.api.common.beans.common.PropertyArray;
import agorum.api.common.beans.common.PropertyBoolean;
import agorum.api.common.beans.common.PropertyDouble;
import agorum.api.common.beans.common.PropertyLong;
import agorum.api.common.beans.common.PropertyMap;
import agorum.api.common.beans.common.PropertyString;
import agorum.api.common.exceptions.usage.ApiInvalidParameterException;
import agorum.api.common.utils.DataTypes;
import agorum.api.common.utils.Objects;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.scripting.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mozilla.javascript.Scriptable;

@JsonSerialize(using=PropertySerializer.class)
@JsonDeserialize(using=PropertyDeserializer.class)
@XmlType(name="Property")
public abstract class Property
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectWriter writer;

    public static Property fromString(String toParse) {
        return PropertyDeserializer.deserializeProperty(toParse);
    }

    public static Object unwrap(Object value) {
        if (value instanceof PropertyArray) {
            return Property.unwrap((PropertyArray)value);
        }
        if (value instanceof PropertyMap) {
            return Property.unwrap((PropertyMap)value);
        }
        if (value instanceof Property) {
            return ((Property)value).getObject();
        }
        return value;
    }

    public static List<Object> unwrap(PropertyArray value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(value.size());
        for (Property item : value) {
            result.add(Property.unwrap(item));
        }
        return result;
    }

    public static Map<String, Object> unwrap(PropertyMap value) {
        if (value == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(value.size());
        for (Map.Entry<String, Property> entry : value.getProperties().entrySet()) {
            result.put(entry.getKey(), Property.unwrap(entry.getValue()));
        }
        return result;
    }

    public static Property valueOf(Object value) {
        return value instanceof Property ? (Property)value : Property.valueOf(value, Collections.newSetFromMap(new IdentityHashMap()));
    }

    public static PropertyArray valueOf(List<?> value) {
        return (PropertyArray)Property.valueOf(value);
    }

    public static PropertyMap valueOf(Map<String, ?> value) {
        return (PropertyMap)Property.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Property valueOf(Object value, Set<Object> handled) {
        if (value == null) {
            return null;
        }
        if (value instanceof Property) {
            return (Property)value;
        }
        if (value instanceof AttributeValue) {
            return Property.valueOf(((AttributeValue)value).unwrap(), handled);
        }
        if (value instanceof Date) {
            return new PropertyString(DataTypes.dateTimeToString((Date)value));
        }
        if (value instanceof Scriptable) {
            return Property.valueOf(Converter.toJava(value), handled);
        }
        if (value instanceof GlobalObjectClientBean) {
            return new PropertyLong(Objects.getId((GlobalObjectClientBean)value));
        }
        if (value instanceof Long) {
            return new PropertyLong((Long)value);
        }
        if (value instanceof Integer) {
            return new PropertyLong(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return new PropertyDouble((Double)value);
        }
        if (value instanceof Float) {
            return new PropertyDouble(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return new PropertyBoolean((Boolean)value);
        }
        if (value instanceof String) {
            return new PropertyString((String)value);
        }
        if (value instanceof long[]) {
            PropertyArray array = new PropertyArray();
            for (long item : (long[])value) {
                array.add(Property.valueOf(item, handled));
            }
            return array;
        }
        if (value instanceof int[]) {
            PropertyArray array = new PropertyArray();
            for (int item : (int[])value) {
                array.add(Property.valueOf(item, handled));
            }
            return array;
        }
        if (value instanceof double[]) {
            PropertyArray array = new PropertyArray();
            for (double item : (double[])value) {
                array.add(Property.valueOf(item, handled));
            }
            return array;
        }
        if (value instanceof float[]) {
            PropertyArray array = new PropertyArray();
            for (float item : (float[])value) {
                array.add(Property.valueOf(Float.valueOf(item), handled));
            }
            return array;
        }
        if (value instanceof boolean[]) {
            PropertyArray array = new PropertyArray();
            for (boolean item : (boolean[])value) {
                array.add(Property.valueOf(item, handled));
            }
            return array;
        }
        if (handled.contains(value)) {
            return null;
        }
        try {
            handled.add(value);
            if (value instanceof Object[]) {
                PropertyArray array = new PropertyArray();
                for (Object item : (Object[])value) {
                    array.add(Property.valueOf(item, handled));
                }
                PropertyArray propertyArray = array;
                return propertyArray;
            }
            if (value instanceof Iterable) {
                PropertyArray array = new PropertyArray();
                for (Object item : (Iterable)value) {
                    array.add(Property.valueOf(item, handled));
                }
                PropertyArray propertyArray = array;
                return propertyArray;
            }
            if (value instanceof Map) {
                PropertyMap map = new PropertyMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    map.put(entry.getKey().toString(), Property.valueOf(entry.getValue(), handled));
                }
                PropertyMap propertyMap = map;
                return propertyMap;
            }
            PropertyString propertyString = new PropertyString(value.toString());
            return propertyString;
        }
        finally {
            handled.remove(value);
        }
    }

    public String toString() {
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public String toPrettyString() {
        try {
            return writer.withDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public Object getObject() {
        return null;
    }

    public Long getLong() {
        return null;
    }

    public Double getDouble() {
        return null;
    }

    public Boolean getBoolean() {
        return null;
    }

    public String getString() {
        Object object = this.getObject();
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Date getDate() {
        try {
            return DataTypes.stringToDate(this.getString());
        }
        catch (ParseException e) {
            throw new ApiInvalidParameterException("Unparseable date: " + this.getString(), e);
        }
    }

    public Date getDateTime() {
        try {
            return DataTypes.stringToDateTime(this.getString());
        }
        catch (ParseException e) {
            throw new ApiInvalidParameterException("Unparseable date/time: " + this.getString(), e);
        }
    }

    public PropertyMap getMap() {
        PropertyMap result = new PropertyMap();
        result.put("", this);
        return result;
    }

    public PropertyArray getArray() {
        PropertyArray result = new PropertyArray();
        result.add(this);
        return result;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        writer = mapper.writer();
    }
}

