/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.cron.Trace;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.searchengine.AdvancedSearchResult;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.searchengine.SortInfo;
import agorum.roi.workers.Job;
import agorum.roi.workers.Worker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class QueryWorker
extends Worker {
    private String cursor;

    protected QueryWorker(String name, int concurrency) {
        super(name, concurrency);
    }

    @Override
    public void start() {
        if (IndexHelper.getIndexHandler(this.stat).supportsAdvancedSearch()) {
            super.start();
        } else {
            this.stat.warning("Unsupported index type");
        }
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        String query;
        SessionController sca;
        Throwable throwable;
        Trace.Auto trace;
        ArrayList<Job> work;
        block35: {
            Serializable serializable;
            block36: {
                block37: {
                    work = new ArrayList<Job>(limit);
                    trace = Trace.auto((String)"Worker collector service");
                    throwable = null;
                    sca = SessionControllerAdmin.getService(QueryWorker.class);
                    if (!idle) {
                        this.stat.debug("Wasn't idle, committing index changes");
                        IndexHandlerInterface i = IndexHelper.getIndexHandler(this.stat);
                        serializable = null;
                        try {
                            i.commit();
                        }
                        catch (Throwable throwable2) {
                            serializable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (i != null) {
                                if (serializable != null) {
                                    try {
                                        i.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)serializable).addSuppressed(throwable3);
                                    }
                                } else {
                                    i.close();
                                }
                            }
                        }
                    }
                    if ((query = this.getQuery()) != null) break block35;
                    serializable = work;
                    if (trace == null) break block36;
                    if (throwable == null) break block37;
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block36;
                }
                trace.close();
            }
            return serializable;
        }
        try {
            try {
                trace.working("collecting data");
                AdvancedSearchResult asr = sca.prepareAdvancedSearch(query).cursor(this.cursor).rows(limit).includeHidden(this.includeHidden()).sort(new SortInfo("updatedate", true)).search(this.getProperties());
                this.stat.debug(asr.rows.size() + " hits (" + asr.total + " total) for query: " + query);
                for (Map<String, AttributeInfo> item : asr.rows) {
                    --limit;
                    work.add(new Job(this.getId(item), () -> {
                        try (Trace.Auto traceW = Trace.auto((String)"Worker work service");){
                            try {
                                long time = System.currentTimeMillis();
                                traceW.working("Doing work");
                                this.work(item);
                                this.stat.measure("Job duration", "ms", System.currentTimeMillis() - time);
                                traceW.ended();
                            }
                            catch (Exception e) {
                                traceW.failed();
                                throw e;
                            }
                        }
                    }));
                }
                if (limit > 0) {
                    if (this.cursor != null) {
                        this.cursor = null;
                        work.addAll(this.collect(limit, true));
                    }
                } else {
                    this.cursor = asr.nextCursor;
                }
                trace.ended();
            }
            catch (Exception e) {
                trace.failed();
                this.stat.error((Throwable)e, "Error while collecting work");
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (trace != null) {
                if (throwable != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    trace.close();
                }
            }
        }
        return work;
    }

    protected abstract boolean includeHidden();

    protected abstract String getQuery();

    protected abstract String[] getProperties();

    protected abstract String getId(Map<String, AttributeInfo> var1);

    protected abstract void work(Map<String, AttributeInfo> var1);
}

