/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.statistic.Statistic;
import agorum.commons.tuple.Pair;
import agorum.roi.common.Startup;
import agorum.roi.ejb.client.beans.AttributeRelationObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AttributeXMLObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.FolderObjectClientBeanWrapper;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.workers.Job;
import agorum.roi.workers.Queue;
import agorum.roi.workers.Worker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MetadataInheritor
extends Worker {
    private static final String METADB_CONCURRENCY = "MAIN_MODULE_MANAGEMENT/workers/MetadataInheritor/Concurrency";
    private static final int OBJECTS_PER_TRANSACTION = 100;
    private static final String ME = MetadataInheritor.class.getName();
    private static final AttributeXMLObjectClientBean[] empty = new AttributeXMLObjectClientBean[0];
    private static final MetadataInheritor instance = new MetadataInheritor();
    private final Queue queue;

    protected MetadataInheritor() {
        super("MetadataInheritor", SessionControllerAdmin.getService(MetadataInheritor.class).getMetaDbInstance().getInt(METADB_CONCURRENCY, 5));
        this.queue = new Queue((Statistic)this.stat, "MetadataInherit", item -> {
            try (Transaction t = new Transaction(false);){
                this.inherit(t, item.getObject(), null, 100, true, item.getData() != null);
                item.done();
                t.commit();
            }
        });
        Startup.whenReady(() -> this.start());
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        return this.queue.collect(limit);
    }

    private static boolean isNotFound(Exception e) {
        return e instanceof RoiException && ((RoiException)e).getErrorCode() == 101;
    }

    public static void queue(GlobalObjectClientBean object) throws Exception {
        if (Transaction.get(ME) == null) {
            MetadataInheritor.instance.queue.queue(object.getId(), "changed", () -> instance.wake());
        }
    }

    public static void inherit(GlobalObjectClientBean object, GlobalObjectClientBean ignoreParent) throws Exception {
        if (Transaction.get(ME) == null) {
            instance.inherit(null, object, ignoreParent, 0, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inherit(Transaction t, GlobalObjectClientBean object, GlobalObjectClientBean ignoreParent, int count, boolean background, boolean changed) throws Exception {
        if (count < 0) {
            this.queue.queue(object.getId(), null, () -> this.wake());
            return count;
        }
        --count;
        if (!object.getSessionController().isMainAdmin()) {
            object = SessionControllerAdmin.getService(MetadataInheritor.class).getGlobalObjectById(object.getId());
        }
        HashSet<AttributeXMLObjectClientBean> toAdd = new HashSet<AttributeXMLObjectClientBean>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (FolderObjectClientBean parent : object.parents()) {
            if (ignoreParent != null && ignoreParent.equals(parent)) continue;
            toAdd.addAll(Arrays.asList(MetadataInheritor.getInheritable(parent)));
        }
        for (Pair pair : this.getInherited(object)) {
            if (toAdd.remove(pair.getSecond())) continue;
            toRemove.add(pair.getFirst());
        }
        if (!toAdd.isEmpty() || !toRemove.isEmpty()) {
            changed = true;
            if (t != null) {
                t.start();
                IndexHelper.disableRealtimeIndex();
            }
            Transaction.put(ME, this);
            try {
                for (AttributeRelationObjectClientBean attributeRelationObjectClientBean : toRemove) {
                    try {
                        object.removeRelationship(attributeRelationObjectClientBean);
                    }
                    catch (Exception e) {
                        if (MetadataInheritor.isNotFound(e)) continue;
                        throw e;
                    }
                    this.stat.count("Relations removed", 1L);
                }
                for (AttributeXMLObjectClientBean attributeXMLObjectClientBean : toAdd) {
                    AttributeRelationObjectClientBeanDefinition def = new AttributeRelationObjectClientBeanDefinition(object.getSessionController());
                    def.setSystemOption("doNotEA", "");
                    def.setSystemOption("doNotLeaveMainObject", "true");
                    try {
                        object.addRelationship(attributeXMLObjectClientBean, (RelationObjectClientBeanDefinition)def);
                    }
                    catch (Exception e) {
                        if (MetadataInheritor.isNotFound(e)) continue;
                        throw e;
                    }
                    this.stat.count("Relations added", 1L);
                }
                SuperObjectClientCachedBean.invalidateCachedObject(object.getId());
                SuperObjectClientBeanDefinition def = object.getNewDefinition(object.getSessionController());
                def.setSystemOption("doNotEA", "");
                new MessageUtils().sendUpdateEvent(object, def);
            }
            finally {
                Transaction.remove(ME);
            }
            this.stat.count("Objects updated", 1L);
        }
        if (background) {
            if (changed && object instanceof FolderObjectClientBean) {
                for (GlobalObjectClientBean item : ((FolderObjectClientBean)object).items()) {
                    if (item instanceof FolderObjectClientBeanWrapper) continue;
                    count = this.inherit(t, item, null, count, background, false);
                }
            }
        } else {
            this.queue.queue(object.getId(), changed ? "changed" : null, null);
        }
        return count;
    }

    private static AttributeXMLObjectClientBean[] getInheritable(GlobalObjectClientBean object) throws Exception {
        AttributeXMLObjectClientBean[] arr = object.getAllAttributeXmlObjects(false, true, false);
        return arr == null ? empty : arr;
    }

    private List<Pair<AttributeRelationObjectClientBean, AttributeXMLObjectClientBean>> getInherited(GlobalObjectClientBean object) throws Exception {
        RelationObjectClientBean[] rels = object.getRightwardRelations(AttributeRelationObjectClientBean.CLASS_NAME);
        ArrayList<Pair<AttributeRelationObjectClientBean, AttributeXMLObjectClientBean>> pairs = new ArrayList<Pair<AttributeRelationObjectClientBean, AttributeXMLObjectClientBean>>();
        if (rels != null) {
            for (RelationObjectClientBean rel : rels) {
                try {
                    AttributeXMLObjectClientBean axo = (AttributeXMLObjectClientBean)rel.getRightObject();
                    if (!axo.isInheritable() || axo.isDirectAttached(object)) continue;
                    pairs.add((Pair<AttributeRelationObjectClientBean, AttributeXMLObjectClientBean>)new Pair((Object)((AttributeRelationObjectClientBean)rel), (Object)axo));
                }
                catch (Exception e) {
                    if (!MetadataInheritor.isNotFound(e)) continue;
                    this.stat.info().exception((Throwable)e).objectId(rel.getId()).send("Found dangling relation, trying to delete");
                    try {
                        rel.delete();
                    }
                    catch (Exception e2) {
                        this.stat.info().exception((Throwable)e2).objectId(rel.getId()).send("Failed to delete dangling relation");
                    }
                }
            }
        }
        return pairs;
    }
}

