/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cron.SystemTimer;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.documentservice.client.common.DocumentServiceStatisticHolder;
import agorum.roi.common.Startup;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.DocumentTextHelper;
import agorum.roi.ejb.common.OpenFileHelper;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.TransactionProperties;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.searchengine.ContentIndexStatistic;
import agorum.roi.workers.Job;
import agorum.roi.workers.Queue;
import agorum.roi.workers.Worker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class ContentExtractor
extends Worker {
    private static final SystemStatistic globalStat = ContentIndexStatistic.getInstance();
    private static final DocumentTextHelper dth = new DocumentTextHelper(new DocumentServiceStatisticHolder(globalStat));
    private static final String METADB_CONCURRENCY_STANDARD = "MAIN_MODULE_MANAGEMENT/workers/ContentExtractor/ConcurrencyStandard";
    private static final String METADB_CONCURRENCY_FAST = "MAIN_MODULE_MANAGEMENT/workers/ContentExtractor/ConcurrencyFast";
    private static final int DEFAULT_CONCURRENCY_STANDARD = 1;
    private static final int DEFAULT_CONCURRENCY_FAST = 1;
    private static Set<String> excludedClasses;
    private static Set<Long> excludedFolders;
    protected static final ContentExtractor extractorStd;
    protected static final ContentExtractor extractorFast;
    private final boolean fast;
    protected final Queue[] queues;

    protected ContentExtractor(String name, String metaDbConcurrency, int defaultConcurrency, boolean fast) {
        super(name, 0);
        this.fast = fast;
        String suffix = fast ? "" : "Slow";
        this.queues = new Queue[]{new Queue((Statistic)this.stat, "TextContentService1" + suffix, item -> this.work(item, 0)), new Queue((Statistic)this.stat, "TextContentService2" + suffix, item -> this.work(item, 1)), new Queue((Statistic)this.stat, "TextContentService3" + suffix, item -> this.work(item, 2))};
        Startup.whenReady(() -> {
            this.setConcurrency(SessionControllerAdmin.getService(ContentExtractor.class).getMetaDbInstance().getInt(metaDbConcurrency, defaultConcurrency));
            this.start();
        });
    }

    public static void reconfigure() {
        MetaDb mdb = SessionControllerAdmin.getService(ContentExtractor.class).getMetaDbInstance();
        extractorStd.setConcurrency(mdb.getInt(METADB_CONCURRENCY_STANDARD, 1));
        extractorFast.setConcurrency(mdb.getInt(METADB_CONCURRENCY_FAST, 1));
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        int remaining;
        if (SessionController.getImportMode() || excludedClasses == null || excludedFolders == null) {
            ContentIndexStatistic.getInstance().setServiceStatus(Statistic.ServiceStatus.DISABLED);
            return new ArrayList<Job>(0);
        }
        ContentIndexStatistic.getInstance().setServiceStatus(Statistic.ServiceStatus.RUNNING);
        ArrayList<Job> work = new ArrayList<Job>(limit);
        work.addAll(this.queues[0].collect(limit / 2));
        work.addAll(this.queues[1].collect(limit / 3));
        work.addAll(this.queues[2].collect(limit / 6));
        for (int i = 0; i < 3 && (remaining = limit - work.size()) > 0; ++i) {
            work.addAll(this.queues[i].collect(remaining));
        }
        return work;
    }

    public static void queue(Long id, int priority) throws Exception {
        extractorFast.queueImpl(id, priority);
    }

    private void queueImpl(Long id, int priority) throws Exception {
        this.queues[priority].queue(id, null, () -> this.wake());
    }

    private void work(Queue.Item item, int priority) throws Exception {
        if (OpenFileHelper.randomFileHash.containsKey(item.getId().toString())) {
            return;
        }
        GlobalObjectClientBean object = item.getObject();
        if (this.skip(object)) {
            this.stat.count("Objects skipped", 1L);
            item.done();
            return;
        }
        ContentIndexStatistic.getInstance().count("Indexed Objects", 1L);
        try (Transaction t = new Transaction(TransactionProperties.getBuildIndexTransactionTimeout());){
            IndexHelper.disableRealtimeIndex();
            if (dth.updateDocumentText(object, this.fast) == null) {
                if (this.fast) {
                    this.debug(object, "Got no text - delegating to standard mode");
                    this.stat.count("Objects delegated", 1L);
                    extractorStd.queueImpl(item.getId(), priority);
                } else {
                    this.stat.warning().object((SystemObjectReference)object).send("Text extraction failed");
                }
            } else {
                this.debug(object, "Got text");
                this.stat.count("Objects extracted", 1L);
                object.getSessionController().reconnectIfNeeded();
                this.reIndex(object);
                GlobalObjectClientBean mainObj = object.getIndexMainObject();
                if (!mainObj.equals(object) && mainObj.hasSubContent()) {
                    this.reIndex(mainObj);
                }
            }
            item.done();
            t.commit();
        }
    }

    private boolean skip(GlobalObjectClientBean object) throws Exception {
        if (!object.hasTextContent()) {
            this.debug(object, "Object has no text content, skipping");
            return true;
        }
        if (object.isTemporary()) {
            this.debug(object, "Object is temporary, skipping");
            return true;
        }
        if (excludedClasses.contains(object.getClassName().toLowerCase())) {
            this.debug(object, "Object class excluded from extraction, skipping");
            return true;
        }
        if (!dth.documentTextNeedsUpdate(object, dth.createDocumentText(object, false, false, false))) {
            this.debug(object, "Nothing new to extract, skipping");
            return true;
        }
        if (object.getIndexMainObject().insideFolders(excludedFolders, true)) {
            this.debug(object, "Object is inside a folder excluded from extraction, skipping");
            return true;
        }
        return false;
    }

    private void reIndex(GlobalObjectClientBean object) throws Exception {
        SuperObjectClientBeanDefinition def = object.getNewDefinition(object.getSessionController());
        def.setSystemOption("doNotEA", "");
        this.debug(object, "Sending update event for text index");
        new MessageUtils().sendUpdateEvent(object, def);
    }

    private static void gatherIds(SessionController sc, String[] pathOrIds, Collection<Long> ids) {
        if (pathOrIds == null) {
            return;
        }
        for (String pathOrId : pathOrIds) {
            if (pathOrId == null || (pathOrId = pathOrId.trim()).isEmpty()) continue;
            try {
                ids.add(Long.parseLong(pathOrId));
            }
            catch (NumberFormatException eIgnored) {
                try {
                    ids.add(sc.findGlobalObjectByPathOrId(pathOrId).getId());
                }
                catch (Exception e) {
                    globalStat.warning((Throwable)e, "Error gathering excluded folders");
                }
            }
        }
    }

    private void debug(GlobalObjectClientBean object, String message) {
        if (!this.stat.logDebug()) {
            return;
        }
        this.stat.debug().indirection(1).object((SystemObjectReference)object).send(message);
    }

    static {
        extractorStd = new ContentExtractor("StandardContentExtractor", METADB_CONCURRENCY_STANDARD, 1, false);
        extractorFast = new ContentExtractor("FastContentExtractor", METADB_CONCURRENCY_FAST, 1, true);
        SystemTimer.ofDelay((long)0L, (long)60000L).call(() -> {
            try {
                SessionController sc = SessionControllerAdmin.getService(ContentExtractor.class);
                HashSet<String> excludedClasses = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(new RoiPropertiesMetaDb(sc).getClassnameNotToTextindex().toLowerCase(), ",");
                while (st.hasMoreElements()) {
                    excludedClasses.add(st.nextToken());
                }
                excludedClasses = excludedClasses;
                HashSet<Long> excludedFolders = new HashSet<Long>();
                ContentExtractor.gatherIds(sc, sc.getMetaDbInstance().getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/textindexservice/control/NotIndexedFolders"), excludedFolders);
                try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(globalStat);){
                    ContentExtractor.gatherIds(sc, indexHandler.getIndexSettingsArray(sc, "SkipPrebuildInFolders"), excludedFolders);
                }
                excludedFolders = excludedFolders;
            }
            catch (Exception e) {
                globalStat.error((Throwable)e, "Error updating exclusion info");
            }
            try {
                globalStat.measure("Content queue size: Creates (number of new objects in index)", ContentExtractor.extractorStd.queues[0].count() + ContentExtractor.extractorFast.queues[0].count());
                globalStat.measure("Content queue size: Updates (number of updated objects in index)", ContentExtractor.extractorStd.queues[1].count() + ContentExtractor.extractorFast.queues[1].count());
                globalStat.measure("Content queue size: Path Updates (number of reindexed or moved objects in index)", ContentExtractor.extractorStd.queues[2].count() + ContentExtractor.extractorFast.queues[2].count());
            }
            catch (Exception e) {
                globalStat.error((Throwable)e, "Error updating queue status");
            }
        });
    }
}

