/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.commons.utils.CSVParser;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.DirectoryUserObjectSessionFacade;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class CSVUserImporter {
    private static final String userAdminBasePath = "agorum/roi/Administration/User/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List importUsersFromCsvFile(SessionController sessionController, InputStream csvInputStream, String passwordDefault, String delim, String parentFolderName) throws Exception {
        ArrayList<DirectoryUserObjectClientBean> resultList = new ArrayList<DirectoryUserObjectClientBean>();
        CSVParser csvParser = new CSVParser();
        if (delim != null && delim.trim().length() > 0) {
            csvParser.setDelimChar(delim.charAt(0));
        }
        ArrayList parsedLines = new ArrayList();
        try {
            parsedLines = csvParser.parseCSV(csvInputStream, true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        int len = parsedLines.size();
        RoiTransactionHandler rth = null;
        for (int i = 0; i < len; ++i) {
            try {
                boolean create = true;
                rth = new RoiTransactionHandler();
                rth.begin();
                if (csvInputStream == null) {
                    throw new Exception("No CSV-File specified");
                }
                DirectoryUserObjectSessionFacade dusf = new DirectoryUserObjectSessionFacade(sessionController);
                Hashtable lineHash = (Hashtable)parsedLines.get(i);
                String firstName = (String)lineHash.get("FirstName");
                String lastName = (String)lineHash.get("LastName");
                String userName = (String)lineHash.get("UserName");
                String userEmail = (String)lineHash.get("MailAddress");
                String password = (String)lineHash.get("Password");
                String language = (String)lineHash.get("Language");
                firstName = firstName != null ? firstName : "";
                lastName = lastName != null ? lastName : "";
                String string = userEmail = userEmail != null ? userEmail : "";
                if (userName == null || userName.length() == 0) {
                    if (firstName.length() > 0 && lastName.length() > 0) {
                        userName = firstName + "." + lastName;
                    } else if (firstName.length() == 0 && lastName.length() > 0) {
                        userName = lastName;
                    }
                }
                if (userName == null || userName.length() == 0) {
                    throw new Exception("Found no User Name in CSV-File");
                }
                DirectoryUserObjectClientBean du = null;
                try {
                    du = sessionController.getUserByName(userName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (du != null) {
                    System.out.println("CSVUserImporter: User not found, create new one.");
                    dusf.setGlobalObject(du);
                    create = false;
                }
                dusf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, userName);
                dusf.setGivenName(firstName);
                dusf.setFamilyName(lastName);
                dusf.setUserName(userName);
                String[] emailAddresses = null;
                if (userEmail.length() == 0) {
                    throw new Exception("Found no mail address for user in CSV-File.");
                }
                emailAddresses = new String[]{userEmail};
                dusf.setEmailAddresses(emailAddresses);
                if (password == null || password.trim().length() == 0) {
                    password = passwordDefault != null && passwordDefault.trim().length() > 0 ? passwordDefault : "agorum";
                }
                if (language == null || language.trim().length() == 0) {
                    language = "de";
                }
                dusf.setPassWord(password);
                dusf.setLanguage(language);
                FolderObjectClientBean parentFolder = null;
                if (parentFolderName != null && parentFolderName.trim().length() > 0) {
                    RoiFileSystem roiFileSystem = new RoiFileSystem(sessionController);
                    parentFolder = roiFileSystem.createFullpath(userAdminBasePath + parentFolderName);
                } else {
                    parentFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(userAdminBasePath);
                }
                dusf.setDestinationFolder(parentFolder);
                du = create ? (DirectoryUserObjectClientBean)dusf.create() : (DirectoryUserObjectClientBean)dusf.update();
                resultList.add(du);
                rth.end();
                rth = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            finally {
                if (rth != null) {
                    rth.abort();
                }
            }
        }
        return resultList;
    }
}

