/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.timephasedaction.actions;

import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessLevel;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.OpenFileHelper;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.timephasedaction.actions.BaseAction;
import agorum.roi.timephasedaction.common.TimePhasedActionUtils;
import java.util.Date;
import java.util.GregorianCalendar;

public class SetExpirationDateAction
extends BaseAction {
    private String timeOffset = null;
    private String timeOffsetUnit = null;
    private String[] setToClassNames = null;
    private String[] filter = null;
    private String filterExclude = null;
    public static Object syncObj = new Object();
    public static boolean isRunning = false;

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        boolean bRet = false;
        if (clientBean instanceof FolderObjectClientBean) {
            String accessLevelSource = this.getMethodParameter(sessionController, "AccessLevelSource", action);
            bRet = clientBean.checkEffectiveAccess(AccessLevel.getAccessLevel(accessLevelSource));
        }
        return bRet;
    }

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, String className, String action) throws Exception {
        boolean bRet = false;
        if (className.equalsIgnoreCase(FolderObjectClientBean.CLASS_NAME)) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public void invokeFast(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        String setNextTimePhasedActionDate;
        if (clientBean != null && action != null && (setNextTimePhasedActionDate = this.getMethodParameter(sessionController, "SetNextTimePhasedActionDate", action)) != null && setNextTimePhasedActionDate.equalsIgnoreCase("TRUE")) {
            TimePhasedActionUtils.setPeriodic(clientBean, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning(SystemStatistic stat) {
        Object object = syncObj;
        synchronized (object) {
            if (!isRunning) {
                isRunning = true;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        try {
            if (clientBean != null && action != null) {
                this.timeOffset = this.getMethodParameter(sessionController, "TimeOffset", action);
                this.timeOffsetUnit = this.getMethodParameter(sessionController, "TimeOffsetUnit", action);
                this.setToClassNames = this.getMethodParameterArray(sessionController, "SetToClassNames", action);
                this.filter = this.getMethodParameterArray(sessionController, "Filter", action);
                this.filterExclude = this.getMethodParameter(sessionController, "FilterExclude", action);
                if (this.timeOffset != null && this.timeOffset.length() > 0 && this.timeOffsetUnit != null && this.timeOffsetUnit.length() > 0 && this.setToClassNames != null && this.setToClassNames.length > 0) {
                    FolderObjectClientBean folder = (FolderObjectClientBean)clientBean;
                    this.setExpirationDateInternal(stat, sessionController, this.getItems(folder));
                }
            }
        }
        finally {
            isRunning = false;
        }
    }

    private void setExpirationDateInternal(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean[] items) throws Exception {
        int len = items != null ? items.length : 0;
        for (int i = 0; i < len; ++i) {
            if (items[i] == null) continue;
            this.setExpirationDate(stat, sessionController, items[i]);
            if (!(items[i] instanceof FolderObjectClientBean)) continue;
            this.setExpirationDateInternal(stat, sessionController, this.getItems((FolderObjectClientBean)items[i]));
        }
    }

    private void setExpirationDate(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        Date d;
        if (this.isSetClassName(clientBean) && this.matchFilter(clientBean) && (d = this.getExpirationDate(clientBean)) != null) {
            if (!(clientBean.isLocked() || clientBean.isLockedForSession() || clientBean.getExpirationDate() != null && clientBean.getExpirationDate().getTime() != 0L || OpenFileHelper.randomFileHash.containsKey("" + clientBean.getId()))) {
                SuperObjectClientBeanDefinition def = clientBean.getNewDefinition(sessionController);
                def.setSystemOption("doNotEA", "true");
                def.setAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(d));
                def.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(clientBean.getLastModifier()));
                clientBean.update(def);
                if (stat.logDebug()) {
                    stat.debug().object((SystemObjectReference)clientBean).send("SetExpirationDateAction to : " + clientBean.getName() + ", Date : " + d);
                }
            } else if (stat.logInfo()) {
                stat.info().object((SystemObjectReference)clientBean).send("Object is still in use, do not set ExpirationDate");
            }
        }
    }

    private Date getExpirationDate(GlobalObjectClientBean clientBean) throws Exception {
        Date dAct;
        int iTimeOffset = Integer.parseInt(this.timeOffset);
        Date dRet = null;
        Date d = dAct = new Date(System.currentTimeMillis());
        int year = d.getYear();
        int month = d.getMonth();
        int date = d.getDate();
        int hours = d.getHours();
        int minutes = d.getMinutes();
        int seconds = d.getSeconds();
        if (this.timeOffsetUnit.equals("y")) {
            year += iTimeOffset;
        } else if (this.timeOffsetUnit.equals("m")) {
            month += iTimeOffset;
        } else if (this.timeOffsetUnit.equals("d")) {
            date += iTimeOffset;
        } else if (this.timeOffsetUnit.equals("h")) {
            hours += iTimeOffset;
        } else if (this.timeOffsetUnit.equals("M")) {
            minutes += iTimeOffset;
        } else if (this.timeOffsetUnit.equals("s")) {
            seconds += iTimeOffset;
        } else {
            ExceptionUtils.handleException("TimeOffsetUnit '" + this.timeOffsetUnit + "' not supported (only: y,m,d,h,M,s)", "agorum.roi.remote.exception.TimeOffsetUnitNotSupported", 40);
        }
        dRet = new GregorianCalendar(year + 1900, month, date, hours, minutes, seconds).getTime();
        return dRet;
    }

    private boolean isSetClassName(GlobalObjectClientBean clientBean) throws Exception {
        int len = this.setToClassNames.length;
        boolean bRet = false;
        for (int i = 0; i < len; ++i) {
            if (!this.setToClassNames[i].equalsIgnoreCase(clientBean.getClassName())) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private boolean matchFilter(GlobalObjectClientBean clientBean) throws Exception {
        boolean bRet = false;
        if (this.filterExclude != null && this.filterExclude.equalsIgnoreCase("TRUE")) {
            bRet = true;
        }
        if (this.filter != null) {
            String name = clientBean.getName();
            int filterLen = this.filter.length;
            for (int i = 0; i < filterLen; ++i) {
                if (!name.matches(this.filter[i])) continue;
                bRet = this.filterExclude == null || !this.filterExclude.equalsIgnoreCase("TRUE");
                break;
            }
        } else {
            bRet = true;
        }
        return bRet;
    }

    private GlobalObjectClientBean[] getItems(FolderObjectClientBean folder) throws Exception {
        GlobalObjectClientBean[] items = folder.getItems(false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE}, new Object[]{new Date(0L)}, new int[]{0}, new boolean[]{false}, new int[]{1}, null, null, null);
        return items;
    }
}

