/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.test;

import agorum.roi.ejb.common.ExceptionUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;

public class TestCycleDirect {
    private Connection conn = null;

    public TestCycleDirect(String[] args) {
        try {
            System.err.println("Driver: \"" + args[0] + "\"");
            Class.forName(args[0]).newInstance();
            String user = args[1];
            String password = args[2];
            String cs = args[3];
            this.conn = DriverManager.getConnection(cs, user, password);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public TestCycleDirect(Connection conn) {
        this.conn = conn;
    }

    public void test() {
        try {
            System.out.println("Connection: " + this.conn.getCatalog());
            String lSelect = "select CYCLELEVEL from FPRCYCLE where RIGHTOBJECT = ? order by CYCLELEVEL";
            PreparedStatement pstmt = this.conn.prepareStatement(lSelect);
            long startFolderId = 4424517L;
            Long subFolderId = 6521421L;
            pstmt.setLong(1, startFolderId);
            ResultSet rSet = pstmt.executeQuery();
            int level = 0;
            if (rSet != null && rSet.next()) {
                level = rSet.getInt(1) + 1;
            }
            rSet.close();
            pstmt.close();
            boolean isInside = this.isFolderInFolder(this.conn, level, startFolderId, subFolderId);
            System.out.print("finished: " + isInside);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFolderInFolder(Connection conn, int levelStartFolder, long startFolderId, long subFolderId) throws Exception {
        if (startFolderId == subFolderId) return true;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select CYCLELEVEL,LEFTOBJECT,RIGHTOBJECT from FPRCYCLE where RIGHTOBJECT = ? and CYCLELEVEL >= ?");
            pstmt.setLong(1, subFolderId);
            pstmt.setInt(2, levelStartFolder);
            rs = pstmt.executeQuery();
            try {
                if (rs == null) return false;
                boolean count = false;
                try {
                    boolean isInside;
                    do {
                        if (!rs.next()) return false;
                    } while (!(isInside = this.isFolderInFolder(conn, levelStartFolder, startFolderId, rs.getLong(2))));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkCycle(Connection conn, int level, long leftObject, long rightObject, long checkObject) throws Exception {
        if (leftObject != checkObject) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = conn.prepareStatement("select CYCLELEVEL,LEFTOBJECT,RIGHTOBJECT from FPRCYCLE where RIGHTOBJECT = ? and CYCLELEVEL < ? order by CYCLELEVEL");
                pstmt.setLong(1, rightObject);
                pstmt.setInt(2, level);
                System.out.println("Checking: " + leftObject + "!=" + rightObject + ", " + level);
                rs = pstmt.executeQuery();
                if (rs == null) return;
                int count = 0;
                Vector<Long> vLo = new Vector<Long>();
                Vector<Long> vRo = new Vector<Long>();
                Vector<Long> vLev = new Vector<Long>();
                while (rs.next()) {
                    ++count;
                    vLo.add(new Long(rs.getLong(2)));
                    vRo.add(new Long(rs.getLong(3)));
                    vLev.add(new Long(rs.getLong(1)));
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (count <= 0) return;
                for (int i = 0; i < count; ++i) {
                    long ro = (Long)vRo.elementAt(i);
                    long lo = (Long)vLo.elementAt(i);
                    System.out.println("  ro=" + ro + ", lo=" + lo + ", lev: " + vLev.elementAt(i) + ", check: " + checkObject);
                    this.checkCycle(conn, level, (Long)vLo.elementAt(i), (Long)vRo.elementAt(i), checkObject);
                }
                return;
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
                return;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        ExceptionUtils.handleException("We have a CYCLE", "agorum.roi.remote.exception.WeHasACycle", 105);
    }

    public void closeConnection() throws Exception {
        this.conn.close();
        this.conn = null;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.err.println("usage : TestCycleDirect <DBDriverName> <DBUser> <DBPassword> <DBUrl> <ROIClassNames> \n Sample (MySql): TestCycleDirect org.mariadb.jdbc.Driver <dbuser>   <dbpassword> jdbc:mariadb://roihost:3306/roi ");
            } else {
                TestCycleDirect testCycleDirect = new TestCycleDirect(args);
                testCycleDirect.test();
                testCycleDirect.closeConnection();
            }
        }
        catch (Exception ex) {
            System.err.println("An exception has been intercepted");
            ex.printStackTrace();
        }
        System.err.println("Programm Ende");
    }
}

