/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.workers;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.statistic.workers.WorkersStatistic;
import agorum.roi.workers.ScriptWorker;
import java.util.Collection;
import java.util.Map;

public class ScriptWorkerAction
extends SystemAction {
    private static final ScriptWorkerAction instance = new ScriptWorkerAction(WorkersStatistic.getInstance().getGroup("Actions"), null, null);
    private final String name;
    private final ScriptWorker worker;

    protected ScriptWorkerAction(Statistic parent, String name, ScriptWorker worker) {
        super(name, parent);
        this.name = name;
        this.worker = worker;
    }

    public static ScriptWorkerAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Script Worker" + (this.name == null ? "" : ": " + this.name);
    }

    public String getShortDescription() {
        return "ScriptWorker " + (this.name == null ? "" : ": " + this.name);
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        int initialConcurrency = 4;
        String initialProducer = "/* global sc, limit, idle */\n\nlet objects = require('common/objects');\n\n";
        String initialConsumer = "/* global sc, data */\n\n";
        if (this.worker != null) {
            initialConcurrency = this.worker.getConcurrency();
            initialProducer = this.worker.getProducer();
            initialConsumer = this.worker.getConsumer();
        }
        FormItem.Collection fields = new FormItem.Collection();
        if (this.name == null) {
            fields.stringField("name").title("Name").description("Worker Name").allowBlank(false).add();
        }
        fields.intField("concurrency").title("Concurrency").description("Worker concurrency level").allowBlank(false).value((Object)initialConcurrency).add();
        fields.scriptField("producer").title("Producer").description("JavaScript code producing work items").allowBlank(false).value((Object)initialProducer).add();
        fields.scriptField("consumer").title("Consumer").description("JavaScript code consuming work items").allowBlank(false).value((Object)initialConsumer).add();
        if (this.name == null) {
            fields.button("save").description("Save as new worker").add();
        } else {
            fields.button("save").description("Update worker script").add();
            fields.button("reset").description("Reset worker").add();
            fields.button("remove").description("Stop and remove worker").add();
        }
        return fields.getCollection();
    }

    /*
     * Unable to fully structure code
     */
    public boolean runActionSync(Map<String, Object> config) throws SystemTaskException {
        try {
            var2_2 = (String)config.get("buttonId");
            var3_4 = -1;
            switch (var2_2.hashCode()) {
                case 3522941: {
                    if (!var2_2.equals("save")) break;
                    var3_4 = 0;
                    break;
                }
                case 108404047: {
                    if (!var2_2.equals("reset")) break;
                    var3_4 = 1;
                    break;
                }
                case -934610812: {
                    if (!var2_2.equals("remove")) break;
                    var3_4 = 2;
                }
            }
            switch (var3_4) {
                case 0: {
                    concurrency = ((Number)config.get("concurrency")).intValue();
                    producer = (String)config.get("producer");
                    consumer = (String)config.get("consumer");
                    if (this.name != null) ** GOTO lbl26
                    name = (String)config.get("name");
                    node = ScriptWorkerAction.create(name, concurrency, producer, consumer);
                    this.setStatisticRedirectionName(node);
                    ** GOTO lbl47
lbl26:
                    // 1 sources

                    t = new Transaction();
                    var8_11 = null;
                    try {
                        this.worker.setConcurrency(concurrency);
                        this.worker.setScripts(producer, consumer);
                        t.commit();
                    }
                    catch (Throwable var9_13) {
                        var8_11 = var9_13;
                        throw var9_13;
                    }
                    finally {
                        if (t != null) {
                            if (var8_11 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable var9_12) {
                                    var8_11.addSuppressed(var9_12);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
lbl47:
                    // 2 sources

                    this.info("Configuration saved");
                    break;
                }
                case 1: {
                    this.worker.reset();
                    this.info("Worker reset successfully");
                    break;
                }
                case 2: {
                    this.worker.remove();
                    this.removeFromParent();
                    this.setStatisticRedirectionName(ScriptWorkerAction.instance.getName());
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return false;
    }

    public static String create(String name, int concurrency, String producer, String consumer) {
        ScriptWorker worker = new ScriptWorker(name, concurrency, producer, consumer);
        worker.start();
        return new ScriptWorkerAction(WorkersStatistic.getInstance().getGroup("Actions"), name, worker).getName();
    }
}

