/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.thread;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.statistic.RoiCheckSuite;
import agorum.roi.statistic.thread.ThreadPool;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class ThreadPoolCheck
extends RoiCheckSuite {
    private static final ThreadPoolCheck instance = new ThreadPoolCheck(CoreStatistic.getInstance().getGroup("Checks"));

    protected ThreadPoolCheck(Statistic parent) {
        super(parent);
    }

    public static ThreadPoolCheck getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Check the amount of threads, that can handle incoming requests";
    }

    public String getShortDescription() {
        return "Thread pool";
    }

    private int countInThreads(Map<Thread, StackTraceElement[]> stackTraces, String protocol, String port) {
        int counter = 0;
        for (Thread thread : stackTraces.keySet()) {
            if (!thread.isAlive() || !thread.getName().contains(protocol) || !thread.getName().contains(port)) continue;
            for (StackTraceElement stackTraceElement : stackTraces.get(thread)) {
                if (!stackTraceElement.getClassName().startsWith("org.apache.tomcat.util.threads.ThreadPool")) continue;
                ++counter;
            }
        }
        return counter;
    }

    protected void initialize(Map<String, Object> args) throws SystemTaskException {
        Map<String, Integer> defaults;
        try {
            defaults = ThreadPool.getDefaults(ThreadPool.getXMLDocument(new FileInputStream(ThreadPool.getServerXML())));
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            this.fail("Unable to get default values", e);
            return;
        }
        this.addCheck("Checking HTTP threads in use", () -> {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            int httpCounter = this.countInThreads(stackTraces, "http", "80");
            float httpPercentage = (float)httpCounter / (float)((Integer)defaults.get("httpMaxThreads")).intValue() * 100.0f;
            String formattedHttp = String.format("%.02f", Float.valueOf(httpPercentage));
            if (httpPercentage < 80.0f) {
                this.ok(formattedHttp + "% of your configured HTTP threads are in use (" + httpCounter + " in total)");
            } else if (httpPercentage > 80.0f) {
                this.warning(formattedHttp + "% your the configured HTTP threads are in use");
            } else if (httpPercentage > 90.0f) {
                this.fail(formattedHttp + "% of your configured HTTP threads are in use");
            }
        });
        this.addCheck("Checking HTTPS threads in use", () -> {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            int httpsCounter = this.countInThreads(stackTraces, "http", "443");
            float httpsPercentage = (float)httpsCounter / (float)((Integer)defaults.get("httpsMaxThreads")).intValue() * 100.0f;
            String formattedHttps = String.format("%.02f", Float.valueOf(httpsPercentage));
            if (httpsPercentage < 80.0f) {
                this.ok(formattedHttps + "% of your configured HTTPS threads are in use (" + httpsCounter + " in total)");
            } else if (httpsPercentage > 80.0f) {
                this.warning(formattedHttps + "% of your configured HTTPS threads are in use");
            } else if (httpsPercentage > 90.0f) {
                this.fail(formattedHttps + "% of your configured HTTPS threads are in use");
            }
        });
        this.addCheck("Check max. HTTP-threads", () -> {
            if ((Integer)defaults.get("httpMaxThreads") < 200) {
                this.warning("Recommended amount of maximal HTTP-threads: 200, your configuration is: " + defaults.get("httpMaxThreads"));
            } else {
                this.ok("Recommended amount of maximal HTTP-threads: 200, your configuration is: " + defaults.get("httpMaxThreads"));
            }
        });
        this.addCheck("Check min. spare HTTP-threads", () -> {
            if ((Integer)defaults.get("httpMinSpareThreads") < 25) {
                this.warning("Recommended amount of minimal spare HTTP-threads: 25, your configuration is: " + defaults.get("httpMinSpareThreads"));
            } else {
                this.ok("Recommended amount of minimal spare HTTP-threads: 25, your configuration is: " + defaults.get("httpMinSpareThreads"));
            }
        });
        this.addCheck("Check max. spare HTTP-threads", () -> {
            if ((Integer)defaults.get("httpMaxSpareThreads") < 75) {
                this.warning("Recommended amount of maximal spare HTTP-threads: 75, your configuration is: " + defaults.get("httpMaxSpareThreads"));
            } else {
                this.ok("Recommended amount of maximal spare HTTP-threads: 75, your configuration is: " + defaults.get("httpMaxSpareThreads"));
            }
        });
        this.addCheck("Check max. HTTPS-threads", () -> {
            if ((Integer)defaults.get("httpsMaxThreads") < 200) {
                this.warning("Recommended amount of maximal spare HTTPS-threads: 200, your configuration is: " + defaults.get("httpsMaxThreads"));
            } else {
                this.ok("Recommended amount of maximal spare HTTPS-threads: 200, your configuration is: " + defaults.get("httpsMaxThreads"));
            }
        });
        this.addCheck("Check min. spare HTTPS-threads", () -> {
            if ((Integer)defaults.get("httpsMinSpareThreads") < 25) {
                this.warning("Recommended amount of minimal spare HTTPS-threads: 25, your configuration is: " + defaults.get("httpsMinSpareThreads"));
            } else {
                this.ok("Recommended amount of minimal spare HTTP-threads: 25, your configuration is: " + defaults.get("httpsMinSpareThreads"));
            }
        });
        this.addCheck("Check max. spare HTTPS-threads", () -> {
            if ((Integer)defaults.get("httpsMaxSpareThreads") < 75) {
                this.warning("Recommended amount of maximal spare HTTPS-threads: 75, your configuration is: " + defaults.get("httpsMaxSpareThreads"));
            } else {
                this.ok("Recommended amount of maximal spare HTTPS-threads: 75, your configuration is: " + defaults.get("httpsMaxSpareThreads"));
            }
        });
    }
}

