/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.thread;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ThreadPool {
    public static final int RECOMMENDED_HTTP_MAX_THREADS = 200;
    public static final int RECOMMENDED_HTTP_MAX_SPARE_THREADS = 75;
    public static final int RECOMMENDED_HTTP_MIN_SPARE_THREADS = 25;
    public static final int RECOMMENDED_HTTPS_MAX_THREADS = 200;
    public static final int RECOMMENDED_HTTPS_MAX_SPARE_THREADS = 75;
    public static final int RECOMMENDED_HTTPS_MIN_SPARE_THREADS = 25;
    public static final String HTTP_CONNECTOR_QUERY = "//Connector[not(@scheme) or @scheme!=\"https\"][not(@protocol) or @protocol=\"HTTP/1.1\"]";
    public static final String HTTPS_CONNECTOR_QUERY = "//Connector[@scheme=\"https\"]";

    public static File getServerXML() throws IOException {
        return new File(System.getProperty("jboss.server.home.dir") + "/deploy/jbossweb-tomcat50.sar/server.xml");
    }

    public static Document getXMLDocument(InputStream input) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        return builder.parse(new FileInputStream(ThreadPool.getServerXML()));
    }

    public static Node getNode(Document doc, String query) throws XPathExpressionException, FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expression = xpath.compile(query);
        return (Node)expression.evaluate(doc, XPathConstants.NODE);
    }

    public static Map<String, Integer> getDefaults(Document doc) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        HashMap<String, Integer> defaults = new HashMap<String, Integer>();
        Node httpConnector = ThreadPool.getNode(doc, HTTP_CONNECTOR_QUERY);
        Node httpsConnector = ThreadPool.getNode(doc, HTTPS_CONNECTOR_QUERY);
        defaults.put("httpMaxThreads", Integer.parseInt(httpConnector.getAttributes().getNamedItem("maxThreads").getNodeValue()));
        defaults.put("httpMinSpareThreads", Integer.parseInt(httpConnector.getAttributes().getNamedItem("minSpareThreads").getNodeValue()));
        defaults.put("httpMaxSpareThreads", Integer.parseInt(httpConnector.getAttributes().getNamedItem("maxSpareThreads").getNodeValue()));
        defaults.put("httpsMaxThreads", Integer.parseInt(httpsConnector.getAttributes().getNamedItem("maxThreads").getNodeValue()));
        defaults.put("httpsMinSpareThreads", Integer.parseInt(httpsConnector.getAttributes().getNamedItem("minSpareThreads").getNodeValue()));
        defaults.put("httpsMaxSpareThreads", Integer.parseInt(httpsConnector.getAttributes().getNamedItem("maxSpareThreads").getNodeValue()));
        return defaults;
    }
}

