/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.logaction;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.LogAction;
import agorum.commons.logging.LogEntry;
import agorum.roi.common.utils.TemplateUtil;
import agorum.roi.ejb.common.SessionControllerAdmin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SendMail
extends LogAction
implements Runnable {
    private static final String PARAM_INTERVAL = "param2";
    private static final String PARAM_RECIPIENT = "param1";
    private static final String PARAM_MAX_EVENTS = "param3";
    private static final Pattern NUMBER = Pattern.compile("(\\d+)\\s*([a-zA-Z]?)");
    private static final String BODY_TEMPLATE = "Dear agorum core administrator,\n\nThis is an automated message generated by the Support Tool.You are receiving this email, because a log action has been configured for the statistic node ${statistic}.\n\nYour configured log action settings were:\nPattern: ${params.pattern}\nAction type: ${params.action}\nMail address: ${params.param1}\nInterval: ${params.param2}\nMax count: ${params.param3}\nStop on match: ${params.stopOnMatch}\n\n${messages.size} messages have been logged since the last time you received this notification (showing at most ${params.param3} entries):\n\n${messages.list}";
    private long interval;
    private long timeNextSend;
    private BlockingQueue<LogEntry> entries = new LinkedBlockingQueue<LogEntry>();
    private SystemTimer sendTimer = SystemTimer.ofPeriod((long)30000L).name("LogActionSendMail").call((Runnable)this);

    public static final void registerSelf() {
        LogAction.register((String)"SEND_MAIL", () -> new SendMail());
    }

    protected void execute(LogEntry entry) {
        this.entries.offer(entry);
    }

    protected void init() {
        super.init();
        Matcher m = NUMBER.matcher(this.params.getString(PARAM_INTERVAL));
        if (m.find()) {
            long val = Long.parseLong(m.group(1));
            String uni = m.group(2);
            switch (uni == null ? "" : uni) {
                case "s": {
                    val *= 1000L;
                    break;
                }
                default: {
                    val *= 60000L;
                    break;
                }
                case "h": {
                    val *= 3600000L;
                    break;
                }
                case "d": {
                    val *= 86400000L;
                }
            }
            this.interval = val;
        } else {
            this.interval = 900000L;
        }
    }

    @Override
    public void run() {
        try {
            if (this.entries.isEmpty()) {
                return;
            }
            if (System.currentTimeMillis() < this.timeNextSend) {
                return;
            }
            ArrayList queue = new ArrayList();
            this.entries.drainTo(queue);
            long maxEvents = this.params.getLong(PARAM_MAX_EVENTS, Long.valueOf(10L));
            String recipient = this.params.getString(PARAM_RECIPIENT);
            StringBuilder messages = new StringBuilder();
            int count = 0;
            for (LogEntry en : queue) {
                if ((long)(++count) > maxEvents) break;
                if (count > 1) {
                    messages.append("\n==========\n\n");
                }
                messages.append(en.toString());
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("params", this.params);
            HashMap<String, Object> messagemap = new HashMap<String, Object>();
            messagemap.put("size", queue.size());
            messagemap.put("list", messages.toString());
            parameters.put("messages", messagemap);
            parameters.put("statistic", this.stat.getName());
            new agorum.roi.ejb.agents.mail.SendMail(SessionControllerAdmin.getSessionControllerAdmin("SendMail")).sendSimpleMail(recipient.split(";"), null, null, "agorum core logging notification: " + this.stat.getName(), TemplateUtil.fillTemplate(parameters, BODY_TEMPLATE));
            this.timeNextSend = System.currentTimeMillis() + this.interval;
        }
        catch (Exception e) {
            this.stat.error().exception((Throwable)e).send("Log Action: Unable to send mail");
        }
    }

    public void stop() {
        this.sendTimer.cancel();
    }
}

