/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.config;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.statistic.MetaDbSource;
import java.util.Collection;
import java.util.Map;

public class LogFileCleanerConfig
extends SystemConfig {
    private static final String BASE_KEY = "MAIN_MODULE_MANAGEMENT/cronjob/control/LogFileCleanupService";
    private static final LogFileCleanerConfig instance = new LogFileCleanerConfig(CoreStatistic.getInstance().getGroup("Configurations"));
    private FormItem.Collection form;

    protected LogFileCleanerConfig(Statistic parent) {
        super(parent);
    }

    public static LogFileCleanerConfig getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Configures automatic cleanup of server log files.";
    }

    public String getShortDescription() {
        return "Log cleanup configuration";
    }

    public void formButton(Map<String, Object> args) {
        if (LogFileCleanerConfig.isButton((String)"save", args)) {
            this.form.storeValues(args);
        }
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        long daysBeforeDelete;
        long daysBeforeArchive;
        this.form = new FormItem.Collection();
        try (MetaDbUtil mdbu = new MetaDbAccessor(this.getName()).getReadUtil(BASE_KEY);){
            daysBeforeArchive = mdbu.getLong("DaysBeforeArchive", 7L);
            daysBeforeDelete = mdbu.getLong("DaysBeforeDelete", 14L);
        }
        this.form.boolField("enabled").title("Enabled").dataSource((FormItem.DataSource)new MetaDbSource(BASE_KEY, "Enabled")).description("Enable this cron job.").add();
        this.form.intField("daysBeforeArchive").title("Days before archiving").dataSource((FormItem.DataSource)new MetaDbSource(BASE_KEY, "DaysBeforeArchive")).value((Object)daysBeforeArchive).description("The number of days to elapse before a log file is archived.").allowBlank(true).add();
        this.form.intField("daysBeforeDelete").title("Days before deleting").dataSource((FormItem.DataSource)new MetaDbSource(BASE_KEY, "DaysBeforeDelete")).value((Object)daysBeforeDelete).description("The number of days to elapse before a log file or archive is deleted.").allowBlank(true).add();
        this.form.stringField("cronTime").title("Cron time").dataSource((FormItem.DataSource)new MetaDbSource(BASE_KEY, "CronTime")).description("Specify the cron time for this job.").allowBlank(false).add();
        return this.form.getCollection();
    }
}

